<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CmsPage;
use App\Rules\MaxWords;

class CMSController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:admin');
    }
    
    public function index()
    {
        $data = CmsPage::first();

        if ($data) {
            return view('admin.cms.edit', compact('data'));
        } else {
            return view('admin.cms.create');
        }
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'privacy_policy' => ['required', new MaxWords(80)],
            'terms_condition' => ['required', new MaxWords(80)],
            'disclaimer' => ['required', new MaxWords(80)],
            'cookie_policy' => ['required', new MaxWords(80)],
            'others' => ['required', new MaxWords(80)],
        ]);
        
    
        $page = CmsPage::first();
    
        if ($page) {
            $page->update($request->all());
            return redirect()->route('admin.pages.create')->with('success', 'CMS page updated successfully');
        } else {
            CmsPage::create($request->all());
            return redirect()->route('admin.pages.create')->with('success', 'CMS page created successfully');
        }
    
    }
    



}
