<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Contact;
use App\Models\ContactWidget;
// use Yajra\DataTables\Facades\Datatables;
use DataTables;

class ContactController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:admin');
    }
    public function index()
    {
        return view('admin.enquiry.index');
        // $contacts = Contact::orderByDesc('updated_at')->paginate(10);
        // return view('admin.enquiry.index', compact('contacts'));
    }

    public function getData(Request $request)
    {
        if ($request->ajax()) {
            $data = Contact::orderByDesc('updated_at')->get();
            return DataTables::of($data)
                    ->addIndexColumn()
                    ->addColumn('action', function($row){
       
                            $btn = '<a href="'.route('admin.contacts.show', $row->id).'" class="btn btn-primary btn-sm">View</a>';
      
                            return $btn;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
        }
    }

    public function contact_widget()
    {
        $data = ContactWidget::first();

        if ($data) {
            return view('admin.enquiry.contact_widget', compact('data'));
        } else {
            return view('admin.enquiry.contact_widget');
        }
    }

    public function storeWidget(Request $request)
    {

        // dd($request->all());
        $request->validate([
            'opening_day_from' => 'required',
            'opening_day_to' => 'required',
            'opening_time_from' => 'required',
            'opening_time_to' => 'required',
            'contact_number' => 'required',
            'address' => 'required',
        ]);
        ContactWidget::create($request->all());
        // Redirect back or to a success page
        return redirect()->back()->with('success', 'Contact information saved successfully.');
    }

    public function updateWidget(Request $request)
    {
        $request->validate([
            'opening_day_from' => 'required',
            'opening_day_to' => 'required',
            'opening_time_from' => 'required',
            'opening_time_to' => 'required',
            'contact_number' => 'required',
            'address' => 'required',
        ]);

        // Retrieve the ContactWidget instance you want to update
        $contactWidget = ContactWidget::find($request->id);

        if ($contactWidget) {
            $contactWidget->update($request->all());
            return redirect()->back()->with('success', 'Contact information updated successfully.');
        } else {
            return redirect()->back()->with('error', 'Contact information not found.');
        }
    }

    public function show($id)
    {
        $contact = Contact::findOrFail($id);

        return view('admin.enquiry.show', compact('contact'));
    }

}
