<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\GameDetail;
use App\Models\TicketSequence;
use Illuminate\Http\Request;
use App\Models\Ticket;
use DataTables;

class TicketManagementController extends Controller
{
    public function index($gameId)
    {
        $game = GameDetail::findOrFail($gameId);
        $tickets = Ticket::where('game_id', $gameId)->get();
        return view('admin.ticket_management.list', compact('game', 'tickets'));
    }

    public function fetchData(Request $request)
    {
         
        if ($request->ajax()) {
            $data = Ticket::orderByDesc('updated_at')->get();
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row) {
                    $btn = '<div class="btn-group" role="group" aria-label="Button Group">
                    <a href="'.route('admin.show.ticket', ['id'=>$row->id]).'" class="btn btn-primary btn-sm me-1">VIEW</a>
                </div>';
        
                    return $btn;
                })
                ->editColumn('created_at', function($row) {
                    if ($row->created_at) {
                        return $row->created_at->format('Y-m-d');
                    }
                    return null;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
    }

    public function show_ticket($id) {

        $data = Ticket::find($id);
        $game = GameDetail::find($data->game_id);
        $ticket_sequences = TicketSequence::where('ticket_id', $data->id)->take(6)->get();
        return view('admin.ticket_management.show_ticket', compact('data', 'game','ticket_sequences'));
    }
}
