<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
// use Yajra\DataTables\Facades\Datatables;
use Yajra\DataTables\Html\Builder;
use DataTables;


class UserController extends Controller
{
    public function index()
    {

        return view('admin.users.list');
    }

    public function getUsersList(Request $request)
    {
        
        if ($request->ajax()) {
            $data = User::orderByDesc('updated_at')->get();
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row) {
                    $btn = '<div class="btn-group" role="group" aria-label="Button Group">
                    <a href="#" class="btn btn-primary btn-sm me-1">VIEW</a>
                    <a href="#" class="btn btn-primary btn-sm me-1">TICKETS</a>
                    <a href="#" class="btn btn-primary btn-sm me-1">TRANSACTIONS</a>
                    <a href="'.route('admin.wallet.create', $row->id).'" class="btn btn-primary btn-sm me-1">Wallet</a>
                </div>';
        
                    return $btn;
                })
                ->editColumn('created_at', function($row) {
                    if ($row->created_at) {
                        return $row->created_at->format('Y-m-d');
                    }
                    return null;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
        
        
    }
}
