<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Models\User;

class WalletController extends Controller
{
    public function create($id)
    {
        $user = User::findOrFail($id);
        $wallet = Wallet::where('user_id', $user->id)->first();
        
        if (!$wallet) {
            return view('admin.wallet.create', compact('user'))->withErrors(['error' => 'Wallet not found.']); // Customize the error message here
        }
        
        $wallet_transactions = WalletTransaction::where('wallet_id', $wallet->id)->paginate(10);
        
        if (request()->ajax()) {
            return view('admin.wallet.create', compact('wallet', 'wallet_transactions', 'user'));
        }
        
        return view('admin.wallet.create', compact('wallet', 'wallet_transactions', 'user'));
    }

    
    public function store(Request $request)
    {
        $user_id = $request->input('user_id');
        
        $wallet = Wallet::where('user_id', $user_id)->first();
        
        if (!$wallet) {
            $wallet = new Wallet();
            $wallet->user_id = $user_id;
        }
        
        $wallet->amount += $request->input('amount');
        $wallet->save();
        
        $walletTransaction = new WalletTransaction();
        $walletTransaction->amount = $request->input('amount');
        $walletTransaction->type = '1';
        // Add any other necessary fields for the WalletTransaction model
        $walletTransaction->wallet_id = $wallet->id; // Associate the WalletTransaction with the Wallet
        $walletTransaction->save();

        if (request()->ajax()) {
            $wallet_transactions = WalletTransaction::where('wallet_id', $wallet->id)->paginate(10);
            return view('admin.wallet.create', compact('wallet_transactions'));
        }
        
        return redirect()->back()->with('success', 'Amount added successfully.');
    }
}
