<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\GameRange;
use Illuminate\Http\Request;
use App\Models\GameDetail;
use App\Models\Ticket;
use App\Models\TicketSequence;
use App\Models\WinningNumber;
use PDF;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;



class TicketController extends Controller
{
    public function create($id)
    {
        $gameDetail = GameDetail::find($id);
        $ticket = Ticket::where('user_id', Auth::id())->Where('game_id', $id)->first();
        $ticket_number_range = GameRange::where('game_id', $id)->get();
        // dd($ticket);
        return view('front.ticket.create', compact('gameDetail','ticket','ticket_number_range'));
    }

    public function show_ticket($id)
    {
        // Fetch the ticket along with its associated ticket sequences
        $ticket = Ticket::where('id',$id)->first();
        // dd($ticket);
        $game = GameDetail::where('id', $ticket->game_id)->first();
        $ticketDetails = TicketSequence::where('ticket_id', $ticket->id)->get();

        // dd($ticketDetails);

        // Check if the ticket exists
        if (!$ticket) {
            // Handle the case when the ticket does not exist, such as showing an error message or redirecting
            return redirect()->back()->with('error', 'Ticket not found.');
        }

        // Return the ticket and its associated ticket sequences to the view
        return view('front.ticket.ticket_show', compact('ticket','ticketDetails','game'));
    }


    public function store(Request $request)
    {
        // dd($request->all());
        $gameDetail = GameDetail::find($request->game_id);
        $maxAllowedTickets = $gameDetail->game_total_allowed_ticket;

        // $request->validate([
        //     'game_id' => 'required',
        //     'price' => 'required|numeric',
        //     // 'ticket_sequence' => ['required', 'array', "size:$maxAllowedTickets"],
        //     // 'ticket_sequence.*' => ['required', Rule::in(range(0, 99))],
        //     // 'name' => ['required', 'array', "size:$maxAllowedTickets"],
        // ]);

        $ticket = new Ticket();
        $ticket->game_id = $request->input('game_id');
        $ticket->price = $request->input('price');
        $ticket->status = 1;
        $ticket->user_id = Auth::id();
        $randomNumber = str_pad(rand(0, 99999), 5, '0', STR_PAD_LEFT);
        $ticket->ticket_code = 'TICKET_' . $randomNumber;
        $ticket->save();

        $ticketSequences = $request->input('ticket_number')[0];

        $ticketSequences = $request->input('ticket_number');

        $position = 1; // Initialize the position counter

        foreach ($ticketSequences as $index => $ticketSequenceArray) {
            foreach ($ticketSequenceArray as $subIndex => $ticketSequence) {
                $ticketSequenceModel = new TicketSequence();
                $ticketSequenceModel->ticket_id = $ticket->id;
                $ticketSequenceModel->winning_sequence = $ticketSequence;
                $ticketSequenceModel->position = $position; // Set the position value
                $ticketSequenceModel->save();
            }
            
            $position++; // Increment the position counter
        }

    
        $lastTicket = Ticket::latest()->first();

        $ticket_sequences_new = TicketSequence::where('ticket_id', $lastTicket->id)->get();
        $totalPairs = $ticket_sequences_new->count() / 6;
        // Call the static function TicketWinner()
        $ticket_sequences = self::TicketWinner();
        // dd($ticket_sequences);
        return view('front.ticket.ticket_show', compact('ticket_sequences_new','ticket_sequences','lastTicket','totalPairs','gameDetail'));

        // return redirect()->route('user.show.ticket', ['id' => $ticket->id]);
    }

    public static function TicketWinner()
    {

        $ticket_sequences = [];
        // First of all, find the games with the draw date today
        $today = Carbon::now()->format('Y-m-d'); // Get today's date in the 'Y-m-d' format

        $games = GameDetail::where('game_status', 1)
            ->select('game_code', 'game_ticket_prize', 'game_title', 'id')
            ->get()
            ->toArray();
        // dd($games);

        foreach ($games as $game) {
            $total_tickets = Ticket::where('game_id', $game['id'])->where('status', 1)
                ->select('ticket_code', 'price', 'id')
                ->get()
                ->toArray();

            foreach ($total_tickets as $ticket) {
                $ticket_sequences = TicketSequence::where('ticket_id', $ticket['id'])
                    ->select('winning_sequence', 'id', 'position') // Add 'position' to the select statement
                    ->get()
                    ->toArray();

                $totalPrize = 0; // Variable to store the total prize for the ticket

                foreach ($ticket_sequences as $sequence) {
                    $matchingNumbers = []; // Array to store matching numbers
                    $digits = explode(',', $sequence['winning_sequence']);

                    foreach ($digits as $digit) {
                        $matchingNumber = WinningNumber::where('number', $digit)->first();

                        if ($matchingNumber) {
                            // Matching number found
                            $matchingNumbers[] = $digit;
                        }
                    }

                    if (!empty($matchingNumbers)) {
                        // Matching numbers found
                        foreach ($matchingNumbers as $matchingNumber) {
                            // Fetch the number from the winning numbers table and multiply it by the ticket price
                            $number = WinningNumber::where('number', $matchingNumber)->value('sequence');
                            $prize = $number * $ticket['price'];
                            $totalPrize += $prize;

                            // echo "Game ID: " . $game['id'] . " | Ticket ID: " . $ticket['id'] . " | Position: " . $sequence['position'] . " | Matching Number: " . $matchingNumber . "<br>";
                        }

                        // Update the status field of the ticket sequence to 2
                        TicketSequence::where('id', $sequence['id'])->update(['status' => 2]);
                    } else {
                        // No matching numbers found
                        // Update the status field of the ticket sequence to 3
                        // echo "Game ID: " . $game['id'] . " | Ticket ID: " . $ticket['id'] . " | Position: " . $sequence['position'] . " | No matching numbers found" . "<br>";

                        TicketSequence::where('id', $sequence['id'])->update(['status' => 3]);
                    }

                    // Update the position field of the ticket sequence
                    // TicketSequence::where('ticket_id', $ticket['id'])
                    //     ->where('position', $sequence['position'])
                    //     ->update(['position' => $sequence['position'] + 1]);
                }

                // Add the total prize to the ticket record
                Ticket::where('id', $ticket['id'])->update(['win_amount' => $totalPrize]);
                // Fetch the last created ticket
            $lastTicket = Ticket::latest()->first();

            if ($lastTicket) {
                $ticket_sequences = TicketSequence::where('ticket_id', $lastTicket->id)->get();
                // dd($ticket_sequences);
                // return view('front.ticket.ticket_show', compact('ticket_sequences'));
            }
        }
    }

    return $ticket_sequences;
    }

    public function generateInvoicePDF($data)
    {
        $ticketData = Ticket::find($data);
        $gameData = GameDetail::where('id', $ticketData->game_id)->first();
        $ticketSequences = TicketSequence::where('ticket_id', $data)->get();
        $pdf = PDF::loadView('front.ticket.invoice_ticket', compact('ticketData', 'gameData', 'ticketSequences'));
        return $pdf->download('lotto-ticket.pdf');
    }

    public function view_ticket()
    {
        $ticket = '1';
        return view('front.profile.myaccount', compact('ticket'));
    }
   
    public function result()  
    {
        return view('result');
    }
    

}
