<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use File;
use ImgUploader;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth')->except('dropzoneFileUpload');
    }

    //
    public function index()
    {
        return view('front.profile.myaccount');
    }

    public function update(Request $request)
    {
        $user = Auth::user(); // Get the authenticated user

        // Update the name
        $user->name = $request->input('name');

        // Update the email
        $user->email = $request->input('email');

        // Update the phone number
        $user->phone = $request->input('phone');

        // Handle the uploaded image
        // if ($request->hasFile('image')) {
        //     // Get the uploaded image
        //     $image = $request->file('image');

            // Validate the image
            // $validator = Validator::make(['image' => $image], [
            //     'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            // ]);

            // if ($validator->fails()) {
            //     return redirect()->back()->withErrors($validator)->withInput();
            // }

            // Delete the existing image (if any)
            // if (!empty($user->image)) {
            //     $this->deleteImage($user->image);
            // }

            // Upload the new image
            // $imagePath = $this->uploadImage($image);

            // // Update the image path in the database
            // $user->image = $imagePath;
        // }

        // Save the updated user
        $user->save();

        return redirect()->back()->with('success', 'Profile updated successfully!');
    }


    public  function dropzoneFileUpload(Request $request)  
    {  
        $image = $request->file('file');
        $imageName = time().'.'.$image->extension(); 
        $image->move(public_path('profile_images'),$imageName);  
        return response()->json(['success'=>$imageName]);
    }



    private function deleteImage($imagePath)
    {
        // Delete the image file from the storage
        if (file_exists(public_path($imagePath))) {
            unlink(public_path($imagePath));
        }
    }

    private function uploadImage($image)
    {
        // Generate a unique filename
        $filename = uniqid() . '_' . time() . '.' . $image->getClientOriginalExtension();

        // Define the storage path
        $storagePath = 'profile_images/';

        // Create the ProfilePics folder if it doesn't exist
        if (!File::isDirectory(public_path($storagePath))) {
            File::makeDirectory(public_path($storagePath));
        }

        // Move the uploaded image to the storage path
        $image->move(public_path($storagePath), $filename);

        // Return the image path to be stored in the database
        return $storagePath . $filename;
    }
}