<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\GameDetail;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth')->except('front','filterGames');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('admin.dashboard');
    }

    public function front()
    {
        $gameList = GameDetail::where('game_status', 1)
        ->orderBy('game_end_date', 'asc')
        ->get();
    
        $categoryList = Category::latest()->get();
        return view('welcome', compact('categoryList','gameList'));
    }

    public function filterGames(Request $request)
    {
        $gameDate = $request->input('game_date');
        $categoryId = $request->input('category_id');
    
        if ($gameDate) {
            $gameEndDates = GameDetail::whereDate('game_end_date', $gameDate)->pluck('game_end_date');
            $otherGames = GameDetail::whereDate('game_end_date', '!=', $gameDate)->get();
    
            // Concatenate the games with the selected date first and the remaining games
            $filteredGames = GameDetail::whereIn('game_end_date', $gameEndDates)->get()->concat($otherGames);
        } elseif ($categoryId) {
            $selectedCategoryGames = GameDetail::where('game_category', $categoryId)->get();
            $otherCategoryGames = GameDetail::where('game_category', '!=', $categoryId)->get();
            $filteredGames = $selectedCategoryGames->concat($otherCategoryGames);
        } else {
            // Handle the case when neither game_date nor category_id is provided
            // Return an appropriate response or perform necessary actions
            return response()->json(['error' => 'Invalid request'], 400);
        }
    
        // Return the filtered games as a JSON response
        return response()->json(['games' => $filteredGames]);
    }
    


}
