<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class MaxWords implements ValidationRule
{

    public $maxWords;

    public function __construct($maxWords)
    {
        $this->maxWords = $maxWords;
    }
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        //
    }

    public function passes($attribute, $value)
    {
        $wordCount = str_word_count(strip_tags($value));
        return $wordCount <= $this->maxWords;
    }

}
