<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('game_details', function (Blueprint $table) {
            $table->id();
            $table->string('game_code');
            $table->string('game_title');
            $table->text('game_description');
            $table->date('game_start_date');
            $table->date('game_end_date');
            $table->time('game_start_time');
            $table->time('game_end_time');
            $table->date('game_draw_date');
            $table->time('game_draw_time');
            $table->string('game_time_zone');
            $table->integer('game_total_allowed_ticket');
            $table->float('game_ticket_prize');
            $table->integer('game_min_range');
            $table->integer('game_max_range');
            $table->string('game_status');
            $table->timestamps();
        });        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('game_details');
    }
};
