@extends('admin.layouts.app')
<style>
    #remove-image {
           display: none;
       }
   
       #image-preview-container:hover #remove-image {
           display: block;
       }
   </style>
@section('content')

    <div class="container">
        <div class="card">
            <div class="card-body">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
                </div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif
        <h1>Create Advertisement</h1>
        <a href="{{ route('admin.advertisements.index') }}" class="btn btn-primary">
            <i class="fas fa-arrow-left"></i> Back
          </a>
          
        <form action="{{ route('admin.advertisements.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label for="page">Page<span class="text-danger">*</span></label>
                <select name="page" id="page" class="form-control" required>
                    <option value="">Select Page</option>
                    @foreach ($pages as $page)
                        <option value="{{ $page->id }}">
                            {{ $page->page_name }}
                        </option>
                    @endforeach
                </select>
                @if ($errors->has('page'))
                    <span class="text-danger">{{ $errors->first('page') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label for="position">Position<span class="text-danger">*</span></label>
                <select name="position" id="position" class="form-control" required disabled>
                    <option value="">Select Position</option>
                    @foreach ($positions as $position)
                        <option value="{{ $position->id }}">
                            {{ $position->position }}
                        </option>
                    @endforeach
                </select>
                @if ($errors->has('position'))
                    <span class="text-danger">{{ $errors->first('position') }}</span>
                @endif
                <img id="previewImage" src="{{ asset('/AdvertisementDefault.png') }}" alt="Preview Image" width="400px" height="300px" style="display:none;">
            </div>
            <div id="positionData" style="display: none;">
                <p style="color:red;">Note: Image Height: <span id="imageHeight"></span>Image Width: <span id="imageWidth"></span></p>
            </div>
            
            <div class="form-group">
                <label for="image">Image:<span class="text-danger">*</span></label>
                <input type="file" class="form-control" id="image" name="image">
                <div id="image-preview-container" style="display: none;">
                    <img id="image-preview" src="#" alt="Image Preview" style="max-width: 200px; max-height: 200px;">
                    <span id="remove-image">❌</span>
                </div>
                @error('image')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
            

            <div class="form-group">
                <label for="redirection_url">Redirection URL<span class="text-danger">*</span></label>
                <input type="text" name="redirection_url" id="redirection_url" class="form-control">
                @if ($errors->has('redirection_url'))
                    <span class="text-danger">{{ $errors->first('redirection_url') }}</span>
                @endif
            </div>
            <button type="submit" class="btn btn-primary">Create</button>
        </form>
    </div>
</div>
</div>
@endsection
@push('scripts')
    <script>

$(document).ready(function() {

    $('#page').change(function() {
        var selectedPage = $(this).val();
        var positionSelect = $('#position');

        if (selectedPage) {
            positionSelect.prop('disabled', false);
        } else {
            positionSelect.prop('disabled', true);
        }
    });
 
        $('#position').change(function() {
            var selectedPosition = $(this).val();

            // Example data for different positions
            var positionData = {
                "1": {
                    "imageHeight": "200px",
                    "imageWidth": "200px"
                },
                "2": {
                    "imageHeight": "200px",
                    "imageWidth": "200px"
                },
                "3": {
                    "imageHeight": "100px",
                    "imageWidth": "100px"
                },
                "4": {
                    "imageHeight": "100px",
                    "imageWidth": "100px"
                },
                // Add more positions as needed
            };

            if (positionData.hasOwnProperty(selectedPosition)) {
                var data = positionData[selectedPosition];

                // Update the div with the dynamic data
                $('#positionText').text(data.positionText);
                $('#imageHeight').text(data.imageHeight);
                $('#imageWidth').text(data.imageWidth);

                // Show the div
                $('#positionData').show();
            } else {
                // Hide the div if no position is selected
                $('#positionData').hide();
            }
        });
    });

    $('#position').change(function() {
    var selectedValue = $(this).val();
    var selectedPage = $('#page').val();
    var positionSelect = $(this);

    if (selectedValue && selectedPage) {
        $.ajax({
            url: '{{ route("admin.ad-position-check") }}',
            type: 'POST',
            data: {
                page: selectedPage,
                position: selectedValue,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if (response.exists) {
                    Swal.fire({
                        title: 'Position already taken',
                        text: 'Please select a different position',
                        icon: 'warning',
                        confirmButtonText: 'OK',
                        width: '300px',
                        padding: '0.5rem'
                    }).then(function() {
                        positionSelect.val('');
                    });
                }
            },
            error: function(xhr, status, error) {
                console.log(error);
            }
        });
    }
});


        // $(document).ready(function() {
        //     $('#position').on('change', function() {
        //         var selectedValue = $(this).val();
        //         $.ajax({
        //             url: '{{ route("admin.ad-position-check") }}',
        //             type: 'POST',
        //             data: {
        //                 position: selectedValue,
        //                 _token: '{{ csrf_token() }}'
        //             },
        //             success: function(response) {
        //                 if (response.exists) {
        //                     Swal.fire({
        //                         title: 'Position already taken',
        //                         text: 'Please select a different position',
        //                         icon: 'warning',
        //                         confirmButtonText: 'OK',
        //                         width: '300px',
        //                         padding: '0.5rem'
        //                     }).then(function() {
        //                         $('#position').val('');
        //                     });
        //                 }
        //             },
        //             error: function(xhr, status, error) {
        //                 console.log(error);
        //             }
        //         });
        //     });
        // });


        $(document).ready(function() {
        $('#position').on('change', function() {
            var selectedOption = $(this).val();
            var previewImage = $('#previewImage');

            if (selectedOption) {
                previewImage.css('display', 'block');
            } else {
                previewImage.css('display', 'none');
            }
        });

        $('#image').on('change', function(event) {
            var input = event.target;
            var reader = new FileReader();
            var previewContainer = $('#image-preview-container');
            var preview = $('#image-preview');
            var removeImageBtn = $('#remove-image');

            reader.onload = function() {
                preview.attr('src', reader.result);
                previewContainer.css('display', 'block');
                removeImageBtn.css('display', 'block');
            };

            if (input.files && input.files[0]) {
                reader.readAsDataURL(input.files[0]);
            }
        });

        $('#remove-image').on('click', function() {
            var input = $('#image');
            var previewContainer = $('#image-preview-container');
            var preview = $('#image-preview');
            var removeImageBtn = $('#remove-image');

            input.val('');
            preview.attr('src', '#');
            previewContainer.css('display', 'none');
            removeImageBtn.css('display', 'none');
        });
    });
    </script>
@endpush
