@extends('admin.layouts.app')

@section('content')
    <div class="container">
        <div class="container">
            <div class="card">
                <div class="card-body">
        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif
        <h1>Edit Advertisement</h1>
        <a href="{{ route('admin.advertisements.index') }}" class="btn btn-primary">
            <i class="fas fa-arrow-left"></i> Back
        </a>
        <form action="{{ route('admin.advertisements.update', $advertisement) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="form-group">
                <label for="page">Page<span class="text-danger">*</span></label>
                <select name="page" id="page" class="form-control" required>
                    <option value="">Select Page</option>
                    @foreach ($pages as $page)
                        <option value="{{ $page->id }}" {{ $advertisement->page == $page->id ? 'selected' : '' }}>
                            {{ $page->page_name }}
                        </option>
                    @endforeach
                </select>
                @if ($errors->has('page'))
                    <span class="text-danger">{{ $errors->first('page') }}</span>
                @endif
          </div>
            

          <div class="form-group">
            <label for="position">Position<span class="text-danger">*</span></label>
            <select name="position" id="position" class="form-control" required>
                <option value="">Select Position</option>
                @foreach ($positions as $position)
                    <option value="{{ $position->id }}" {{ $advertisement->position == $position->id ? 'selected' : '' }}>
                        {{ $position->position }}
                    </option>
                @endforeach
            </select>
            @if ($errors->has('position'))
                <span class="text-danger">{{ $errors->first('position') }}</span>
            @endif
        </div>
        
        <div class="form-group">
            <label for="image">Image<span class="text-danger">*</span></label>
            <div id="image-preview-container">
                @if($imageUrl)
                    <img id="image-preview" src="{{ asset($advertisement->image) }}" alt="Image Preview" style="max-width: 200px; max-height: 200px;">
                    <span id="remove-image">❌</span>
                @else
                    <img id="image-preview" src="#" alt="Image Preview" style="max-width: 200px; max-height: 200px; display: none;">
                    <span id="remove-image" style="display: none;">❌</span>
                @endif
            </div>
            <input type="file" class="form-control" id="image" name="image">
        </div>

            <div class="form-group">
                <label for="redirection_url">Redirection URL</label>
                <input type="text" name="redirection_url" id="redirection_url" class="form-control" value="{{ $advertisement->redirection_url }}">
            </div>

            <button type="submit" class="btn btn-primary">Update</button>
        </form>
    </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('#position').on('change', function() {
            var selectedOption = $(this).val();
            var previewImage = $('#previewImage');

            if (selectedOption) {
                previewImage.css('display', 'block');
            } else {
                previewImage.css('display', 'none');
            }
        });

        $('#image').on('change', function(event) {
            var input = event.target;
            var reader = new FileReader();
            var previewContainer = $('#image-preview-container');
            var preview = $('#image-preview');
            var removeImageBtn = $('#remove-image');

            reader.onload = function() {
                preview.attr('src', reader.result);
                previewContainer.css('display', 'block');
                removeImageBtn.css('display', 'block');
            };

            if (input.files && input.files[0]) {
                reader.readAsDataURL(input.files[0]);
            }
        });

        $('#remove-image').on('click', function() {
            var input = $('#image');
            var previewContainer = $('#image-preview-container');
            var preview = $('#image-preview');
            var removeImageBtn = $('#remove-image');

            input.val('');
            preview.attr('src', '#');
            previewContainer.css('display', 'none');
            removeImageBtn.css('display', 'none');
        });
    });
</script>
@endpush
