@extends('admin.layouts.app')

@section('content')
    <div class="container">
        <style>
            .card{
            border: none;
            box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);
        }
        </style>
        @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
            </div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif

        <div class="card mt-3">
            <div class="card-body">
                <div class="row">
                <div class="col-md-6">
                    <div id='table-filter-wrap'>
                        
                    </div>
                    <table class="table table-striped data-table" id="advertisement-table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Page</th>                    
                                <th>Position</th>                    
                                <th>Redirection URL</th>                    
                                <th>Ad Image</th>                    
                                <th width="105px">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
            
                        </tbody>
                    </table>
                </div>
                <div class="col-md-6">
                    <a href="{{ route('admin.advertisements.create') }}" class="btn btn-primary" style="float: right;">Create New Advertisement</a>
                </div>
            </div>
        </div>
    </div>
@push('scripts')
<script>
$(document).ready(function() {
    var table = $('#advertisement-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{!! route('admin.advertisements.fetchdata') !!}",
          columns: [
              {data: 'id', name: 'id'},
              {data: 'page', name: 'page'},
              {data: 'position', name: 'position'},
              {data: 'redirection_url', name: 'redirection_url'},
              {
                data: 'image',
                name: 'image',
                render: function(data, type, full, meta) {
                    if (type === 'display' && data) {
                        return '<img src="' + data + '" class="img-fluid" alt="Advertisement Image" width="200px" height="200px">';
                    } else {
                        return data;
                    }
                }
            },
              {data: 'action', name: 'action', orderable: false, searchable: false},
          ]
      });
});

</script>
@endpush
@endsection

