@extends('admin.layouts.app')

@section('content')
<div class="container">
    <style>
        .form-control , textarea.form-control{
            min-height: 42px;
            line-height: 42px;
            padding: 0px 12px;
            height: 42px;
            border-radius: 5px;
            background: #fff;
            border-color: #e4e6fc;
            font-size: 16px;
            color: #666;
        }
        .form-control:focus , textarea.form-control:focus{
            border-color: #302B63;
            box-shadow: unset;
        }
        textarea.form-control{
            height: unset;
        }
        label {
            color: #666;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 5px
        }
        .btn-main{
            border-color: #302B63;
            background: #302B63 !important;
            color: #fff;
            padding: 0.55rem 1.5rem;
            font-size: 14px;
            font-weight: 500;
            line-height: 24px;
            letter-spacing: .5px;
            border-radius: 5px;
        }
        .btn-main:hover{
            background: #fff !important;
            color: #302B63;
        }
        .table th, strong, .table td:first-child{
            color: #000;
            font-size: 16px;
            font-weight: 600;
        }
        .table td img{
            height: 60px;
            width: auto;
        }
        .table th{
            background: #ddd;
            padding-top: 15px;
            padding-bottom: 15px;
            border-top: 1px solid #cbcbcb;
        }
        .table td{
            background: #fff;
        }
        .table tr:nth-child(even) td{
            background: #eee !important;
        }
        .table{
            --bs-table-border-color: #cbcbcb;
        }
        .card{
            border: none;
            box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);
        }
    </style>
    <div class="card mt-4">
        <div class="card-body">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            @if(session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
            @endif

            <!-- Form to add a new category -->
            <form action="{{ route('admin.categories.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-12">
                        <div class="mb-3">
                            <label for="category_code" class="form-label">Category Code</label>
                            <input type="text" class="form-control" id="category_code" value="{{$randomNumber}}" name="category_code" readonly>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="mb-3">
                            <label for="category_name" class="form-label">Category Name</label>
                            <input type="text" class="form-control" id="category_name" name="category_name" required>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="mb-3">
                            <label for="image" class="form-label">Image</label>
                            <input type="file" class="form-control" id="image" name="image" required>
                        </div>
                    </div>
                    <div class="col-md-12 mb-3">
                        <button type="submit" class="btn btn-primary btn-main float-end">Save</button>
                    </div>
                </div>
            </form>

            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>SL NO</th>
                            <th class="text-center">Category Code</th>
                            <th class="text-center">Category Name</th>
                            <th class="text-center">Image</th>
                            <th class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $count = '1';
                        @endphp
                        @foreach ($categories as $category)
                        <tr>
                            <td>{{ $count }}</td>
                            <td class="text-center">{{ $category->category_code }}</td>
                            <td class="text-center">{{ $category->category_name }}</td>
                            <td class="text-center">
                                <img src="{{ asset($category->image) }}" alt="Category Image" height="100px" width="140px">
                            </td>
                            
                            <td class="text-center">
                                <form action="{{ route('admin.categories.destroy', $category->id) }}" method="POST"
                                    class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm delete-btn"
                                        data-id="{{ $category->id }}">
                                        Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @php
                        $count++;
                        @endphp
                        @endforeach
                    </tbody>
                </table>
            </div>
            

            {{ $categories->links() }}
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
                    $('.delete-btn').click(function(event) {
                        event.preventDefault();
                        var categoryId = $(this).data('id');
                        
                        Swal.fire({
                            title: 'Are you sure?',
                            text: 'You are about to delete this category!',
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#d33',
                            cancelButtonColor: '#3085d6',
                            confirmButtonText: 'Yes, delete it!'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                // Submit the form after confirmation
                                $(this).closest('form').submit();
                            }
                        });
                    });
                });
</script>
@endpush

@endsection