@extends('admin.layouts.app')

@section('content')

   <div class="container">
    <div class="card">
        <div class="card-body">
         @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
                </div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif
        <h1>Create CMS Page</h1>
        <form action="{{ route('admin.pages.store') }}" method="POST">
            @csrf
            <div class="form-group">
                <label for="about_us">About Us<span class="text-danger">*</span></label>
                <textarea name="privacy_policy" id="privacy_policy" class="ckeditor form-control" rows="5" required></textarea>
                @if ($errors->has('privacy_policy'))
                    <span class="text-danger">{{ $errors->first('privacy_policy') }}</span>
                @endif
            </div>

            <div class="form-group">
                <label for="terms_condition">Terms and condition<span class="text-danger">*</span></label>
                <textarea name="terms_condition" id="terms_condition" class="ckeditor form-control" rows="5" required></textarea>
                @if ($errors->has('terms_condition'))
                    <span class="text-danger">{{ $errors->first('terms_condition') }}</span>
                @endif
            </div>

            <div class="form-group">
                <label for="disclaimer">Disclaimer<span class="text-danger">*</span></label>
                <textarea name="disclaimer" id="disclaimer" class="ckeditor form-control" rows="5" required></textarea>
                @if ($errors->has('disclaimer'))
                    <span class="text-danger">{{ $errors->first('disclaimer') }}</span>
                @endif
            </div>

            <div class="form-group">
                <label for="cookie_policy">Cookie Policy<span class="text-danger">*</span></label>
                <textarea name="cookie_policy" id="cookie_policy" class="ckeditor form-control" rows="5" required></textarea>
                @if ($errors->has('cookie_policy'))
                    <span class="text-danger">{{ $errors->first('cookie_policy') }}</span>
                @endif
            </div>

            <div class="form-group">
                <label for="others">Others<span class="text-danger">*</span></label>
                <textarea name="others" id="others" class="ckeditor form-control" rows="5" required></textarea>
                @if ($errors->has('others'))
                    <span class="text-danger">{{ $errors->first('others') }}</span>
                @endif
            </div>
            <button type="submit" class="btn btn-primary">Create</button>
        </form>
    </div>
    </div>
</div>


@endsection
@push('scripts')
<script src="{{ asset('/ckeditor/ckeditor.js')}}"></script>

<script>
$(document).ready(function() {
            $("#cms_form").validate({
                rules: {
                    about_us: {
                        required: true,
                        minlength: 10,
                        maxlength: 80,
                    },
                    terms_condition:{
                        required: true,
                        minlength: 10,
                        maxlength: 80,
                    },
                    disclaimer: {
                        required: true,
                        minlength: 10,
                        maxlength: 80
                    },
                    cookie_policy: {
                        required: true,
                        minlength: 10,
                        maxlength: 80
                    },
                    others: {
                        required: true,
                        minlength: 10,
                        maxlength: 80
                    }
                },
                messages: {
                    about_us: {
                        required: "About Us is required",
                        maxlength: "About Us cannot be more than 80 characters"
                    },
                    terms_condition: {
                        required: "Terms and Condition is required",
                        maxlength: "Terms and Condition cannot be more than 80 characters"
                    },
                    disclaimer: {
                        required: "Disclaimer is required",
                        maxlength: "Disclaimer cannot be more than 80 characters"
                    },
                    cookie_policy: {
                        required: "Cookie Policy is required",
                        minlength: "Cookie Policy cannot be more than 80 characters"
                    },
                    others: {
                        required: "Others is required",
                        minlength: "Others cannot be more than 80 characters"
                    },
                }
            });
        });


    $(document).ready(function() {
       $('.ckeditor').ckeditor();
    });
</script>
@endpush