@extends('admin.layouts.app')

@section('content')

   <div class="container">
    <style>
        .card{
            border: none;
            box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);
        }
    </style>
    <div class="card mt-4">
        <div class="card-body">
    @if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
        </div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif
        <h3 class="mb-4">Update CMS Page</h3>
       <style>
        label {
            font-weight: 600;
            margin-bottom: 10px;
        }
       </style>
        <form action="{{ route('admin.pages.update', $data->id) }}" method="POST" id="cms_form">
            @csrf
            @method('PUT')
            <div class="form-group mb-4">
                <label for="about_us">Privacy Policy<span class="text-danger">*</span></label>
                <textarea name="privacy_policy" id="privacy_policy" class="ckeditor form-control" rows="5" required>{!! $data->privacy_policy !!}</textarea>
                @if ($errors->has('privacy_policy'))
                    <span class="text-danger">{{ $errors->first('privacy_policy') }}</span>
                @endif
            </div>

            <div class="form-group mb-4">
                <label for="terms_condition">Terms and Condition <span class="text-danger">*</span></label>
                <textarea name="terms_condition" id="terms_condition" class="ckeditor form-control" rows="5" required>{!! $data->terms_condition !!}</textarea>
                @if ($errors->has('terms_condition'))
                    <span class="text-danger">{{ $errors->first('terms_condition') }}</span>
                @endif
            </div>

            <div class="form-group mb-4">
                <label for="disclaimer">Disclaimer <span class="text-danger">*</span></label>
                <textarea name="disclaimer" id="disclaimer" class="ckeditor form-control" rows="5" required>{!! $data->disclaimer !!}</textarea>
                @if ($errors->has('disclaimer'))
                    <span class="text-danger">{{ $errors->first('disclaimer') }}</span>
                @endif
            </div>

            <div class="form-group mb-4">
                <label for="cookie_policy">Cookie Policy <span class="text-danger">*</span></label>
                <textarea name="cookie_policy" id="cookie_policy" class="ckeditor form-control" rows="5" required>{!! $data->cookie_policy !!}</textarea>
                @if ($errors->has('cookie_policy'))
                    <span class="text-danger">{{ $errors->first('cookie_policy') }}</span>
                @endif
            </div>

            <div class="form-group mb-4">
                <label for="others">Others <span class="text-danger">*</span></label>
                <textarea name="others" id="others" class="ckeditor form-control" rows="5" required>{!! $data->others !!}</textarea>
                @if ($errors->has('others'))
                    <span class="text-danger">{{ $errors->first('others') }}</span>
                @endif
            </div>
            <button type="submit" class="btn btn-primary btn-main">Update</button>
        </form>
    </div>
    </div>
</div>

@endsection
@push('scripts')
<script src="{{ asset('/ckeditor/ckeditor.js')}}"></script>

<script>
$(document).ready(function() {
            $("#cms_form").validate({
                rules: {
                    about_us: {
                        required: true,
                        minlength: 10,
                        maxlength: 80,
                    },
                    terms_condition:{
                        required: true,
                        minlength: 10,
                        maxlength: 80,
                    },
                    disclaimer: {
                        required: true,
                        minlength: 10,
                        maxlength: 80
                    },
                    cookie_policy: {
                        required: true,
                        minlength: 10,
                        maxlength: 80
                    },
                    others: {
                        required: true,
                        minlength: 10,
                        maxlength: 80
                    }
                },
                messages: {
                    about_us: {
                        required: "About Us is required",
                        maxlength: "About Us cannot be more than 80 characters"
                    },
                    terms_condition: {
                        required: "Terms and Condition is required",
                        maxlength: "Terms and Condition cannot be more than 80 characters"
                    },
                    disclaimer: {
                        required: "Disclaimer is required",
                        maxlength: "Disclaimer cannot be more than 80 characters"
                    },
                    cookie_policy: {
                        required: "Cookie Policy is required",
                        minlength: "Cookie Policy cannot be more than 80 characters"
                    },
                    others: {
                        required: "Others is required",
                        minlength: "Others cannot be more than 80 characters"
                    },
                }
            });
        });


    $(document).ready(function() {
       $('.ckeditor').ckeditor();
    });
</script>
@endpush