@extends('admin.layouts.app')

@section('content')

<div class="col-12">
  @if(session('success'))
  <div class="alert alert-success">
      {{ session('success') }}
      </div>
  @endif
  @if(session('error'))
      <div class="alert alert-danger">
          {{ session('error') }}
      </div>
  @endif
  <div class="card mt-4">
    <style>
        .form-control , textarea.form-control{
            min-height: 42px;
            line-height: 42px;
            padding: 0px 12px;
            height: 42px;
            border-radius: 5px;
            background: #fff;
            border-color: #e4e6fc;
            font-size: 16px;
            color: #666;
        }
        .form-control:focus , textarea.form-control:focus{
            border-color: #302B63;
            box-shadow: unset;
        }
        textarea.form-control{
            height: unset;
        }
        label {
            color: #666;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 5px
        }
        .btn-main{
            border-color: #302B63;
            background: #302B63 !important;
            color: #fff;
            padding: 0.55rem 1.5rem;
            font-size: 14px;
            font-weight: 500;
            line-height: 24px;
            letter-spacing: .5px;
            border-radius: 5px;
        }
        .btn-main:hover{
            background: #fff !important;
            color: #302B63;
        }
        .card{
            border: none;
            box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);
        }
    </style>
    <div class="card-body">
  <div class="address">
    <div class="add-head p-3">
      <h4 class="mb-0">CONTACT</h4>
    </div>
    <form action="{{ isset($data) ? route('admin.contact-widget.update', $data->id) : route('admin.contact-widget.store') }}" method="POST">
      @csrf
      @if(isset($data))
        @method('PUT')
      @endif
      <div class="add-content text-orange p-2">
        <div class="row">
            <div class="col-md-6 mb-3">
                <div class="form-group">
                    <label for="openingDayFrom">Opening day From:</label>
                    <select class="form-control" id="openingDayFrom" name="opening_day_from" required>
                      <option value="">Select Opening Day</option>
                      @php
                      $daysOfWeek = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
                      @endphp
                      @foreach($daysOfWeek as $day)
                      <option value="{{ $day }}" {{ (isset($data) && $data->opening_day_from == $day) ? 'selected' : (old('opening_day_from') == $day ? 'selected' : '') }}>
                        {{ $day }}
                      </option>
                      @endforeach
                    </select>
                    @if ($errors->has('opening_day_from'))
                      <span class="text-danger">{{ $errors->first('opening_day_from') }}</span>
                    @endif
                  </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
                    <label for="openingDayTo">Opening day To:</label>
                    <select class="form-control" id="openingDayTo" name="opening_day_to" required>
                      <option value="">Select Opening Day</option>
                      @foreach($daysOfWeek as $day)
                      <option value="{{ $day }}" {{ (isset($data) && $data->opening_day_to == $day) ? 'selected' : (old('opening_day_to') == $day ? 'selected' : '') }}>
                        {{ $day }}
                      </option>
                      @endforeach
                    </select>
                    @if ($errors->has('opening_day_to'))
                      <span class="text-danger">{{ $errors->first('opening_day_to') }}</span>
                    @endif
                  </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
                    <label for="openingTimeFrom">Opening time From:</label>
                    <input type="time" class="form-control" id="openingTimeFrom" name="opening_time_from" required value="{{ isset($data) ? $data->opening_time_from : old('openingTimeFrom') }}">
                    @if ($errors->has('opening_time_from'))
                      <span class="text-danger">{{ $errors->first('opening_time_from') }}</span>
                    @endif
                  </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
                    <label for="openingTimeTo">Opening time To:</label>
                    <input type="time" class="form-control" id="openingTimeTo" name="opening_time_to" required value="{{ isset($data) ? $data->opening_time_to : old('openingTimeTo') }}">
                    @if ($errors->has('opening_time_to'))
                      <span class="text-danger">{{ $errors->first('opening_time_to') }}</span>
                    @endif
                  </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
                    <label for="contactNo">Contact No.:</label>
                    <input type="tel" class="form-control" id="contactNo" name="contact_number" required value="{{ isset($data) ? $data->contact_number : old('contactNo') }}">
                    @if ($errors->has('contact_number'))
                      <span class="text-danger">{{ $errors->first('contact_number') }}</span>
                    @endif
                  </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
                    <label for="address">Address:</label>
                    <textarea class="form-control" id="address" name="address" required>{{ isset($data) ? $data->address : old('address') }}</textarea>
                    @if ($errors->has('address'))
                      <span class="text-danger">{{ $errors->first('address') }}</span>
                    @endif
                  </div>
            </div>
            <div class="col-md-12">
                <button type="submit" class="btn btn-primary btn-main float-end">{{ isset($data) ? 'Update' : 'Create' }}</button>
            </div>
        </div>
        
        
        
        
        
        
        
        
      </div>
      
    </form>
  </div>
</div>
</div>
</div>
@endsection
