@extends('admin.layouts.app')



@section('content')

    <div class="container">

        <style>

            .btn-main{

            border-color: #302B63;

            background: #302B63 !important;

            color: #fff;

            padding: 0.55rem 1.5rem;

            font-size: 14px;

            font-weight: 500;

            line-height: 24px;

            letter-spacing: .5px;

            border-radius: 5px;

        }

        .btn-main:hover{

            background: #fff !important;

            color: #302B63;

        }

        strong{

            color: #000;

            font-size: 16px;

            font-weight: 600;

        }

        .card-header h5{

            font-weight: 600;

        }

        .card{

            border: none;

            box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);

        }

        </style>

        <div class="page-header d-flex justify-content-between align-items-center">

            <h2 class="page-title">Enquiry Details</h2>

            <a href="{{ route('admin.enquiry-list') }}" class="btn btn-primary btn-main">

                <i class="fas fa-arrow-left"></i> Back

            </a>

        </div>

        

        

        <div class="card mt-4">

            <div class="card-header">

                <h5 class="mb-0">Name: {{ $contact->title }} {{ $contact->first_name }} {{ $contact->last_name }}</h5>

            </div>

            <div class="card-body">

                <div class="row">

                    <div class="col-md-4">

                        <div class="row justify-content-between align-items-center">

                            <div class="col-4">

                                <div><p><strong>Email:</strong></p></div>

                            </div>

                            <div class="col">

                                <div><p>{{ $contact->email }}</p></div>

                            </div>

                            

                            

                        </div>

                        <div class="row justify-content-between align-items-center">

                            <div class="col-4">

                                <div><p><strong>Subject:</strong></p></div>

                            </div>

                            <div class="col">

                                <div><p>{{ $contact->subject }}</p></div>

                            </div>

                            

                            

                        </div>

                        <div class="row justify-content-between align-items-center">

                            <div class="col-4">

                                <div><p><strong>Message:</strong></p></div>

                            </div>

                            <div class="col">

                                <div><p>{!! $contact->comment !!}</p></div>

                            </div>

                            

                            

                        </div>

                    </div>

                </div>

                {{-- <p><strong>Email:</strong> {{ $contact->email }}</p>

                <p><strong>Subject:</strong> {{ $contact->subject }}</p>

                <p><strong>Message:</strong> {!! $contact->comment !!}</p> --}}

            </div>

        </div>

    </div>

@endsection

