@extends('admin.layouts.app')

@section('content')
<div class="container">
  <div class="card">
    <div class="card-header text-center">
      <a class="btn btn-primary float-end" href="{{ route('admin.game-details.index') }}"><i class="fas fa-arrow-left"></i> Back To Listing</a>
      UPDATE GAME
    </div>
    <div class="card-body">
      <form action="{{ route('admin.game-details.update', $gameDetail->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <span class="btn btn-info game_code_span float-end">{{ $gameDetail->game_code }}</span>
        <div class="form-group">
          <input type="hidden" class="form-control" id="gameCode" name="game_code" value="{{ $gameDetail->game_code }}" readonly>
          @if ($errors->has('game_code'))<span class="text-danger">{{ $errors->first('game_code') }}</span>@endif
        </div>
        <div class="form-group">
          <label for="gameTitle">Game Title<span class="text-danger">*</span></label>
          <input type="text" class="form-control" id="gameTitle" name="game_title" value="{{ $gameDetail->game_title }}" placeholder="Enter game title">
          @if ($errors->has('game_title'))<span class="text-danger">{{ $errors->first('game_title') }}</span>@endif
        </div>
        <div class="form-group">
          <label for="gameDescription">Description<span class="text-danger">*</span></label>
          <textarea class="form-control" id="gameDescription" name="game_description" placeholder="Enter game description">{{ $gameDetail->game_description }}</textarea>
          @if ($errors->has('game_description'))<span class="text-danger">{{ $errors->first('game_description') }}</span>@endif
        </div>
          <div class="form-group">
              <label for="gameCategory">Category<span class="text-danger">*</span></label>
              <select class="form-control w-100" id="gameCategory" name="game_category">
                  <option value="">Select game category</option>
                      @foreach ($categoryList as $category)
                          <option value="{{ $category->id }}" {{ $category->id == $gameDetail->game_category ? 'selected' : '' }}>
                              {{ $category->category_name }}
                          </option>
                      @endforeach
              </select>
              @if ($errors->has('game_category'))
                  <span class="text-danger">{{ $errors->first('game_category') }}</span>
              @endif
          </div>
        <div class="form-row">
          <div class="form-group col-md-6">
            <label for="gameStartDate">Start Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameStartDate" name="game_start_date" value="{{ $gameDetail->game_start_date }}" min="{{ date('Y-m-d') }}" value="{{ old('game_start_date') }}">
            @if ($errors->has('game_start_date'))<span class="text-danger">{{ $errors->first('game_start_date') }}</span>@endif
          </div>
          <div class="form-group col-md-6">
            <label for="gameEndDate">End Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameEndDate" name="game_end_date" value="{{ $gameDetail->game_end_date }}" min="{{ date('Y-m-d') }}" value="{{ old('game_end_date') }}">
            @if ($errors->has('game_end_date'))<span class="text-danger">{{ $errors->first('game_end_date') }}</span>@endif
          </div>
        </div>
        <div class="form-row">
          <div class="form-group col-md-6">
            <label for="gameStartTime">Start Time<span class="text-danger">*</span></label>
            <input type="time" class="form-control" id="gameStartTime" name="game_start_time" value="{{ $gameDetail->game_start_time }}" value="{{ old('game_start_time') }}">
            @if ($errors->has('game_start_time'))<span class="text-danger">{{ $errors->first('game_start_time') }}</span>@endif
          </div>
          <div class="form-group col-md-6">
            <label for="gameEndTime">End Time<span class="text-danger">*</span></label>
            <input type="time" class="form-control" id="gameEndTime" name="game_end_time" value="{{ $gameDetail->game_end_time }}" value="{{ old('game_end_time') }}">
            @if ($errors->has('game_end_time'))<span class="text-danger">{{ $errors->first('game_end_time') }}</span>@endif
          </div>
        </div>
        
        <div class="form-row">
          <div class="form-group col-md-6">
            <label for="gameDrawDate">Draw Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameDrawDate" name="game_draw_date" value="{{ $gameDetail->game_draw_date }}" min="{{ date('Y-m-d') }}" value="{{ old('game_draw_date') }}">
            @if ($errors->has('game_draw_date'))<span class="text-danger">{{ $errors->first('game_draw_date') }}</span>@endif
          </div>
          <div class="form-group col-md-6">
            <label for="gameDrawTime">Draw Time<span class="text-danger">*</span></label>
            <input type="time" class="form-control" id="gameDrawTime" name="game_draw_time" value="{{ $gameDetail->game_draw_time }}" value="{{ old('game_draw_time') }}">
            @if ($errors->has('game_draw_time'))<span class="text-danger">{{ $errors->first('game_draw_time') }}</span>@endif
          </div>
        </div>
        <div class="form-group">
          <label for="gameTimeZone">Time Zone<span class="text-danger">*</span></label>
          <select class="form-control" id="gameTimeZone" name="game_time_zone">
            <option value="">Status</option>
            <option value="ist" {{ $gameDetail->game_time_zone === 'ist' ? 'selected' : '' }}>IST</option>
            <option value="gmt" {{ $gameDetail->game_time_zone === 'gmt' ? 'selected' : '' }}>GMT</option>
            <option value="uae" {{ $gameDetail->game_time_zone === 'uae' ? 'selected' : '' }}>UAE</option>
          </select>
          @if ($errors->has('game_time_zone'))<span class="text-danger">{{ $errors->first('game_time_zone') }}</span>@endif
        </div>
        <div class="form-group">
          <label for="gameTotalAllowedTicket">Total No's Allowed in a Ticket<span class="text-danger">*</span></label>
          <input type="number" class="form-control" id="gameTotalAllowedTicket" name="game_total_allowed_ticket" value="{{ $gameDetail->game_total_allowed_ticket }}" placeholder="Enter total allowed tickets">
          @if ($errors->has('game_total_allowed_ticket'))<span class="text-danger">{{ $errors->first('game_total_allowed_ticket') }}</span>@endif
        </div>
        <div class="form-group">
          <label for="gameTicketPrize">Price of the Ticket (in $)<span class="text-danger">*</span></label>
          <input type="number" class="form-control" id="gameTicketPrize" name="game_ticket_prize" value="{{ $gameDetail->game_ticket_prize }}" placeholder="Enter ticket prize">
          @if ($errors->has('game_ticket_prize'))<span class="text-danger">{{ $errors->first('game_ticket_prize') }}</span>@endif
        </div>
        {{-- <div class="form-row">
          <div class="form-group col-md-6">
            <label for="gameMinRange">Min Range<span class="text-danger">*</span></label>
            <input type="number" class="form-control" id="gameMinRange" name="game_min_range" value="{{ $gameDetail->game_min_range }}" placeholder="Enter min range" min="1">
            @if ($errors->has('game_min_range'))<span class="text-danger">{{ $errors->first('game_min_range') }}</span>@endif
          </div>
          <div class="form-group col-md-6">
            <label for="gameMaxRange">Max Range<span class="text-danger">*</span></label>
            <input type="number" class="form-control" id="gameMaxRange" name="game_max_range" value="{{ $gameDetail->game_max_range }}" placeholder="Enter max range" max="99">
            @if ($errors->has('game_max_range'))<span class="text-danger">{{ $errors->first('game_max_range') }}</span>@endif
          </div>
        </div> --}}
        <div class="form-group">
          <label for="gameStatus">Game Status<span class="text-danger">*</span></label>
          <select class="form-control" id="gameStatus" name="game_status">
            <option value="1" {{ $gameDetail->game_status === '1' ? 'selected' : '' }}>Active</option>
            <option value="0" {{ $gameDetail->game_status === '0' ? 'selected' : '' }}>Inactive</option>
            <option value="2" {{ $gameDetail->game_status === '2' ? 'selected' : '' }}>Closed</option>
          </select>
          @if ($errors->has('game_status'))<span class="text-danger">{{ $errors->first('game_status') }}</span>@endif
        </div>
        <div class="form-group">
          <label for="featured_image">Featured Image<span class="text-danger">*</span></label>
          <img src="{{ asset('game_images/'.$gameDetail->featured_image)}}" alt="{{$gameDetail->featured_image}}" class="img-thumbnail" height="200px" width="200px">
          <input type="hidden" name="featured_image" id=""value="{{$gameDetail->featured_image}}" class="form-control">
          <input type="file" name="featured_image" id="featured_image" class="form-control">
          @error('featured_image')
              <span class="invalid-feedback" role="alert">
                  <strong>{{ $message }}</strong>
              </span>
          @enderror
        </div>
        <!-- Image preview container -->
        <div id="image_preview_container"></div>
        <div class="form-group">
          <button type="submit" class="btn btn-primary float-end">Update Game</button>
        </div>
      </form>
    </div>
  </div>
</div>
@push('scripts')
<script>
 $('#gameStartDate').change(function(){
  $('#gameEndDate').prop('min', $(this).val());
  $('#gameEndDate').val('');
  $('#gameDrawDate').prop('min', $(this).val());
  $('#gameDrawDate').val('');
});

$('#gameEndDate').change(function(){
  $('#gameDrawDate').prop('min', $(this).val());
  $('#gameDrawDate').val('');
});
    

  $(document).ready(function() {
    // When a file is selected, show the preview
    $("#featured_image").change(function(){
      // Clear the previous preview
      $("#image_preview_container").html("");

      // Get the selected file
      var file = this.files[0];

      // Check if the file is an image
      if (file && file.type.match(/^image\//)) {
        var reader = new FileReader();

        reader.onload = function(e) {
          // Create an image element and set the source to the selected file
          var img = $("<img>").attr("src", e.target.result).addClass("img-thumbnail").height(200).width(200);
          
          // Append the image to the preview container
          $("#image_preview_container").append(img);
        }

        // Read the file as a URL
        reader.readAsDataURL(file);
      }
    });
  });
</script>
@endpush
@endsection
