@extends('admin.layouts.app')

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="container">
    <style>
        .form-control , textarea.form-control{
            min-height: 42px;
            line-height: 42px;
            padding: 0px 12px;
            height: 42px;
            border-radius: 5px;
            background: #fff;
            border-color: #e4e6fc;
            font-size: 16px;
            color: #666;
        }
        .form-control:focus , textarea.form-control:focus{
            border-color: #302B63;
            box-shadow: unset;
        }
        textarea.form-control{
            height: unset;
        }
        label {
            color: #666;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 5px
        }
        .btn-main{
            border-color: #302B63;
            background: #302B63 !important;
            color: #fff;
            padding: 0.55rem 1.5rem;
            font-size: 14px;
            font-weight: 500;
            line-height: 24px;
            letter-spacing: .5px;
            border-radius: 5px;
        }
        .btn-main:hover{
            background: #fff !important;
            color: #302B63;
        }
        .table th, strong, .table td:first-child{
            color: #000;
            font-size: 16px;
            font-weight: 600;
        }
        .table td img{
            height: 60px;
            width: auto;
        }
        .table th{
            background: #ddd;
            padding-top: 15px;
            padding-bottom: 15px;
            border-top: 1px solid #cbcbcb;
        }
        .table td{
            background: #fff;
        }
        .table{
            --bs-table-border-color: #cbcbcb;
        }
    </style>
  <div class="card mt-4" style="border: none;
  box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);">
    <div class="card-body">
    @if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
        </div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif
  <div class="card">
    <div class="card-header text-center d-flex w-100 justify-content-between align-items-center">
        <h4 class="mb-0">Result Add/Edit</h4>
      <a class="btn btn-primary float-end btn-main" href="{{ route('admin.game-details.index') }}"><i class="fas fa-arrow-left"></i> Back To Listing</a>
      
    </div>
    <form action="{{ route('admin.winning-numbers.store')}}" method="POST">
      @csrf
      <div class="card-body">
        <div class="card-heading-titles" style="display: flex; align-items: center; justify-content: center;">
          <div class="heading" style="display: flex;">
            <input type="hidden" name="game_id" value="{{ @$game->id }}">
            <div style="margin-right: 20px;"><strong>Game Title:</strong></div>
            <div style="margin-right: 20px;">{{ isset($game) ? $game->game_title : 'N/A' }}</div>
            <div style="margin-right: 20px;"><strong>Draw Date:</strong></div>
            <div>{{ isset($game) ? $game->game_draw_date : 'N/A' }}</div>
          </div>
        </div>
        <table class="table table-bordered table-scroll mt-3" id="productTable">
          <thead>
            <tr>
              <th scope="col" class="text-center">SL NO</th>
              <th scope="col" class="text-center">Enter Range</th>
              <th scope="col" class="text-center">Winning Amount</th>
              <th scope="col" class="text-center">Description</th>
            </tr>
          </thead>
          <tbody id="tbody">
            @for($i = 1; $i<= $game->game_total_allowed_ticket; $i++)
            <tr>
              <td class="text-center">{{$i}}</td>
              <td><input type="text" class="form-control" name="range[{{$i}}][]" placeholder="Enter Range"></td>
              <td><input type="text" class="form-control" name="amount[{{$i}}][]" placeholder="Winning Amount"></td>
              <td><input type="text" class="form-control" name="description[{{$i}}][]" placeholder="Description"></td>
            </tr>
            @endfor
          </tbody>
        </table>
        <input type="button" value="Publish Result">
        <input id="submitButton" type="button" class="btn btn-primary btn-main mb-4" style="float: right;" value="Submit">

        {{-- <input type="button" class="btn btn-primary btn-main mb-4" style="float: right;" value="Submit"> --}}
      </div>
      
    
    </form>
  </div>
</div>
@push('scripts')
<script>
$(document).ready(function() {
  // Add an event listener to the Submit button
  $('#submitButton').click(function(e) {
    e.preventDefault();

    // Collect the data from the table rows
    var data = [];
    $('#tbody tr').each(function() {
      var slNo = $(this).find('td:nth-child(1)').text();
      var range = $(this).find('input[name^="range"]').val();
      var amount = $(this).find('input[name^="amount"]').val();
      var description = $(this).find('input[name^="description"]').val();
      data.push({
        slNo: slNo,
        range: range,
        amount: amount,
        description: description
      });
    });

    // Send the data via AJAX
    $.ajax({
      url: '{{ route('admin.winning-numbers.store') }}',
      type: 'POST',
      data: { data: JSON.stringify(data), _token: '{{ csrf_token() }}' },
      success: function(response) {
        // Handle the response from the server
        console.log(response);
        // Reload the page with the updated data
        location.reload();
      },
      error: function(xhr, status, error) {
        // Handle the error
        console.log(xhr.responseText);
      }
    });
  });
});

</script>
@endpush
@endsection
