@extends('admin.layouts.app')
@section('content')
<div class="container">
    <style>
        .table th, strong, .table td:first-child{
            color: #000;
            font-size: 16px;
            font-weight: 600;
        }
        .table td img{
            height: 60px;
            width: auto;
        }
        .table th{
            background: #ddd;
            padding-top: 15px;
            padding-bottom: 15px;
            border-top: 1px solid #cbcbcb !important;
        }
        .table td{
            background: #fff;
        }
        .table{
            --bs-table-border-color: #cbcbcb !important;
        }
        table#games-table{
            border-top: 1px solid #cbcbcb !important;
        }
        button.badge{
            border: unset;
        }
        .card{
            border: none;
            box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);
        }
    </style>
  <div class="card mt-4">
      <div class="card-body">
          @if(session('success'))
          <div class="alert alert-success">
              {{ session('success') }}
          </div>
          @endif
          @if(session('error'))
          <div class="alert alert-danger">
              {{ session('error') }}
          </div>
          @endif
          <div class="d-flex justify-content-between align-items-center">
            <h1>Manage Ticket</h1>
            {{-- <a href="#" class="btn btn-primary">Add New Game</a> --}}
        </div>
       
        <div style="margin: 20px 0px;">
            <div style="display: flex; align-items: center;">
              <strong style="margin-right: 10px;">Filter By Draw Date:</strong>
              <input type="date" name="daterange" id="draw-date-filter" value="" class="form-control" style="flex: 0 0 150px; max-width: 150px;" />
              {{-- <strong style="margin-left: 10px; margin-right: 10px;">Search By Ticket No :</strong> --}}
              
            </div>
          </div>
          
          
        {{-- <table class="table data-table" id="games-table">
            <thead>
                <tr>
                    <th>SL NO</th>
                    <th>Ticket Code</th>                    
                    <th>Ticket No</th>                    
                    <th>Ticket Date</th>                    
                    <th>Status</th>                    
                    <th width="305px"></th>
                </tr>
            </thead>
            <tbody>

            </tbody>
        </table> --}}

        <table id="ticket-list" class="display" style="width:100%">
            <thead>
                <tr>
                    <th>SL NO</th>
                    <th>Ticket Code</th>                    
                    <th>Ticket No</th>                    
                    <th>Ticket Date</th>                    
                    {{-- <th>Status</th>                     --}}
                    <th width="305px"></th>
                </tr>
            </thead>
            <tbody>
                @php
                $row = 1;    
                @endphp
                @foreach ($tickets as $ticket)
                <tr>
                    <td>{{ $row }}</td>
                    <td>{{ $ticket->ticket_code }}</td>
                    <td>{{ $ticket->id }}</td>
                    <td>{{ $ticket->created_at }}</td>
                    {{-- <td>{{ $ticket->status }}</td> --}}
                    <td>
                        <div class="btn-group" role="group" aria-label="Button Group">
                            <a href="{{ route('admin.show.ticket', ['id' => $ticket->id]) }}" class="btn btn-primary btn-sm me-1">VIEW</a>
                        </div>
                    </td>
                </tr>
                @php
                    $row++;
                @endphp
                @endforeach
            </tbody>
        </table>
    </div>
</div>
</div>
@push('scripts')
<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/select/1.3.3/js/dataTables.select.min.js"></script>
<script>
    new DataTable('#ticket-list');

    $(document).ready(function() {
    var table = $('#ticket-list').DataTable();

    $('#draw-date-filter').on('change', function() {
        var drawDate = $(this).val(); // Get the selected draw date

        table.column(3).search(drawDate).draw(); // Apply the draw date filter on the "Ticket Date" column (index 3)
    });
});
</script>
{{-- <script>
    $(function() {
                var rows_selected = [];
                var table = $('.data-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: "{{ route('admin.fetch.ticket-list') }}",
                    columns: [
                        {
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex'
                        },
                        {
                            data: 'ticket_code',
                            name: 'ticket_code'
                        },
                        {
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'created_at',
                            name: 'created_at'
                        },
                        {
                            data: 'status',
                            name: 'status',
                            render: function(data) {
                                if (data == '1') {
                                    return '<button type="button" class="badge bg-warning">Placed</button>';
                                } else if (data == '2') {
                                    return '<button type="button" class="badge bg-success">Won</ button>';
                                } else if (data == '3') {
                                    return '<button type="button" class="badge bg-danger">Loss</ button>';
                                } else {
                                    return 'N/A';
                                }
                            }
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        },
                    ],
                });
            });
         
</script> --}}
@endpush
@endsection