@extends('admin.layouts.app')

@section('content')
<div class="container">
    <style>
        .form-control , textarea.form-control{
            min-height: 42px;
            line-height: 42px;
            padding: 0px 12px;
            height: 42px;
            border-radius: 5px;
            background: #fff;
            border-color: #e4e6fc;
            font-size: 16px;
            color: #666;
        }
        .form-control:focus , textarea.form-control:focus{
            border-color: #302B63;
            box-shadow: unset;
        }
        textarea.form-control{
            height: unset;
        }
        label {
            color: #666;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 5px;
            white-space: nowrap;
            margin-right: 10px;
        }
        .btn-main{
            border-color: #302B63;
            background: #302B63 !important;
            color: #fff;
            padding: 0.55rem 1.5rem;
            font-size: 14px;
            font-weight: 500;
            line-height: 24px;
            letter-spacing: .5px;
            border-radius: 5px;
        }
        .btn-main:hover{
            background: #fff !important;
            color: #302B63;
        }
        .label-warp{
            width: 97.3px;
        }
        .card-header h4{
            font-weight: 600;
            font-size: 1.5rem;
        }
        .card{
            border: none;
            box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);
        }
    </style>
  <div class="card mt-3" style="background: #F4F4F4;">
    <div class="card-header d-flex w-100 justify-content-between align-items-center">
        <h4 class="mb-0">Ticket View</h4>
        <a class="btn btn-primary float-end btn-main" href="javascript:history.back()"><i class="fas fa-arrow-left"></i> Back To Listing</a>      
    </div>
    <div class="card-body">
      <div class="row">
        <div class="col-md-12 mx-auto">
            <div class="row">
                <div class="col-md-10">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <div class="form-group">
                                <div class="label-warp">
                                    <label for="inputFirstname">Ticket Code</label>
                                </div>
                                <span class="form-control">{{ @$data->ticket_code }}</span>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="form-group">
                                <div class="label-warp">
                                    <label for="inputLastname">Draw Date</label>
                                </div>
                                <span class="form-control">{{ @$game->game_draw_date }} {{ date('g:i A', strtotime($game->game_draw_time)) }}</span>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="form-group">
                                <div class="label-warp">
                                    <label for="inputAddressLine1">Total Wins</label>
                                </div>
                                <span class="form-control">{{ @$data->total_win ? $data->total_win : '0' }}</span>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="form-group">
                                <div class="label-warp">
                                    <label for="inputAddressLine2">Ticket Price</label>
                                </div>
                                <span class="form-control">{{ @$data->price }}</span>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="form-group">
                                <div class="label-warp">
                                    <label for="inputAddressLine2">Win Amount</label>
                                </div>
                                <span class="form-control">{{ @$data->win_amount ? $data->win_amount : '0' }}</span>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="d-flex h-100 align-items-end">
                                <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: red;margin-right: 15px;color: #fff;padding: 10px;">
                                    <span>Loss</span>
                                </div>
                                <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: #0a8901;color: #fff;padding: 10px;">
                                    <span>Won</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-2">
                    {!! QrCode::size(150)->generate('Ticket Code :'. @$data->ticket_code) !!}
                </div>
            </div>
        </div>
      </div>
      {{-- <div class="row">
        @foreach($ticket_sequences as $ticket_sequence)
        <div class="col-sm-1">
            <div class="card" style="background-color:
                @if($ticket_sequence->status == 1)
                    yellow
                @elseif($ticket_sequence->status == 2)
                    green
                @elseif($ticket_sequence->status == 3)
                    red
                @endif">
                <div class="card-body">
                    {{$ticket_sequence->winning_sequence}}
                </div>
            </div>
        </div>
        @endforeach
    </div> --}}
    <div class="row">
        <style>
            .checker-results {
                background: #0A8901;
                display: flex;
                width: 100%;
                align-items: center;
                margin-bottom: 20px;
                box-shadow: rgba(0,0,0,0.1) 0 3px 5px;
                text-align: center;
            }
            .checker-results .title {
                position: relative;
                color: #FFF;
                padding: 10px 30px;
                font-weight: 700;
                font-size: 18px;
                line-height: 20px;
                text-align: center;
                letter-spacing: 0;
            }
            .checker-results .chosen-numbers {
                background: #FFF;
                padding: 20px 5px;
                flex: 1;
                text-align: center;
            }
            .checker-results .chosen-numbers .padded {
                padding: 5px;
            }
            .ball {
                /* background: #0a8901; */
                border: 6px solid;
                color: #fff;
                width: 60px;
                height: 60px;
                display: inline-block;
                border-radius: 50%;
                text-align: center;
                font: 24px/48px Montserrat,sans-serif;
                font-weight: 700;
            }
            .ball.joker {
                border: 6px solid #0a8901;
                background: none;
                color: #0a8901;
            }
            .checker-results .title:after {
                content: "";
                background: #0A8901;
                position: absolute;
                width: 24px;
                height: 24px;
                top: calc(32%);
                right: -12px;
                transform: rotate(-45deg);
            }
            .bg-color-yellow{
                background-color: yellow;
            }
            .bg-color-green{
                background-color: green;
            }
            .bg-color-red{
                background-color: red;
            }
        </style>
        <div class="col-md-12 mt-4">
            <div class="checker-results mb-0">
                <div>
                    <div class="title">Checking <br>Numbers</div>
                </div>
                <div class="chosen-numbers">
                    
                        <div class="padded">
                            @foreach($ticket_sequences as $ticket_sequence)
                                @if($ticket_sequence->status == 1)
                                    <span class="result ball bg-color-yellow">{{$ticket_sequence->winning_sequence}}</span>
                                @elseif($ticket_sequence->status == 2)
                                    <span class="result ball bg-color-green">{{$ticket_sequence->winning_sequence}}</span>
                                @elseif($ticket_sequence->status == 3)
                                    <span class="result ball bg-color-red">{{$ticket_sequence->winning_sequence}}</span>
                                @endif
                            @endforeach        
                        </div>
                    
                </div>
            </div>
        </div>
    </div>
    {{-- <div class="row justify-content-between align-items-center">
        <div class="col-6 mb-2">
            {!! QrCode::size(150)->generate('Ticket Code :'. @$data->ticket_code) !!}
          </div>
          <div class="col-2 mb-2">
            <div class="d-flex align-items-center">
                <div class="card-body text-center" style="width: 60px;height: 60px;background-color: red;margin-right: 15px;color: #fff;">
                    <span>Loss</span>
                </div>
                <div class="card-body text-center" style="width: 60px;height: 60px;background-color: #0a8901;color: #fff;">
                    <span>Won</span>
                </div>
            </div>
          </div>
    </div> --}}
      
 
      
      {{-- <div class="col-sm-1">
        
      </div>
      <div class="col-sm-1">
        
      </div> --}}
    </div>
    
  </div>
</div>
@endsection

