@extends('admin.layouts.app')

@section('content')
    <div class="container">
        <style>
        .card{
            border: none;
            box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);
        }
        button.badge{
            border: unset;
        }
        </style>
        <div class="card mt-4">
            <div class="card-body">
        <h1>Users List</h1>

        <table class="table table-striped data-table">
            {{-- <button class="delete_records">Delete</button> --}}
            <thead>
                <tr>
                    {{-- <th>Check All <input type="checkbox" class='checkall' id='checkall'><input type="button" id='delete_record' value='Delete' ></th> --}}
                    <th></th>
                    <th>Date of Reg</th>
                    <th>Name</th>
                    <th>Phone No</th>
                    <th>Status</th>
                    <th width="350px">Action</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>
    </div>
</div>
    @push('scripts')
        <script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/select/1.3.3/js/dataTables.select.min.js"></script>
        <script>
            $(function() {
                        var rows_selected = [];
                        var table = $('.data-table').DataTable({
                            processing: true,
                            serverSide: true,
                            ajax: "{{ route('admin.get-users-list') }}",
                            columns: [
                                {
                                    data: 'DT_RowIndex',
                                    name: 'DT_RowIndex'
                                },
                                {
                                    data: 'created_at',
                                    name: 'created_at'
                                },
                                {
                                    data: 'name',
                                    name: 'name'
                                },
                                {
                                    data: 'phone',
                                    name: 'phone'
                                },
                                {
                                    data: 'status',
                                    name: 'status',
                                    render: function(data) {
                                        if (data === 0) {
                                            return '<button type="button" class="badge bg-danger">Inactive</button>';
                                        } else if (data === 1) {
                                            return '<button type="button" class="badge bg-success">Active</button>';
                                        } else {
                                            return '';
                                        }
                                    }
                                },
                                {
                                    data: 'action',
                                    name: 'action',
                                    orderable: false,
                                    searchable: false
                                },
                            ],
                        });
                    });
                 
        </script>
    @endpush
@endsection
