@extends('admin.layouts.app')

@section('content')
<div class="container">
    <style>
      .show-balance {
          background-color: #f7f7f7;
          border: 1px solid #ccc;
          padding: 20px;
          border-radius: 5px;
          text-align: center;
          margin-bottom: 20px;
          margin-top: 10px;
      }

      .balance-amount {
          color: #302B63;
          font-size: 32px;
          margin-top: 10px;
      }

      .pagination {
          justify-content: center;
          margin-top: 20px;
      }

      .pagination .page-item.active .page-link {
          background-color: #302B63;
          border-color: #302B63;
      }

      .pagination .page-link {
          color: #302B63;
          background-color: #fff;
          border: 1px solid #dee2e6;
      }
  </style>

    <div class="card mt-4">
        <div class="card-body">
          <a class="btn btn-primary btn-main float-end" href="{{ route('admin.users-list') }}"><i class="fas fa-arrow-left"></i> Back To Listing</a>

            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            @if(session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
            @endif

           
            <!-- Form to add a new category -->
            <form action="{{ route('admin.wallet.store') }}" method="POST">
              @csrf
              <input type="hidden" name="user_id" value="{{$user->id}}">
              <div class="d-flex justify-content-center align-items-center">
                  <div class="col-md-4">
                      <div class="mb-3">
                          <label for="amount" class="form-label">Enter the amount</label>
                          <input type="text" class="form-control" id="amount" value="" name="amount">
                      </div>
                  </div>
              </div>
              <div class="text-center">
                  <button type="submit" class="btn btn-primary btn-main">Add Amount</button>
              </div>
          </form>

          <div class="show-balance">
            <p><strong>Total Wallet Balance:</strong></p>
            <h3 class="balance-amount">$ {{ @$wallet->amount ? @$wallet->amount : '0' }}</h3>
          </div>
        
            <div class="table-responsive" style="padding-top: 20px;">
                <table class="table">
                    <thead>
                        <tr>
                            <th>SL NO</th>
                            <th class="text-center">Amount</th>
                            <th class="text-center">Type(Credit/Debit)</th>
                            <th class="text-center">Date</th>
                            <th class="text-center">Ticket No</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $count = 1;
                        @endphp
                        @isset($wallet_transactions)
                        @if($wallet_transactions->count() > 0)
                          @foreach ($wallet_transactions as $transaction)
                              <tr>
                                <td class="text-center">{{ $count++ }}</td>
                                <td class="text-center">{{ @$transaction->amount }}</td>
                                <td class="text-center">
                                  @if (@$transaction->type == 1)
                                      <span style="color: green;">Credit</span>
                                  @elseif (@$transaction->type == 2)
                                      <span style="color: red;">Debit</span>
                                  @else
                                      N/A
                                  @endif
                                </td>
                                <td class="text-center">{{ @$transaction->created_at->format('Y-m-d') }}</td>
                                <td class="text-center">{{ @$transaction->ticket_id }}</td>
                              </tr>
                          @endforeach
                        @endif

                    </tbody>
                </table>
                <div class="pagination justify-content-center">
                    {{ @$wallet_transactions->links() }}
                </div>
                @endisset
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        $('form').submit(function(e) {
            var amount = $('#amount').val();
            if (amount === '') {
                e.preventDefault();
                $('#amount').addClass('is-invalid');
                $('<div class="invalid-feedback" style="color: red;">Please enter the amount</div>').insertAfter('#amount');
            }
        });

        $('#amount').on('input', function() {
            // Remove non-digit characters
            $(this).val($(this).val().replace(/[^0-9]/g, ''));
          });

          $('#amount').on('keypress', function(e) {
            var keyCode = e.which;
            // Check if the entered key is a digit or the minus sign
            if (keyCode != 45 && (keyCode < 48 || keyCode > 57)) {
              e.preventDefault();
            }
          });
    });
</script>
@endpush

@endsection
