@extends('admin.layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif
            <div class="card">
                <div class="card-header text-center">
                    Winning Numbers
                </div>
                <form action="" method="">
                    @csrf
                    <div class="card-body">
                        <div class="card-heading-titles">
                            <div class="heading">
                                <input type="hidden" name="game_id" value="{{ $game->id }}">
                                <div><strong>Game Title : {{ isset($game) ? $game->game_title : 'N/A' }}</strong> </div>
                                <div><strong>Draw Date : {{ isset($game) ? $game->game_draw_date : 'N/A' }}</strong></div>
                            </div>
                        </div>
                        <table class="table table-bordered table-scroll mt-3" id="productTable">
                            <thead>
                                <tr>
                                    <th scope="col">SL NO</th>
                                    <th scope="col">Winning Number</th>
                                    <th scope="col">Winning Sequence</th>
                                    <th scope="col">
                                        <button class="btn btn-info" id="addBtn" type="button">
                                            <i class="fa fa-plus"></i>
                                        </button>
                                    </th>
                                </tr>
                            </thead>
                              <tbody id="tbody">
                                  @foreach($winningNumbers as $index => $winningNumber)
                                      @if($winningNumber)
                                          <tr>
                                              <td class="row-index text-center"></td>
                                              <td>
                                                  <select class="form-control" name="winning_number[]" id="">
                                                      <option value="">Select Winning Number</option>
                                                      <option value="1" {{ $winningNumber->number == 1 ? 'selected' : '' }}>1</option>
                                                  </select>
                                              </td>
                                              <td>
                                                  <input class="form-control" type="number" name="winning_sequence[]" value="{{ $winningNumber->sequence }}">
                                              </td>
                                              <td class="text-center">
                                                  <button class="btn btn-danger remove" type="button">Remove</button>
                                              </td>
                                          </tr>
                                      @endif
                                  @endforeach                              
                              </tbody>
                          </table>
                    </div>
                    <input type="submit" class="btn btn-primary" value="Submit">
                </form>
            </div>
        </div>
    </div>
</div>
@push('scripts')
<script>
    $(document).ready(function () {
        // Denotes total number of rows
        var rowIdx = {{ count($winningNumbers) }};

        // jQuery button click event to add a row
        $('#addBtn').on('click', function () {
            // Adding a row inside the tbody
            $('#tbody').append(`
                <tr>
                    <td class="row-index text-center">${++rowIdx}</td>
                    <td>
                        <select class="form-control" name="winning_number[]" id="">
                            <option value="">Select Winning Number</option>
                            <option value="1">1</option>
                        </select>
                    </td>
                    <td><input class="form-control" type="number" name="winning_sequence[]"></td>
                    <td class="text-center">
                        <button class="btn btn-danger remove" type="button">Remove</button>
                    </td>
                </tr>
            `);
        });

        // jQuery button click event to remove a row
        $('#tbody').on('click', '.remove', function () {
            // Removing the current row
            $(this).closest('tr').remove();

            // Updating the SL numbers
            updateSLNumbers();
        });

        // Function to update SL numbers
        function updateSLNumbers() {
            $('#tbody tr').each(function (index) {
                $(this).find('.row-index').text(index + 1);
            });
            rowIdx = $('#tbody tr').length; // Update the rowIdx variable
        }
    });
</script>
@endpush
@endsection
