<!doctype html>

<html lang="en">



<head>

    <meta charset="utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <title>Sign up</title>

    <link href="{{ asset('/assets/vendor/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet">

    <link href="{{ asset('/assets/css/auth.css')}}" rel="stylesheet">

</head>



<body>

    <div class="wrapper">

        <div class="auth-content">

            <div class="card">

                <div class="card-body text-center">

                    <div class="mb-4">

                        <img class="brand" src="{{ asset('logo.png')}}" alt="logo">

                    </div>

                    <h6 class="mb-4 text-muted">Create new Admin Account</h6>

                        <form method="POST" action="{{ $route }}">

                        @csrf

                        <div class="mb-3 text-start">

                            <label for="name" class="form-label">Name</label>

                            <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>

                            @error('name')

                                <span class="invalid-feedback" role="alert">

                                    <strong>{{ $message }}</strong>

                                </span>

                            @enderror

                        </div>

                        

                        <div class="mb-3 text-start">

                            <label for="email" class="form-label">{{ __('Email Address') }}</label>

                            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">

                            @error('email')

                                    <span class="invalid-feedback" role="alert">

                                        <strong>{{ $message }}</strong>

                                    </span>

                            @enderror

                        </div>



                        <div class="mb-3 text-start">

                            <label for="password" class="form-label">{{ __('Password') }}</label>

                            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">

                            @error('password')

                            <span class="invalid-feedback" role="alert">

                                <strong>{{ $message }}</strong>

                            </span>

                        @enderror

                        </div>



                        <div class="mb-3 text-start">

                            <label for="password" class="form-label">{{ __('Confirm Password') }}</label>

                            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">

                            @error('password')

                            <span class="invalid-feedback" role="alert">

                                <strong>{{ $message }}</strong>

                            </span>

                        @enderror

                        </div>



                        {{-- <div class="mb-3 text-start">

                            <div class="form-check">

                              <input class="form-check-input" name="confirm" type="checkbox" value="" id="check1">

                              <label class="form-check-label" for="check1">

                                I agree to the <a href="#" tabindex="-1">terms and policy</a>.

                              </label>

                            </div>

                        </div> --}}

                        <button type="submit"  class="btn btn-primary shadow-2 mb-4"> {{ __('Register') }}</button>

                    </form>

                    <p class="mb-0 text-muted">Allready have an account? <a href="{{ route('admin.login') }}">Log in</a></p>

                </div>

            </div>

        </div>

    </div>

    <script src="{{ asset('/assets/vendor/jquery/jquery.min.js')}}"></script>

    <script src="{{ asset('/assets/vendor/bootstrap/js/bootstrap.min.js')}}"></script>

</body>



</html>