@extends('layouts.app')

@section('content')
<style>
    .black-text {
        color: black !important;
    }
</style>
<div class="auth-content">
    <div class="card" style="margin: 10px 432px;">
        <div class="card-header">
            <ul class="nav nav-tabs card-header-tabs">
                <li class="nav-item">
                    <a class="nav-link active black-text" id="register-tab" data-bs-toggle="tab" href="#register-form">Register</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link black-text" id="login-tab" data-bs-toggle="tab" href="#login-form">Login</a>
                </li>
            </ul>
        </div>
        <div class="card-body text-center">
            <div class="tab-content">
                <div class="tab-pane fade show active" id="register-form">
                    <h6 class="mb-4 text-muted">Create a new account</h6>
                    <form method="POST" action="{{ route('register') }}">
                        @csrf
                <div class="mb-3 text-start">
                    <label for="name" class="form-label">Name</label>
                    <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>
                    @error('name')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                </div>

                <div class="mb-3 text-start">
                    <label for="phone" class="form-label">Phone</label>
                    <div class="input-group">
                        <input id="country_code" type="text" class="form-control country-code" name="country_code" value="+855" readonly required>
                        <input id="phone" type="text" class="form-control phone-input @error('phone') is-invalid @enderror" maxlength="10" name="phone" required>
                    </div>
                </div>

                <div class="mb-3 text-start">
                    <label for="email" class="form-label">{{ __('Email Address') }}</label>
                    <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">
                    @error('email')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                </div>

                <div class="mb-3 text-start">
                    <label for="password" class="form-label">{{ __('Password') }}</label>
                    <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">
                    @error('password')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                </div>

                <div class="mb-3 text-start">
                    <label for="password" class="form-label">{{ __('Confirm Password') }}</label>
                    <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                    @error('password')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                </div>

                <button type="submit" class="btn btn-primary shadow-2 mb-4">{{ __('Register') }}</button>
                    </form>
                </div>
                <div class="tab-pane fade" id="login-form">
                    <h6 class="mb-4 text-muted">Log in to your account</h6>
                    <form method="POST" action="{{ route('login') }}">
                    @csrf
                        <div class="mb-3 text-start">
                            <label for="email" class="form-label">Email adress</label>
                             <input id="email_register" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                            {{-- <input type="email" class="form-control" placeholder="Enter Email" required> --}}
                             @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                            @enderror
                        </div>
                        <div class="mb-3 text-start">
                            <label for="password" class="form-label">Password</label>
                            <input id="password_register" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password">
                            {{-- <input type="password" class="form-control" placeholder="Password" required> --}}
                            @error('password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>

                        <div class="mb-3 text-start">
                            <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                <label class="form-check-label" for="remember">
                                    {{ __('Remember Me') }}
                                </label>
                              {{-- <input class="form-check-input" name="remember" type="checkbox" value="" id="check1">
                              <label class="form-check-label" for="check1">
                                Remember me on this device
                              </label> --}}
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">
                                    {{ __('Login') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="{{ asset('assets/vendor/jquery/jquery.min.js')}}"></script>
<script src="{{ asset('assets/vendor/bootstrap/js/bootstrap.min.js')}}"></script>
@endsection
