@extends('layouts.app')
@section('content')
<style>
  a {
    text-decoration: none;
  }

  span {
    color: white;
  }

  table,
  thead,
  tr,
  td {
    color: white;
  }

  section.ticket {
    display: flex;
    justify-content: center;
  }

  .multisteps_form {
    margin: 0rem 0rem;
    padding: 2rem 15px !important;
  }

  .card {
    background-image: linear-gradient(to right, #0f0c29, #302b63, #24243e);
    box-shadow: rgb(254 254 254 / 22%) 0px 5px 15px !important;
    border-radius: 10px;
    border: 1px solid #ffffff38;
  }

  .span-tittel {
    width: 105px;
    display: inline-block;
  }

  #checker-content {
    padding: 15px 20px 0px;
    text-align: center;
  }

  .line {
    position: relative;
    display: inline-block;
    padding: 20px 0 30px;
    border-bottom: 1px solid #ffffff38;
  }

  .numbers {
    align-items: center;
    display: flex;
  }

  .numbers ul {
    margin-bottom: 0px;
  }

  .numbers ul,
  .numbers li {
    position: relative;
    list-style-type: none;
    display: inline-block;
  }

  .numbers ul:first-child {
    margin-right: 30px;
  }

  .numbers input {
    border: none;
    border-radius: 8px;
    padding: 5px;
    font-size: 30px;
    font-weight: bold;
    text-align: center;
    width: 70px;
    height: 70px;
    margin: 0 2px;
  }

  .clean {
    position: relative;
    font-size: 30px;
    padding-left: 20px;
    cursor: pointer;
  }

  #checker-reset,
  .clean {
    display: inline-block;
  }

  #checker button {
    display: inline-block;
    -webkit-appearance: none;
    background: none;
    border: none;
    color: #0A8901;
    padding: 10px;
    font-size: 20px;
    margin-bottom: 20px;
    cursor: pointer;
    margin-left: auto;
    margin-right: auto;
  }

  .btn.clean.btn-danger {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 60px;
    height: 60px;
    padding: 0px;
    border-radius: 8px;
  }

  .main-label {
    margin-bottom: 5px;
  }

  .form-control {
    background: transparent;
    color: #fff;
    border: 1px solid #ffffff38;
  }

  .form-control:focus {
    background: transparent;
    color: #fff;
    border: 1px solid #ffffff;
    box-shadow: none;
  }

  .form-control::placeholder {
    color: #fff;
  }
</style>
<section class="ticket">
  <div class="multisteps_form  position-relative overflow-hidden">
    {{-- <div class="header-sec">
      <div class="row">
        <div class="col-md-5 d-flex">
          <div class="d-flex align-items-center ">
            <script src="https://unpkg.com/@lottiefiles/lottie-player@latest/dist/lottie-player.js"></script>
            <lottie-player src="https://assets8.lottiefiles.com/packages/lf20_sdsq6yiq.json" background="transparent"
              speed="1" style="width:100px; height: 70px;" loop autoplay></lottie-player>
            <h2 class="text-uppercase">christmas promotion lottery</h2>
          </div>
        </div>
        <div class="col-md-4 d-flex align-items-center">
          <div class="d-flex align-items-center pl-20">
            <div><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                class="bi bi-calendar-check" viewBox="0 0 16 16">
                <path
                  d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z" />
                <path
                  d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z" />
              </svg></div>

            <h4 class="pl-20">25<sup>th</sup> December 2022</h4>
          </div>
        </div>
        <div class="col-md-3  d-flex align-items-center">
          <div class="d-flex align-items-center pl-20">
            <div><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye"
                viewBox="0 0 16 16">
                <path
                  d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z" />
                <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z" />
              </svg></div>

            <h4 class="pl-20">Active</h4>
          </div>
        </div>
        <div class="d-flex justify-content-end expiry">
          <button>Expiry Date:<span style="padding-left:20px;">30<sup>th</sup> December 2022</span></button>
        </div>


      </div>
    </div> --}}

    <div class="card bg-gray mt-5 p-5">
      <div class="row justify-content-between align-items-center">
        <div class="col-md-8">
            <div class="row">
              <div class="col-md-6 mb-3">
                <div class="form-group">
                  {{-- <span class="span-tittel">Title:</span>  --}}
                  <span>SUPER LOTTO 2023</span>
                </div>
              </div>
              <div class="col-md-6 mb-3">
                <div class="form-group">
                  {{-- <span class="span-tittel">Time:</span>  --}}
                  <span>This is a Text Lotto</span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  {{-- <span class="span-tittel">Draw Date:</span>  --}}
                  <span>7th July 2023</span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  {{-- <span class="span-tittel">Ticket Price:</span> <span>$ {{ $gameDetail->game_ticket_prize }}</span> --}}
                </div>
              </div>
            </div>
          </div>
        <div class="col-md-2">
          @if(@ $gameDetail->featured_image)
          <img src="{{asset('game_images/'.@$gameDetail->featured_image)}}" class="rounded d-block img-fluid" alt=""
            style="height: auto;width: 100px;float: right;width:100% !important;">
          @else
          <img src="{{asset('logo.png')}}" class="rounded d-block img-fluid" alt=""
            style="height: auto;width: 100px;float: right;width:100% !important;">
          @endif
        </div>
        {{-- <div class="col">
          <div class="form-group">
            <span>Game Title:</span> <span>{{ $gameDetail->game_title }}</span>
          </div>
          <div class="form-group">
            <span>Game Description:</span> <span>{{ $gameDetail->game_description }}</span>
          </div>
          <div class="form-group">
            <span>Time Zone:</span> <span>{{ $gameDetail->game_time_zone }}</span>
          </div>
        </div>
        <div class="col">
          <div class="form-group">
            <span>Start Date and Time:</span> <span>{{ $gameDetail->game_start_date }} {{ date('g:i A',
              strtotime($gameDetail->game_start_time)) }}</span>
          </div>
          <div class="form-group">
            <span>End Date and Time:</span> <span>{{ $gameDetail->game_end_date }} {{ date('g:i A',
              strtotime($gameDetail->game_end_time)) }}</span>
          </div>
          <div class="form-group">
            <span>Draw Date and Time:</span> <span>{{ $gameDetail->game_draw_date }} {{ date('g:i A',
              strtotime($gameDetail->game_draw_time)) }}</span>
          </div>
          <div class="form-group">
            <span>Total Numbers allowed to Select:</span> <span>{{ $gameDetail->game_total_allowed_ticket }}</span>
          </div>
        </div>
        <div class="col">
          @if($gameDetail->featured_image)
          <img src="{{asset('game_images/'.$gameDetail->featured_image)}}" class="rounded d-block" alt=""
            style="height: auto;width: 100px;">
          @else
          <img src="{{asset('logo.png')}}" class="rounded d-block" alt="" style="height: auto;width: 100px;">
          @endif
        </div> --}}
      </div>
    </div>


    {{-- <div class="card bg-gray mt-5 p-5">
      @if ($errors->any())
      <div class="alert alert-danger">
        <ul>
          @foreach ($errors->all() as $error)
          <li>{{ $error }}</li>
          @endforeach
        </ul>
      </div>
      @endif
      @if($ticket == null)
      <form action="{{ route('user.store.ticket') }}" method="POST">
        <input type="hidden" name="game_id" value="{{$gameDetail->id}}">
        @csrf
        <div class="row">
          <table class="table table-bordered table-scroll mt-3" id="productTable">
            <thead>
              <tr>
                <th scope="col" class="text-center">SL NO</th>
                <th scope="col" class="text-center">Name</th>
                <th scope="col" class="text-center">Range</th>
                <th scope="col">
                  <button class="btn btn-info" id="addBtn" type="button"><i class="fa fa-plus"></i></button>
                </th>
              </tr>
            </thead>
            <tbody id="tbody">

            </tbody>
          </table>
        </div>
        <div class="form-group">
          <label for="" class="text-white">Enter the Amount($) <span class="text-danger">*</span></label>
          <input type="number" class="form-control" name="price"
            value="{{$gameDetail->game_min_range != '' ? $gameDetail->game_min_range : '0' }}"
            max="{{$gameDetail->game_max_range}}" min="{{$gameDetail->game_min_range}}" id="priceInput">
        </div>
        <div class="d-flex pt-5 justify-content-center">
          <button class="button-72 p-4" type="submit">Create Ticket</button>
        </div>
      </form>
      @else
      <h2 class="text-white">You have already created the ticket</h2>
      @endif
    </div>


    {{-- <div class="d-flex pt-5 justify-content-center">
      <a href="#"><button class="button-72 p-4" role="button">Create Ticket</button></a>
    </div>

  </div> --}}
  <div class="card bg-gray mt-5 p-5">
    <style>
                    .checker-results {
    background: #0A8901;
    display: flex;
    width: 100%;
    align-items: center;
    box-shadow: rgba(0,0,0,0.1) 0 3px 5px;
    text-align: center;
    margin-bottom: 0px
}
.checker-results .title {
    position: relative;
    color: #FFF;
    padding: 10px 30px;
    font-weight: 700;
    font-size: 18px;
    line-height: 20px;
    text-align: center;
    letter-spacing: 0;
}
.checker-results .title:after {
    content: "";
    background: #0A8901;
    position: absolute;
    width: 24px;
    height: 24px;
    top: calc(36%);
    right: -12px;
    transform: rotate(-45deg);
}
.checker-results .chosen-numbers {
    background: #F4F4F4;
    padding: 20px 25px;
    flex: 1;
    text-align: center;
}
.checker-results .chosen-numbers .padded {
    padding: 5px;
}
.ball {
    background: #0a8901;
    border: 6px solid #0a8901;
    color: #fff;
    width: 60px;
    height: 60px;
    display: inline-block;
    border-radius: 50%;
    text-align: center;
    font: 24px/48px Montserrat,sans-serif;
    font-weight: 700;
}
.ball.joker {
    border: 6px solid #0a8901;
    background: none;
    color: #0a8901;
}
    </style>
    <div class="row">
        <div class="col-md-12 mb-4">
            <div class="checker-results">
                <div>
                    <div class="title">Checking <br>Numbers</div>
                </div>
                <div class="chosen-numbers d-flex align-items-center justify-content-between">
                        <div class="qr-code">
                            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100" height="100" viewBox="0 0 150 150"><rect x="0" y="0" width="100" height="100" fill="#ffffff"></rect><g transform="scale(6)"><g transform="translate(0,0)"><path fill-rule="evenodd" d="M9 0L9 1L8 1L8 3L9 3L9 4L8 4L8 8L6 8L6 9L8 9L8 10L9 10L9 11L7 11L7 10L6 10L6 11L5 11L5 13L4 13L4 11L3 11L3 10L2 10L2 8L0 8L0 10L2 10L2 11L0 11L0 13L1 13L1 12L3 12L3 13L4 13L4 14L5 14L5 15L7 15L7 14L5 14L5 13L7 13L7 12L9 12L9 11L11 11L11 10L12 10L12 9L11 9L11 8L10 8L10 7L11 7L11 6L12 6L12 8L13 8L13 6L14 6L14 7L15 7L15 6L16 6L16 9L15 9L15 8L14 8L14 10L16 10L16 11L15 11L15 12L14 12L14 11L13 11L13 12L12 12L12 13L10 13L10 14L12 14L12 16L11 16L11 15L9 15L9 14L8 14L8 15L9 15L9 16L11 16L11 17L10 17L10 18L9 18L9 17L8 17L8 16L3 16L3 15L1 15L1 14L0 14L0 15L1 15L1 16L0 16L0 17L8 17L8 19L9 19L9 20L10 20L10 21L11 21L11 20L12 20L12 19L10 19L10 18L11 18L11 17L13 17L13 19L14 19L14 20L13 20L13 22L12 22L12 23L13 23L13 25L15 25L15 24L14 24L14 22L16 22L16 25L17 25L17 22L18 22L18 21L19 21L19 22L20 22L20 23L19 23L19 24L18 24L18 25L19 25L19 24L20 24L20 25L21 25L21 24L22 24L22 23L21 23L21 22L20 22L20 21L22 21L22 20L23 20L23 21L24 21L24 20L23 20L23 19L25 19L25 18L24 18L24 17L25 17L25 16L24 16L24 15L25 15L25 13L23 13L23 14L24 14L24 15L23 15L23 16L22 16L22 17L23 17L23 18L21 18L21 16L20 16L20 15L22 15L22 13L21 13L21 14L20 14L20 13L19 13L19 12L16 12L16 11L19 11L19 9L21 9L21 11L23 11L23 12L24 12L24 11L25 11L25 9L24 9L24 8L22 8L22 9L21 9L21 8L18 8L18 9L17 9L17 4L16 4L16 5L15 5L15 6L14 6L14 4L15 4L15 3L17 3L17 2L16 2L16 1L15 1L15 0L14 0L14 3L13 3L13 0L12 0L12 1L11 1L11 2L9 2L9 1L10 1L10 0ZM12 3L12 4L9 4L9 5L10 5L10 6L9 6L9 7L10 7L10 6L11 6L11 5L12 5L12 6L13 6L13 3ZM3 8L3 9L4 9L4 8ZM8 8L8 9L9 9L9 10L10 10L10 8ZM22 9L22 10L23 10L23 9ZM6 11L6 12L7 12L7 11ZM13 13L13 14L14 14L14 16L13 16L13 17L14 17L14 18L15 18L15 20L14 20L14 21L16 21L16 16L15 16L15 15L16 15L16 14L17 14L17 16L19 16L19 15L18 15L18 14L17 14L17 13L16 13L16 14L14 14L14 13ZM14 16L14 17L15 17L15 16ZM17 17L17 20L20 20L20 17ZM18 18L18 19L19 19L19 18ZM21 19L21 20L22 20L22 19ZM8 21L8 22L9 22L9 23L8 23L8 25L11 25L11 24L10 24L10 22L9 22L9 21ZM24 22L24 23L25 23L25 22ZM23 24L23 25L25 25L25 24ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM18 0L18 7L25 7L25 0ZM19 1L19 6L24 6L24 1ZM20 2L20 5L23 5L23 2ZM0 18L0 25L7 25L7 18ZM1 19L1 24L6 24L6 19ZM2 20L2 23L5 23L5 20Z" fill="#000000"></path></g></g></svg>
                        </div>
                        <div class="padded">
                            
                                <span class="result ball">23</span>
                            
                                <span class="result ball">8</span>
                            
                                <span class="result ball">45</span>
                            
                                <span class="result ball">42</span>
                            
                                <span class="result ball">50</span>
                            
                                <span class="result ball">47</span>
                            
                                <span class="result ball joker">5</span>
                            
                        </div>
                        <div class="d-flex h-100 align-items-center">
                            <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: red;margin-right: 15px;color: #fff;padding: 10px;">
                                <span>Loss</span>
                            </div>
                            <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: #0a8901;color: #fff;padding: 10px;">
                                <span>Won</span>
                            </div>
                        </div>
                </div>
            </div>
        </div>
        <div class="col-md-12 mb-4">
            <div class="checker-results">
                <div>
                    <div class="title">Checking <br>Numbers</div>
                </div>
                <div class="chosen-numbers d-flex align-items-center justify-content-between">
                        <div class="qr-code">
                            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100" height="100" viewBox="0 0 150 150"><rect x="0" y="0" width="100" height="100" fill="#ffffff"></rect><g transform="scale(6)"><g transform="translate(0,0)"><path fill-rule="evenodd" d="M9 0L9 1L8 1L8 3L9 3L9 4L8 4L8 8L6 8L6 9L8 9L8 10L9 10L9 11L7 11L7 10L6 10L6 11L5 11L5 13L4 13L4 11L3 11L3 10L2 10L2 8L0 8L0 10L2 10L2 11L0 11L0 13L1 13L1 12L3 12L3 13L4 13L4 14L5 14L5 15L7 15L7 14L5 14L5 13L7 13L7 12L9 12L9 11L11 11L11 10L12 10L12 9L11 9L11 8L10 8L10 7L11 7L11 6L12 6L12 8L13 8L13 6L14 6L14 7L15 7L15 6L16 6L16 9L15 9L15 8L14 8L14 10L16 10L16 11L15 11L15 12L14 12L14 11L13 11L13 12L12 12L12 13L10 13L10 14L12 14L12 16L11 16L11 15L9 15L9 14L8 14L8 15L9 15L9 16L11 16L11 17L10 17L10 18L9 18L9 17L8 17L8 16L3 16L3 15L1 15L1 14L0 14L0 15L1 15L1 16L0 16L0 17L8 17L8 19L9 19L9 20L10 20L10 21L11 21L11 20L12 20L12 19L10 19L10 18L11 18L11 17L13 17L13 19L14 19L14 20L13 20L13 22L12 22L12 23L13 23L13 25L15 25L15 24L14 24L14 22L16 22L16 25L17 25L17 22L18 22L18 21L19 21L19 22L20 22L20 23L19 23L19 24L18 24L18 25L19 25L19 24L20 24L20 25L21 25L21 24L22 24L22 23L21 23L21 22L20 22L20 21L22 21L22 20L23 20L23 21L24 21L24 20L23 20L23 19L25 19L25 18L24 18L24 17L25 17L25 16L24 16L24 15L25 15L25 13L23 13L23 14L24 14L24 15L23 15L23 16L22 16L22 17L23 17L23 18L21 18L21 16L20 16L20 15L22 15L22 13L21 13L21 14L20 14L20 13L19 13L19 12L16 12L16 11L19 11L19 9L21 9L21 11L23 11L23 12L24 12L24 11L25 11L25 9L24 9L24 8L22 8L22 9L21 9L21 8L18 8L18 9L17 9L17 4L16 4L16 5L15 5L15 6L14 6L14 4L15 4L15 3L17 3L17 2L16 2L16 1L15 1L15 0L14 0L14 3L13 3L13 0L12 0L12 1L11 1L11 2L9 2L9 1L10 1L10 0ZM12 3L12 4L9 4L9 5L10 5L10 6L9 6L9 7L10 7L10 6L11 6L11 5L12 5L12 6L13 6L13 3ZM3 8L3 9L4 9L4 8ZM8 8L8 9L9 9L9 10L10 10L10 8ZM22 9L22 10L23 10L23 9ZM6 11L6 12L7 12L7 11ZM13 13L13 14L14 14L14 16L13 16L13 17L14 17L14 18L15 18L15 20L14 20L14 21L16 21L16 16L15 16L15 15L16 15L16 14L17 14L17 16L19 16L19 15L18 15L18 14L17 14L17 13L16 13L16 14L14 14L14 13ZM14 16L14 17L15 17L15 16ZM17 17L17 20L20 20L20 17ZM18 18L18 19L19 19L19 18ZM21 19L21 20L22 20L22 19ZM8 21L8 22L9 22L9 23L8 23L8 25L11 25L11 24L10 24L10 22L9 22L9 21ZM24 22L24 23L25 23L25 22ZM23 24L23 25L25 25L25 24ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM18 0L18 7L25 7L25 0ZM19 1L19 6L24 6L24 1ZM20 2L20 5L23 5L23 2ZM0 18L0 25L7 25L7 18ZM1 19L1 24L6 24L6 19ZM2 20L2 23L5 23L5 20Z" fill="#000000"></path></g></g></svg>
                        </div>
                        <div class="padded">
                            
                                <span class="result ball">23</span>
                            
                                <span class="result ball">8</span>
                            
                                <span class="result ball">45</span>
                            
                                <span class="result ball">42</span>
                            
                                <span class="result ball">50</span>
                            
                                <span class="result ball">47</span>
                            
                                <span class="result ball joker">5</span>
                            
                        </div>
                        <div class="d-flex h-100 align-items-center">
                            <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: red;margin-right: 15px;color: #fff;padding: 10px;">
                                <span>Loss</span>
                            </div>
                            <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: #0a8901;color: #fff;padding: 10px;">
                                <span>Won</span>
                            </div>
                        </div>
                </div>
            </div>
        </div>
        <div class="col-md-12 mb-4">
            <div class="checker-results">
                <div>
                    <div class="title">Checking <br>Numbers</div>
                </div>
                <div class="chosen-numbers d-flex align-items-center justify-content-between">
                        <div class="qr-code">
                            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100" height="100" viewBox="0 0 150 150"><rect x="0" y="0" width="100" height="100" fill="#ffffff"></rect><g transform="scale(6)"><g transform="translate(0,0)"><path fill-rule="evenodd" d="M9 0L9 1L8 1L8 3L9 3L9 4L8 4L8 8L6 8L6 9L8 9L8 10L9 10L9 11L7 11L7 10L6 10L6 11L5 11L5 13L4 13L4 11L3 11L3 10L2 10L2 8L0 8L0 10L2 10L2 11L0 11L0 13L1 13L1 12L3 12L3 13L4 13L4 14L5 14L5 15L7 15L7 14L5 14L5 13L7 13L7 12L9 12L9 11L11 11L11 10L12 10L12 9L11 9L11 8L10 8L10 7L11 7L11 6L12 6L12 8L13 8L13 6L14 6L14 7L15 7L15 6L16 6L16 9L15 9L15 8L14 8L14 10L16 10L16 11L15 11L15 12L14 12L14 11L13 11L13 12L12 12L12 13L10 13L10 14L12 14L12 16L11 16L11 15L9 15L9 14L8 14L8 15L9 15L9 16L11 16L11 17L10 17L10 18L9 18L9 17L8 17L8 16L3 16L3 15L1 15L1 14L0 14L0 15L1 15L1 16L0 16L0 17L8 17L8 19L9 19L9 20L10 20L10 21L11 21L11 20L12 20L12 19L10 19L10 18L11 18L11 17L13 17L13 19L14 19L14 20L13 20L13 22L12 22L12 23L13 23L13 25L15 25L15 24L14 24L14 22L16 22L16 25L17 25L17 22L18 22L18 21L19 21L19 22L20 22L20 23L19 23L19 24L18 24L18 25L19 25L19 24L20 24L20 25L21 25L21 24L22 24L22 23L21 23L21 22L20 22L20 21L22 21L22 20L23 20L23 21L24 21L24 20L23 20L23 19L25 19L25 18L24 18L24 17L25 17L25 16L24 16L24 15L25 15L25 13L23 13L23 14L24 14L24 15L23 15L23 16L22 16L22 17L23 17L23 18L21 18L21 16L20 16L20 15L22 15L22 13L21 13L21 14L20 14L20 13L19 13L19 12L16 12L16 11L19 11L19 9L21 9L21 11L23 11L23 12L24 12L24 11L25 11L25 9L24 9L24 8L22 8L22 9L21 9L21 8L18 8L18 9L17 9L17 4L16 4L16 5L15 5L15 6L14 6L14 4L15 4L15 3L17 3L17 2L16 2L16 1L15 1L15 0L14 0L14 3L13 3L13 0L12 0L12 1L11 1L11 2L9 2L9 1L10 1L10 0ZM12 3L12 4L9 4L9 5L10 5L10 6L9 6L9 7L10 7L10 6L11 6L11 5L12 5L12 6L13 6L13 3ZM3 8L3 9L4 9L4 8ZM8 8L8 9L9 9L9 10L10 10L10 8ZM22 9L22 10L23 10L23 9ZM6 11L6 12L7 12L7 11ZM13 13L13 14L14 14L14 16L13 16L13 17L14 17L14 18L15 18L15 20L14 20L14 21L16 21L16 16L15 16L15 15L16 15L16 14L17 14L17 16L19 16L19 15L18 15L18 14L17 14L17 13L16 13L16 14L14 14L14 13ZM14 16L14 17L15 17L15 16ZM17 17L17 20L20 20L20 17ZM18 18L18 19L19 19L19 18ZM21 19L21 20L22 20L22 19ZM8 21L8 22L9 22L9 23L8 23L8 25L11 25L11 24L10 24L10 22L9 22L9 21ZM24 22L24 23L25 23L25 22ZM23 24L23 25L25 25L25 24ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM18 0L18 7L25 7L25 0ZM19 1L19 6L24 6L24 1ZM20 2L20 5L23 5L23 2ZM0 18L0 25L7 25L7 18ZM1 19L1 24L6 24L6 19ZM2 20L2 23L5 23L5 20Z" fill="#000000"></path></g></g></svg>
                        </div>
                        <div class="padded">
                            
                                <span class="result ball">23</span>
                            
                                <span class="result ball">8</span>
                            
                                <span class="result ball">45</span>
                            
                                <span class="result ball">42</span>
                            
                                <span class="result ball">50</span>
                            
                                <span class="result ball">47</span>
                            
                                <span class="result ball joker">5</span>
                            
                        </div>
                        <div class="d-flex h-100 align-items-center">
                            <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: red;margin-right: 15px;color: #fff;padding: 10px;">
                                <span>Loss</span>
                            </div>
                            <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: #0a8901;color: #fff;padding: 10px;">
                                <span>Won</span>
                            </div>
                        </div>
                </div>
            </div>
        </div>
    </div>
  </div>
</section>


<!--- JS WORK -->
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>
<script>

$(document).ready(function() {
  var lineIndex = $('.line').length; // Set lineIndex based on existing rows

  // Hide the trash icon for the first row initially
  $('.numbers .btn.clean.btn-danger').first().hide();

  // Add Line button click event
  $('#checker-add').click(function() {
    var lineTemplate = $('.line').first().clone(); // Clone the first line template
    lineTemplate.attr('data-index', lineIndex); // Set the data-index attribute
    lineTemplate.find('input').attr('name', `ticket_number[${lineIndex}][]`); // Update input field names

    // Append the new line template to the checker-lines container
    $('#checker-lines').append(lineTemplate);

    // Show the trash icon for newly added lines
    lineTemplate.find('.btn.clean.btn-danger').show();

    // Remove Line button click event
    lineTemplate.find('.btn.clean.btn-danger').click(function() {
      var line = $(this).closest('.line');
      var currentIndex = line.data('index');
      line.remove();

      // Update lineIndex for the remaining lines
      $('.line').each(function(index) {
        var newIndex = index;
        if (index >= currentIndex) {
          newIndex++;
        }
        $(this).attr('data-index', newIndex);
        $(this).find('input').attr('name', `ticket_number[${newIndex}][]`);
      });

      // Hide the trash icon for the first row
      $('.numbers .btn.clean.btn-danger').first().hide();

      // Update lineIndex based on remaining rows
      lineIndex = $('.line').length;
    });

    // Increment lineIndex for the next line
    lineIndex++;
  });
});



  
  $("#checker-submit").click(function() {
  $("input[name='ticket_sequence[]']").val(""); // Reset or empty the fields with the name "ticket_sequence"
  });

// Add line functionality
$(document).ready(function() {
//   $("#checker-add").click(function() {
//     var line = $(".line").last().clone();
//     line.find("input").val(""); // Clear input values in the cloned line
//     line.appendTo("#checker-lines");
//   });

  // Delete line functionality
  $(document).on("click", ".fa-trash", function() {
    $(this).closest(".line").remove();
  });

  // Move to next input when the current input reaches its maxlength
  $(document).on("input", "input[type='tel']", function() {
    if (this.value.length === this.maxLength) {
      $(this).closest("li").next("li").find("input").focus();
    }
  });

  // Allow only numeric input
  $(document).on("keypress", "input[type='tel']", function(e) {
    var keyCode = e.which ? e.which : e.keyCode;
    if (keyCode < 48 || keyCode > 57) {
      e.preventDefault();
    }
  });

  // Clear input values and result div on "clean" button click
  $(document).on("click", ".clean", function() {
    $(this).siblings("ul").find("input").val(""); // Clear input values
    $(this).siblings(".clean[data-type='result']").empty(); // Clear result div
  });
});


// Duplicate number check
$(document).ready(function() {
  $(document).on("blur", "input[type='tel']", function() {
    var $row = $(this).closest(".line");
    var $inputs = $row.find("input[type='tel']").not(this);
    var value = $(this).val();
    var duplicate = false;

    // Check if the input value is not empty
    if (value.trim() !== '') {
      $inputs.each(function() {
        if ($(this).val() === value) {
          duplicate = true;
          return false; // Exit the loop early if duplicate is found
        }
      });

      if (duplicate) {
        $(this).val(""); // Clear the input value if it is a duplicate
        Swal.fire({
          icon: 'error',
          title: 'Duplicate Number',
          text: 'Please enter a unique number within the row.',
          confirmButtonColor: '#3085d6',
          confirmButtonText: 'OK'
        });
      }
    }
  });
});



// Reset input values on clean button click
$(document).ready(function() {
  $(document).on("click", ".clean", function() {
    $(this).siblings("ul").find("input").val(""); // Clear input values
    $(this).siblings(".clean[data-type='result']").empty(); // Clear result div
  });
});


// Input validation for price field
$(document).ready(function() {
  $('#priceInput').on('change', function() {
    var price = $(this).val();
    var min = parseInt($(this).attr('min'));
    var max = parseInt($(this).attr('max'));

    if (price < min || price > max) {
      Swal.fire({
        icon: 'error',
        title: 'Invalid Amount',
        text: 'Please enter an amount between ' + min + ' and ' + max + '.',
      });
      $(this).val(min); // Reset the input to the minimum value
    }
  });
});


  // jQuery button click event to add a row
  // var rowIdx = '';
  // var maxRows = {{@$gameDetail->game_total_allowed_ticket}};
  // $('#addBtn').on('click', function () {
  //   var selectOptions = '';
  //   for (var i = 0; i <= 99; i++) {
  //     selectOptions += `<option value="${i}">${i}</option>`;
  //   }

  //   // Adding a row inside the tbody
  //   $('#tbody').append(`
  //     <tr>
  //       <td class="row-index text-center">${rowIdx + 1}</td>
  //       <td>
  //         <input class="form-control winning_number" name="name[]" id="" value="No ${rowIdx + 1}" readonly>
  //       </td>
  //       <td>
  //         <select class="form-control" name="range[]">
  //           <option value="">Select Range</option>
  //           ${selectOptions}
  //         </select>
  //       </td>
  //       <td class="text-center">
  //         <button class="btn btn-danger remove" type="button">Remove</button>
  //       </td>
  //     </tr>
  //   `);

  //   rowIdx++;
  //   if ($('#tbody tr').length >= maxRows) {
  //     $('#addBtn').hide();
  //   }
  // });

  // Check for duplicate numbers on select change event
  // $('#tbody').on('change', 'select[name="range[]"]', function () {
  //   var selectedNumbers = [];
  //   $('select[name="range[]"]').each(function () {
  //     var number = $(this).val();
  //     if (number !== '' && selectedNumbers.includes(number)) {
  //       // Show SweetAlert message for duplicate number
  //       Swal.fire({
  //         icon: 'error',
  //         title: 'Duplicate Number',
  //         text: 'Please select a unique range.',
  //       });
  //       $(this).val(''); // Clear the duplicate selection
  //     } else {
  //       selectedNumbers.push(number);
  //     }
  //   });
  // });

  // Remove row on button click
  // $('#tbody').on('click', '.remove', function () {
  //   $(this).closest('tr').remove();
  //   $('#addBtn').show();
  //   updateRowIndexes();
  // });

  // Update row indexes
//   function updateRowIndexes() {
//     $('#tbody .row-index').each(function (index) {
//       $(this).text(index + 1);
//     });
//   }
// });
</script>


@endsection