@extends('layouts.app')

@section('content')

    <div class="row mt-4">

        <style>

            .contact_form.bg-gray.position-relative.overflow-hidden{

                background-image: linear-gradient(to right, #0f0c29, #302b63, #24243e);

                box-shadow: rgb(254 254 254 / 22%) 0px 5px 15px;

                border-radius: 10px;

                border: 1px solid #ffffff38;

            }

            .head h1{

                color: #fff;

            }

            .contact label{

                color: #fff;

            }

            .form-control{

                background: transparent;

                color: #fff;

                border: 1px solid #ffffff38;

            }

            .form-control:focus{

                background: transparent;

                color: #fff;

                border: 1px solid #ffffff;

                box-shadow: none;

            }

            .form-control::placeholder{

                color: #fff;

            }

            button.btn.btn-primary{

                background: #ffffff;

                border: 1px solid #ffffff;

                color: #0f0c29;

                

            }

            button.btn.btn-primary:hover{

                background: transparent;

                border: 1px solid #ffffff;

                color: #fff;

            }

            button.btn.btn-primary:focus{

                box-shadow: none;

            }

            .address{

                border: 1px solid #ffffff38;

            }

            .add-head{

                background-color: transparent;

                border-bottom: 1px solid #ffffff38;

            }

            .text-orange{

                color: #fff;

            }

            input#countryCodeInput {

                width: 100px;

                background: transparent;

                border-bottom: 1px solid #ffffff38;

            }

            input#countryCodeInput:focus{

                border: 1px solid #ffffff;

            }

            input#phoneNumberInput {

                width: 100%;

            }

            .main-label{

                margin-bottom: 5px;

            }

            .form-check-input{

                background: transparent;

                border: 1px solid #ffffff38;

            }

            .form-check-input:checked {

                background-color: transparent;

                border-color: #ffffff;

            }

            .form-check-input:focus{

                box-shadow: unset;

            }

        </style>

        <div class="col-md-3">

            @if ($adPositions['ad1'])

                <img src="{{ asset($adPositions['ad1']->image) }}" class="img-fluid mb-5">

            @else

                <img src="{{ asset('/front/images/add-1.png')}}" class="img-fluid mb-5">

            @endif

            @if ($adPositions['ad2'])

                <img src="{{ asset($adPositions['ad2']->image) }}" class="img-fluid">

            @else

                <img src="{{ asset('/front/images/add-2.png')}}" class="img-fluid">

            @endif

        </div>

        <div class="col-md-6">

            @if (session('success'))

                <div class="alert alert-success">

                    {{ session('success') }}

                </div>

            @endif

            @if (session('error'))

                <div class="alert alert-danger">

                    {{ session('error') }}

                </div>

            @endif

            <div class="contact_form bg-gray position-relative overflow-hidden">

                <form action="{{ route('user.contact-us.store') }}" method="POST" class="contact bg-white p-2">

                    @csrf

                    <div class="head">

                        <h1>Contact</h1>

                    </div>

                    <div class="row text-color">

                        <div class="col-md-8 pt-2">

                            <label class="main-label">Title*</label>

                            <div class="form-check">

                                <input class="form-check-input" type="radio" name="title" id="flexRadioDefault1"

                                    value="Mrs" {{ old('title') == 'Mrs' ? 'checked' : '' }}>

                                <label class="form-check-label" for="flexRadioDefault1">

                                    Mrs

                                </label>

                            </div>

                            <div class="form-check">

                                <input class="form-check-input" type="radio" name="title" id="flexRadioDefault2"

                                    value="Mr" {{ old('title', 'Mr') == 'Mr' ? 'checked' : '' }}>

                                <label class="form-check-label" for="flexRadioDefault2">

                                    Mr

                                </label>

                            </div>

                            <div class="mb-3 mt-3">

                                <input type="text" class="form-control" name="first_name" id="exampleInputEmail1"

                                    placeholder="First Name*" aria-describedby="emailHelp" required>

                                @if ($errors->has('first_name'))

                                    <span class="text-danger">{{ $errors->first('first_name') }}</span>

                                @endif

                            </div>

                            <div class="mb-3">

                                <input type="text" class="form-control" name="last_name" id="exampleInputEmail1"

                                    placeholder="Last Name*" aria-describedby="emailHelp"required>

                                @if ($errors->has('last_name'))

                                    <span class="text-danger">{{ $errors->first('last_name') }}</span>

                                @endif

                            </div>

                            <div class="mb-3">



                                <input type="Email" class="form-control" name="email" id="exampleInputEmail1"

                                    placeholder="Email*" aria-describedby="emailHelp" required>

                                @if ($errors->has('email'))

                                    <span class="text-danger">{{ $errors->first('email') }}</span>

                                @endif

                            </div>

                            <div class="mb-3">

                                <label class="main-label">Phone*</label>

                                <div class="input-group d-flex" style="flex-wrap: nowrap;">

                                    {{-- <div class="input-group-prepend">

                                        <span class="input-group-text">Country Code</span>

                                    </div> --}}

                                    <input type="text" class="form-control" name="country_code" id="countryCodeInput"

                                        value="+855" placeholder="+855" aria-describedby="countryCodeHelp" readonly>

                                    <input type="text" class="form-control" name="phone" id="phoneNumberInput"

                                        placeholder="xxxxxxxx" aria-describedby="phoneNumberHelp" maxlength="10" required>

                                </div>

                                @if ($errors->has('phone'))

                                    <span class="text-danger">{{ $errors->first('phone') }}</span>

                                @endif

                            </div>

                            



                            <div class="mb-3">

                                <label class="main-label">Subject*</label>

                                <input class="form-control" name="subject" placeholder="Subject*" required>

                                @if ($errors->has('subject'))

                                    <span class="text-danger">{{ $errors->first('subject') }}</span>

                                @endif

                            </div>

                            <div class="mb-3">

                                <div class="form-floating">

                                    <textarea class="form-control" name="comment" placeholder="Leave a comment here" id="floatingTextarea"></textarea>

                                    <label for="floatingTextarea">Message*</label>

                                    @if ($errors->has('comment'))

                                        <span class="text-danger">{{ $errors->first('comment') }}</span>

                                    @endif

                                </div>

                            </div>



                            <button type="submit" class="btn btn-primary">Submit</button>

                        </div>

                        <div class="col-md-4">

                            <div class="address">

                                <div class="add-head p-3">

                                    CONTACT

                                </div>

                                <div class="add-content text-orange p-2 d-flex ">

                                    <div class="pt-2 pb-2"><svg xmlns="http://www.w3.org/2000/svg" width="16"

                                            height="16" fill="currentColor" class="bi bi-clock" viewBox="0 0 16 16">

                                            <path

                                                d="M8 3.5a.5.5 0 0 0-1 0V9a.5.5 0 0 0 .252.434l3.5 2a.5.5 0 0 0 .496-.868L8 8.71V3.5z" />

                                            <path

                                                d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16zm7-8A7 7 0 1 1 1 8a7 7 0 0 1 14 0z" />

                                        </svg> </div>

                                    <div class="pb-2 pt-2 pl-2">

                                        <h6>Opening Hours</h6>

                                        <h3>From {{ @$data->opening_day_from ?? 'Monday' }} to

                                            {{ @$data->opening_day_to ?? 'Friday' }}</h3>

                                        <h4>

                                            {{ isset($data->opening_time_from) ? date('h:i A', strtotime($data->opening_time_from)) : '10:00 A.M.' }}

                                            to

                                            {{ isset($data->opening_time_to) ? date('h:i A', strtotime($data->opening_time_to)) : '5:00 P.M.' }}

                                        </h4>

                                    </div>

                                </div>

                                <div class="add-content text-orange p-2 d-flex ">

                                    <div class="pt-2 pb-2"><svg xmlns="http://www.w3.org/2000/svg" width="16"

                                            height="16" fill="currentColor" class="bi bi-telephone"

                                            viewBox="0 0 16 16">

                                            <path

                                                d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.568 17.568 0 0 0 4.168 6.608 17.569 17.569 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.678.678 0 0 0-.58-.122l-2.19.547a1.745 1.745 0 0 1-1.657-.459L5.482 8.062a1.745 1.745 0 0 1-.46-1.657l.548-2.19a.678.678 0 0 0-.122-.58L3.654 1.328zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z" />

                                        </svg></div>

                                    <div class="pb-2 pt-2 pl-2">

                                        <h6>Contact</h6>

                                        <h3>{{ @$data->contact_number ?? '1234567890' }}</h3>

                                        <h6>Customer Service</h6>

                                    </div>

                                </div>

                                <div class="add-content text-orange p-2 d-flex ">

                                    <div class="pt-2 pb-2"><svg xmlns="http://www.w3.org/2000/svg" width="16"

                                            height="16" fill="currentColor" class="bi bi-box-arrow-right"

                                            viewBox="0 0 16 16">

                                            <path fill-rule="evenodd"

                                                d="M10 12.5a.5.5 0 0 1-.5.5h-8a.5.5 0 0 1-.5-.5v-9a.5.5 0 0 1 .5-.5h8a.5.5 0 0 1 .5.5v2a.5.5 0 0 0 1 0v-2A1.5 1.5 0 0 0 9.5 2h-8A1.5 1.5 0 0 0 0 3.5v9A1.5 1.5 0 0 0 1.5 14h8a1.5 1.5 0 0 0 1.5-1.5v-2a.5.5 0 0 0-1 0v2z" />

                                            <path fill-rule="evenodd"

                                                d="M15.854 8.354a.5.5 0 0 0 0-.708l-3-3a.5.5 0 0 0-.708.708L14.293 7.5H5.5a.5.5 0 0 0 0 1h8.793l-2.147 2.146a.5.5 0 0 0 .708.708l3-3z" />

                                        </svg></div>

                                    <div class="pb-2 pt-2 pl-2">

                                        <h6>Address</h6>

                                        <h3>{{ @$data->address ?? 'Address' }}</h3>

                                        <h6></h6>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </form>

            </div>



        </div>

        <div class="col-md-2">



            @if ($adPositions['ad3'])

                <img src="{{ asset($adPositions['ad3']->image) }}" class="img-fluid mb-5">

            @else

                <img src="{{ asset('/front/images/add-4.png')}}" class="img-fluid mb-5">

            @endif

            @if ($adPositions['ad4'])

                <img src="{{ asset($adPositions['ad4']->image) }}" class="img-fluid">

            @else

                <img src="{{ asset('/front/images/add-4.png')}}" class="img-fluid  mb-5">

            @endif

        </div>

    </div>

    </section>



    </div>

    @push('scripts')

        <script>

            // Set the default value as "+855" when the page loads

            document.getElementById("phoneInput").value = "+855";

        </script>

    @endpush

@endsection

