@extends('layouts.app')
@section('content')
<style>
  .content-edit-mode {
    display: none;
  }

  .small-popup {
    max-width: 400px;
    margin: auto;
  }

        .dropzone {
            background: #e3e6ff;
            border-radius: 13px;
            max-width: 550px;
            margin-left: auto;
            margin-right: auto;
            border: 2px dotted #1833FF;
            margin-top: 50px;
        }
        .my-account #pills-home .card{
            max-width: 680px;
        }
        .my-account .card{
            width: unset;
            background-image: linear-gradient(to right, #0f0c29, #302b63, #24243e);
            box-shadow: rgb(254 254 254 / 22%) 0px 5px 15px !important;
            border-radius: 10px;
            border: 1px solid #ffffff38;
            padding: 30px
        }
        /* #pills-profile  .card{
            max-width: 500px;
        } */
        button.btn.btn-primary{
                background: #FFFFFF;
                border: 1px solid #FFFFFF;
                color: #0f0c29;
                
            }
        button.btn.btn-primary:hover{
                background: transparent;
                border: 1px solid #FFFFFF;
                color: #fff;
            }
            button.btn.btn-primary:focus{
                box-shadow: none;
            }
            .form-control, form#file-upload{
                background: transparent;
                color: #fff;
                border: 1px solid #ffffff38;
            }
            .form-control:focus, form#file-upload:focus{
                background: transparent;
                color: #fff;
                border: 1px solid #FFFFFF;
                box-shadow: none;
            }
            .form-control::placeholder, form#file-upload::placeholder{
                color: #fff;
            }
            form#file-upload{
                margin-top: 0px;
            }
            span.input-group-text{
                width: 100px;
                background: transparent;
                border: 1px solid #ffffff38;
                color: #fff;
                cursor: pointer;
            }
            span.input-group-text:focus{
                border: 1px solid #FFFFFF !important;
            }
            .main-label{
                margin-bottom: 5px;
            }
            .form-control{
                text-align: start !important;
            }
            .tab-content>.tab-pane {
                display: none !important;
            }
            .tab-content>.active {
                display: block !important;
            }
            .nav-pills .nav-link{
                padding: 10px 15px !important;
                height: 45px;
                font-weight: 600 !important;
                font-size: 16px !important;
            }
            .nav-pills .nav-link.active, .nav-pills .show>.nav-link, .nav-pills .nav-link:hover {
                color: #0f0c29 !important;
                background: #FFFFFF !important;
                box-shadow: none !important;
            }
            .profile-img{
                max-width: 200px;
                max-height: 200px;
                display: flex;
                justify-content: center;
                align-items: center;
                overflow: hidden;
                border-radius: 8px; 
            }
            .profile-img img{
                max-width: 100%;
                max-height: 100%;
                object-fit: contain;
                border-radius: 8px; 
}

            .checker-results {
    background: #0A8901;
    display: flex;
    width: 100%;
    align-items: center;
    box-shadow: rgba(0,0,0,0.1) 0 3px 5px;
    text-align: center;
    margin-bottom: 0px
}
.checker-results .title {
    position: relative;
    color: #FFF;
    padding: 10px 30px;
    font-weight: 700;
    font-size: 18px;
    line-height: 20px;
    text-align: center;
    letter-spacing: 0;
}
.checker-results .title:after {
    content: "";
    background: #0A8901;
    position: absolute;
    width: 24px;
    height: 24px;
    top: calc(36%);
    right: -12px;
    transform: rotate(-45deg);
}
.checker-results .chosen-numbers {
    background: #F4F4F4;
    padding: 20px 25px;
    flex: 1;
    text-align: center;
}
.checker-results .chosen-numbers .padded {
    padding: 5px;
}
.ball {
    background: #0a8901;
    border: 6px solid #0a8901;
    color: #fff;
    width: 60px;
    height: 60px;
    display: inline-block;
    border-radius: 50%;
    text-align: center;
    font: 24px/48px Montserrat,sans-serif;
    font-weight: 700;
}
.ball.joker {
    border: 6px solid #0a8901;
    background: none;
    color: #0a8901;
}
.category {
    font-size: 20px;
    width: 300px;
    position: relative;
    left: 500px;
    background-color: #20103a !important;
    color: white;
    text-align: center;
}
.category {
    padding: 12px 15px;
    border-radius: 8px;
}
</style>
<link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.7.2/dropzone.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.7.2/min/dropzone.min.js"></script>
<section class="my-account mt-4">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <div class="position-relative overflow-hidde">
    <ul class="nav nav-pills d-flex justify-content-center mb-3" id="pills-tab" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link button-72 <?php echo (@$ticket == 1) ? '' : 'active'; ?>"" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home"
          type="button" role="tab" aria-controls="pills-home" aria-selected="<?php echo (@$ticket == 1) ? 'false' : 'true'; ?>">PERSONAL</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link button-72 <?php echo (@$ticket == 1) ? 'active' : ''; ?>" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile"
          type="button" role="tab" aria-controls="pills-profile" aria-selected="<?php echo (@$ticket == 1) ? 'true' : 'false'; ?>">TICKETS</button>
      </li>

    </ul>
    <div class="tab-content" id="pills-tabContent">
      <div class="tab-pane fade <?php echo (@$ticket == 1) ? '' : 'show active'; ?>" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab"
        tabindex="0">
        <div class="card">
          <div class="card-body">
            <div class="content-view-mode">
                <div class="row align-items-center mb-4">
                    <div class="col-md-5">
                        <div class="profile-img">
                            <img src="{{ asset('front/images/photo.jpeg') }}" class="" alt="profile">
                        </div>
                        
                    </div>
                    <div class="col-md-7">
                        <div class="text-start">
                            <p class="d-flex align-items-center"><span style="margin-right: 6px; width: 20px;" class="d-flex justify-content-center"><i class="fa fa-user-o" aria-hidden="true"></i></span> {{ Auth::user()->name }}</p>
                            <p class="d-flex align-items-center"><span style="margin-right: 6px; width: 20px;" class="d-flex justify-content-center"><i class="fa fa-mobile" aria-hidden="true"></i></span> {{ Auth::user()->country_code }} {{ Auth::user()->phone }}</p>
                            <p class="d-flex align-items-center"><span style="margin-right: 6px; width: 20px;" class="d-flex justify-content-center"><i class="fa fa-envelope-o" aria-hidden="true"></i></span> {{ Auth::user()->email }}</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4 text-start">
                        <p style="font-size: 15px;"><b style="margin-right:6px; font-weight: 600;">Total Tickets Placed:</b>20</p>
                    </div>
                    <div class="col-md-4 text-start">
                        <p style="font-size: 15px;"><b style="margin-right:6px; font-weight: 600;">Total Tickets Won:</b>5</p>
                    </div>
                    <div class="col-md-4 text-start">
                        <p style="font-size: 15px;"><b style="margin-right:6px; font-weight: 600;">No Match:</b>15 </p>
                    </div>
                </div>
              {{-- @if(Auth::user()->profile_image) --}}
            
                {{-- <img src="{{ asset('front/images/photo.jpeg') }}" width="200" height="200" class="img-round mb-3" alt="profile"> --}}
              {{-- @else
              <img src="{{ asset('storage/profile_images/' . Auth::user()->profile_image) }}" width="200" height="200"
              class="img-round" alt="profile">
                <img src="{{ asset('front/images/photo.jpeg') }}" width="200" height="200" class="img-round" alt="profile">
              @endif --}}
                {{-- <h4 class="mb-3">{{ Auth::user()->name }}</h4> --}}
              {{-- <p><strong>Name:</strong> {{ Auth::user()->name }}</p> --}}
              {{-- <div class="">
                <p><span style="margin-right: 6px;"><i class="fa fa-envelope-o" aria-hidden="true"></i></span> {{ Auth::user()->email }}</p>
                <p><span style="margin-right: 6px;"><i class="fa fa-mobile" aria-hidden="true"></i></span> {{ Auth::user()->country_code }} {{ Auth::user()->phone }}</p>
              </div> --}}
              <button class="btn btn-primary" id="edit_btn_profile">Edit</button>
            </div>
            <div class="content-edit-mode" style="display: none;">
              <div id="dropzone">
        <form action="{{ route('user.dropzoneFileUpload') }}" class="dropzone mb-3" id="file-upload" enctype="multipart/form-data">
            @csrf
            <div class="dz-message">
                Drag and Drop Single/Multiple Files Here<br>
            </div>
        </form>
    </div>
              <div class="profile-image">
                {{-- <img src="{{ asset('front/images/photo.jpeg')}}" width="200" height="200" class="img-round"
                  alt="profile">
                <input type="file" class="form-control-file" id="image-input"> --}}
              </div>
              <div class="form-group text-start mb-3">
                <label class="main-label" for="name-input">Name</label>
                <input type="text" class="form-control text-center" id="name-input" value="{{ Auth::user()->name }}">
              </div>
              <div class="form-group text-start mb-3">
                <label class="main-label" for="email-input">Email</label>
                <input type="email" class="form-control text-center" id="email-input" value="{{ Auth::user()->email }}">
              </div>
              <div class="form-group text-start mb-3">
                <label class="main-label" for="phone-input">Phone No</label>
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text">{{ Auth::user()->country_code }}</span>
                  </div>
                  <input type="text" class="form-control text-center" id="phone-input"
                    value="{{ Auth::user()->phone }}">
                </div>
              </div>
              <div class="form-group mt-5">
                <button class="btn btn-primary save-btn">Save</button>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="tab-pane fade d-flex justify-content-center flex-column ticket-card <?php echo (@$ticket == 1) ? 'show active' : ''; ?>" id="pills-profile"
        role="tabpanel" aria-labelledby="pills-profile-tab" tabindex="0">
        <div class="row">
          <div class="col-md-12 mb-4 mt-4 d-flex justify-content-between">
            <div class="">
              <button id="category" class="category <?php echo (@$ticket == 1) ? 'active' : 'inactive'; ?>">Ticket Result</button>
            </div>
            <div class="">
              <button id="" class="<?php echo (@$ticket == 1) ? 'inactive' : 'active'; ?>">Pending</button>
            </div>
          </div>
          @php
          @$tickets = App\Models\Ticket::orderBy('created_at', 'asc')
                    ->where('user_id', Auth::user()->id)
                    ->distinct('game_id')
                    ->get();
         


            @$lastTicket = App\Models\Ticket::latest()->first();
            @$ticket_sequences_new = App\Models\TicketSequence::where('ticket_id', $lastTicket->id)->get();
            @$totalPairs = $ticket_sequences_new->count()
          @endphp
          <div class="accordion" id="ticketsAccordion">
            @foreach ($tickets as $ticket)
            @php
              $game = App\Models\GameDetail::where('id', $ticket->game_id)->first();
          @endphp
            <div class="accordion-item">
                <h2 class="accordion-header" id="ticketHeading{{ $ticket->id }}">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ticketCollapse{{ $ticket->id }}" aria-expanded="false" aria-controls="ticketCollapse{{ $ticket->id }}">
                      {{$game->game_title}}
                      <br>
                      {{$game->game_draw_date}}
                      <br>
                      $ {{$ticket->win_amount}}
                    </button>
                </h2>
                <div id="ticketCollapse{{ $ticket->id }}" class="accordion-collapse collapse" aria-labelledby="ticketHeading{{ $ticket->id }}" data-bs-parent="#ticketsAccordion">
                  <div class="col-md-12 mb-4">
                    @for ($i = 0; $i < count($ticket_sequences_new); $i += 6)
                    <div class="checker-results">
                        <div>
                            <div class="title">Checking <br>Numbers</div>
                        </div>
                        <div class="chosen-numbers d-flex align-items-center justify-content-between">
                                <div class="qr-code">
                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100" height="100" viewBox="0 0 150 150"><rect x="0" y="0" width="100" height="100" fill="#ffffff"></rect><g transform="scale(6)"><g transform="translate(0,0)"><path fill-rule="evenodd" d="M9 0L9 1L8 1L8 3L9 3L9 4L8 4L8 8L6 8L6 9L8 9L8 10L9 10L9 11L7 11L7 10L6 10L6 11L5 11L5 13L4 13L4 11L3 11L3 10L2 10L2 8L0 8L0 10L2 10L2 11L0 11L0 13L1 13L1 12L3 12L3 13L4 13L4 14L5 14L5 15L7 15L7 14L5 14L5 13L7 13L7 12L9 12L9 11L11 11L11 10L12 10L12 9L11 9L11 8L10 8L10 7L11 7L11 6L12 6L12 8L13 8L13 6L14 6L14 7L15 7L15 6L16 6L16 9L15 9L15 8L14 8L14 10L16 10L16 11L15 11L15 12L14 12L14 11L13 11L13 12L12 12L12 13L10 13L10 14L12 14L12 16L11 16L11 15L9 15L9 14L8 14L8 15L9 15L9 16L11 16L11 17L10 17L10 18L9 18L9 17L8 17L8 16L3 16L3 15L1 15L1 14L0 14L0 15L1 15L1 16L0 16L0 17L8 17L8 19L9 19L9 20L10 20L10 21L11 21L11 20L12 20L12 19L10 19L10 18L11 18L11 17L13 17L13 19L14 19L14 20L13 20L13 22L12 22L12 23L13 23L13 25L15 25L15 24L14 24L14 22L16 22L16 25L17 25L17 22L18 22L18 21L19 21L19 22L20 22L20 23L19 23L19 24L18 24L18 25L19 25L19 24L20 24L20 25L21 25L21 24L22 24L22 23L21 23L21 22L20 22L20 21L22 21L22 20L23 20L23 21L24 21L24 20L23 20L23 19L25 19L25 18L24 18L24 17L25 17L25 16L24 16L24 15L25 15L25 13L23 13L23 14L24 14L24 15L23 15L23 16L22 16L22 17L23 17L23 18L21 18L21 16L20 16L20 15L22 15L22 13L21 13L21 14L20 14L20 13L19 13L19 12L16 12L16 11L19 11L19 9L21 9L21 11L23 11L23 12L24 12L24 11L25 11L25 9L24 9L24 8L22 8L22 9L21 9L21 8L18 8L18 9L17 9L17 4L16 4L16 5L15 5L15 6L14 6L14 4L15 4L15 3L17 3L17 2L16 2L16 1L15 1L15 0L14 0L14 3L13 3L13 0L12 0L12 1L11 1L11 2L9 2L9 1L10 1L10 0ZM12 3L12 4L9 4L9 5L10 5L10 6L9 6L9 7L10 7L10 6L11 6L11 5L12 5L12 6L13 6L13 3ZM3 8L3 9L4 9L4 8ZM8 8L8 9L9 9L9 10L10 10L10 8ZM22 9L22 10L23 10L23 9ZM6 11L6 12L7 12L7 11ZM13 13L13 14L14 14L14 16L13 16L13 17L14 17L14 18L15 18L15 20L14 20L14 21L16 21L16 16L15 16L15 15L16 15L16 14L17 14L17 16L19 16L19 15L18 15L18 14L17 14L17 13L16 13L16 14L14 14L14 13ZM14 16L14 17L15 17L15 16ZM17 17L17 20L20 20L20 17ZM18 18L18 19L19 19L19 18ZM21 19L21 20L22 20L22 19ZM8 21L8 22L9 22L9 23L8 23L8 25L11 25L11 24L10 24L10 22L9 22L9 21ZM24 22L24 23L25 23L25 22ZM23 24L23 25L25 25L25 24ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM18 0L18 7L25 7L25 0ZM19 1L19 6L24 6L24 1ZM20 2L20 5L23 5L23 2ZM0 18L0 25L7 25L7 18ZM1 19L1 24L6 24L6 19ZM2 20L2 23L5 23L5 20Z" fill="#000000"></path></g></g></svg>
                                </div>
                                <div class="padded">
                                  @for ($j = $i; $j < min($i + 6, count($ticket_sequences_new)); $j++)
                                  <span class="result ball">{{ $ticket_sequences_new[$j]->winning_sequence }}</span>
                                @endfor
                                </div>
                                <div class="d-flex h-100 align-items-center">
                                    <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: red;margin-right: 15px;color: #fff;padding: 10px;">
                                        <span>Loss</span>
                                    </div>
                                    <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: #0a8901;color: #fff;padding: 10px;">
                                        <span>Won</span>
                                    </div>
                                </div>
                        </div>
                    </div>
                    @endfor
                </div>
                </div>
            </div>
            @endforeach
        </div>
{{--         
            <div class="col-md-12 mb-4">
                <div class="checker-results">
                    <div>
                        <div class="title">Checking <br>Numbers</div>
                    </div>
                    <div class="chosen-numbers d-flex align-items-center justify-content-between">
                            <div class="qr-code">
                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100" height="100" viewBox="0 0 150 150"><rect x="0" y="0" width="100" height="100" fill="#ffffff"></rect><g transform="scale(6)"><g transform="translate(0,0)"><path fill-rule="evenodd" d="M9 0L9 1L8 1L8 3L9 3L9 4L8 4L8 8L6 8L6 9L8 9L8 10L9 10L9 11L7 11L7 10L6 10L6 11L5 11L5 13L4 13L4 11L3 11L3 10L2 10L2 8L0 8L0 10L2 10L2 11L0 11L0 13L1 13L1 12L3 12L3 13L4 13L4 14L5 14L5 15L7 15L7 14L5 14L5 13L7 13L7 12L9 12L9 11L11 11L11 10L12 10L12 9L11 9L11 8L10 8L10 7L11 7L11 6L12 6L12 8L13 8L13 6L14 6L14 7L15 7L15 6L16 6L16 9L15 9L15 8L14 8L14 10L16 10L16 11L15 11L15 12L14 12L14 11L13 11L13 12L12 12L12 13L10 13L10 14L12 14L12 16L11 16L11 15L9 15L9 14L8 14L8 15L9 15L9 16L11 16L11 17L10 17L10 18L9 18L9 17L8 17L8 16L3 16L3 15L1 15L1 14L0 14L0 15L1 15L1 16L0 16L0 17L8 17L8 19L9 19L9 20L10 20L10 21L11 21L11 20L12 20L12 19L10 19L10 18L11 18L11 17L13 17L13 19L14 19L14 20L13 20L13 22L12 22L12 23L13 23L13 25L15 25L15 24L14 24L14 22L16 22L16 25L17 25L17 22L18 22L18 21L19 21L19 22L20 22L20 23L19 23L19 24L18 24L18 25L19 25L19 24L20 24L20 25L21 25L21 24L22 24L22 23L21 23L21 22L20 22L20 21L22 21L22 20L23 20L23 21L24 21L24 20L23 20L23 19L25 19L25 18L24 18L24 17L25 17L25 16L24 16L24 15L25 15L25 13L23 13L23 14L24 14L24 15L23 15L23 16L22 16L22 17L23 17L23 18L21 18L21 16L20 16L20 15L22 15L22 13L21 13L21 14L20 14L20 13L19 13L19 12L16 12L16 11L19 11L19 9L21 9L21 11L23 11L23 12L24 12L24 11L25 11L25 9L24 9L24 8L22 8L22 9L21 9L21 8L18 8L18 9L17 9L17 4L16 4L16 5L15 5L15 6L14 6L14 4L15 4L15 3L17 3L17 2L16 2L16 1L15 1L15 0L14 0L14 3L13 3L13 0L12 0L12 1L11 1L11 2L9 2L9 1L10 1L10 0ZM12 3L12 4L9 4L9 5L10 5L10 6L9 6L9 7L10 7L10 6L11 6L11 5L12 5L12 6L13 6L13 3ZM3 8L3 9L4 9L4 8ZM8 8L8 9L9 9L9 10L10 10L10 8ZM22 9L22 10L23 10L23 9ZM6 11L6 12L7 12L7 11ZM13 13L13 14L14 14L14 16L13 16L13 17L14 17L14 18L15 18L15 20L14 20L14 21L16 21L16 16L15 16L15 15L16 15L16 14L17 14L17 16L19 16L19 15L18 15L18 14L17 14L17 13L16 13L16 14L14 14L14 13ZM14 16L14 17L15 17L15 16ZM17 17L17 20L20 20L20 17ZM18 18L18 19L19 19L19 18ZM21 19L21 20L22 20L22 19ZM8 21L8 22L9 22L9 23L8 23L8 25L11 25L11 24L10 24L10 22L9 22L9 21ZM24 22L24 23L25 23L25 22ZM23 24L23 25L25 25L25 24ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM18 0L18 7L25 7L25 0ZM19 1L19 6L24 6L24 1ZM20 2L20 5L23 5L23 2ZM0 18L0 25L7 25L7 18ZM1 19L1 24L6 24L6 19ZM2 20L2 23L5 23L5 20Z" fill="#000000"></path></g></g></svg>
                            </div>
                            <div class="padded">
                                
                                    <span class="result ball">23</span>
                                
                                    <span class="result ball">8</span>
                                
                                    <span class="result ball">45</span>
                                
                                    <span class="result ball">42</span>
                                
                                    <span class="result ball">50</span>
                                
                                    <span class="result ball">47</span>
                                
                                    <span class="result ball joker">5</span>
                                
                            </div>
                            <div class="d-flex h-100 align-items-center">
                                <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: red;margin-right: 15px;color: #fff;padding: 10px;">
                                    <span>Loss</span>
                                </div>
                                <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: #0a8901;color: #fff;padding: 10px;">
                                    <span>Won</span>
                                </div>
                            </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12 mb-4">
                <div class="checker-results">
                    <div>
                        <div class="title">Checking <br>Numbers</div>
                    </div>
                    <div class="chosen-numbers d-flex align-items-center justify-content-between">
                            <div class="qr-code">
                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100" height="100" viewBox="0 0 150 150"><rect x="0" y="0" width="100" height="100" fill="#ffffff"></rect><g transform="scale(6)"><g transform="translate(0,0)"><path fill-rule="evenodd" d="M9 0L9 1L8 1L8 3L9 3L9 4L8 4L8 8L6 8L6 9L8 9L8 10L9 10L9 11L7 11L7 10L6 10L6 11L5 11L5 13L4 13L4 11L3 11L3 10L2 10L2 8L0 8L0 10L2 10L2 11L0 11L0 13L1 13L1 12L3 12L3 13L4 13L4 14L5 14L5 15L7 15L7 14L5 14L5 13L7 13L7 12L9 12L9 11L11 11L11 10L12 10L12 9L11 9L11 8L10 8L10 7L11 7L11 6L12 6L12 8L13 8L13 6L14 6L14 7L15 7L15 6L16 6L16 9L15 9L15 8L14 8L14 10L16 10L16 11L15 11L15 12L14 12L14 11L13 11L13 12L12 12L12 13L10 13L10 14L12 14L12 16L11 16L11 15L9 15L9 14L8 14L8 15L9 15L9 16L11 16L11 17L10 17L10 18L9 18L9 17L8 17L8 16L3 16L3 15L1 15L1 14L0 14L0 15L1 15L1 16L0 16L0 17L8 17L8 19L9 19L9 20L10 20L10 21L11 21L11 20L12 20L12 19L10 19L10 18L11 18L11 17L13 17L13 19L14 19L14 20L13 20L13 22L12 22L12 23L13 23L13 25L15 25L15 24L14 24L14 22L16 22L16 25L17 25L17 22L18 22L18 21L19 21L19 22L20 22L20 23L19 23L19 24L18 24L18 25L19 25L19 24L20 24L20 25L21 25L21 24L22 24L22 23L21 23L21 22L20 22L20 21L22 21L22 20L23 20L23 21L24 21L24 20L23 20L23 19L25 19L25 18L24 18L24 17L25 17L25 16L24 16L24 15L25 15L25 13L23 13L23 14L24 14L24 15L23 15L23 16L22 16L22 17L23 17L23 18L21 18L21 16L20 16L20 15L22 15L22 13L21 13L21 14L20 14L20 13L19 13L19 12L16 12L16 11L19 11L19 9L21 9L21 11L23 11L23 12L24 12L24 11L25 11L25 9L24 9L24 8L22 8L22 9L21 9L21 8L18 8L18 9L17 9L17 4L16 4L16 5L15 5L15 6L14 6L14 4L15 4L15 3L17 3L17 2L16 2L16 1L15 1L15 0L14 0L14 3L13 3L13 0L12 0L12 1L11 1L11 2L9 2L9 1L10 1L10 0ZM12 3L12 4L9 4L9 5L10 5L10 6L9 6L9 7L10 7L10 6L11 6L11 5L12 5L12 6L13 6L13 3ZM3 8L3 9L4 9L4 8ZM8 8L8 9L9 9L9 10L10 10L10 8ZM22 9L22 10L23 10L23 9ZM6 11L6 12L7 12L7 11ZM13 13L13 14L14 14L14 16L13 16L13 17L14 17L14 18L15 18L15 20L14 20L14 21L16 21L16 16L15 16L15 15L16 15L16 14L17 14L17 16L19 16L19 15L18 15L18 14L17 14L17 13L16 13L16 14L14 14L14 13ZM14 16L14 17L15 17L15 16ZM17 17L17 20L20 20L20 17ZM18 18L18 19L19 19L19 18ZM21 19L21 20L22 20L22 19ZM8 21L8 22L9 22L9 23L8 23L8 25L11 25L11 24L10 24L10 22L9 22L9 21ZM24 22L24 23L25 23L25 22ZM23 24L23 25L25 25L25 24ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM18 0L18 7L25 7L25 0ZM19 1L19 6L24 6L24 1ZM20 2L20 5L23 5L23 2ZM0 18L0 25L7 25L7 18ZM1 19L1 24L6 24L6 19ZM2 20L2 23L5 23L5 20Z" fill="#000000"></path></g></g></svg>
                            </div>
                            <div class="padded">
                                
                                    <span class="result ball">23</span>
                                
                                    <span class="result ball">8</span>
                                
                                    <span class="result ball">45</span>
                                
                                    <span class="result ball">42</span>
                                
                                    <span class="result ball">50</span>
                                
                                    <span class="result ball">47</span>
                                
                                    <span class="result ball joker">5</span>
                                
                            </div>
                            <div class="d-flex h-100 align-items-center">
                                <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: red;margin-right: 15px;color: #fff;padding: 10px;">
                                    <span>Loss</span>
                                </div>
                                <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: #0a8901;color: #fff;padding: 10px;">
                                    <span>Won</span>
                                </div>
                            </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12 mb-4">
                <div class="checker-results">
                    <div>
                        <div class="title">Checking <br>Numbers</div>
                    </div>
                    <div class="chosen-numbers d-flex align-items-center justify-content-between">
                            <div class="qr-code">
                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100" height="100" viewBox="0 0 150 150"><rect x="0" y="0" width="100" height="100" fill="#ffffff"></rect><g transform="scale(6)"><g transform="translate(0,0)"><path fill-rule="evenodd" d="M9 0L9 1L8 1L8 3L9 3L9 4L8 4L8 8L6 8L6 9L8 9L8 10L9 10L9 11L7 11L7 10L6 10L6 11L5 11L5 13L4 13L4 11L3 11L3 10L2 10L2 8L0 8L0 10L2 10L2 11L0 11L0 13L1 13L1 12L3 12L3 13L4 13L4 14L5 14L5 15L7 15L7 14L5 14L5 13L7 13L7 12L9 12L9 11L11 11L11 10L12 10L12 9L11 9L11 8L10 8L10 7L11 7L11 6L12 6L12 8L13 8L13 6L14 6L14 7L15 7L15 6L16 6L16 9L15 9L15 8L14 8L14 10L16 10L16 11L15 11L15 12L14 12L14 11L13 11L13 12L12 12L12 13L10 13L10 14L12 14L12 16L11 16L11 15L9 15L9 14L8 14L8 15L9 15L9 16L11 16L11 17L10 17L10 18L9 18L9 17L8 17L8 16L3 16L3 15L1 15L1 14L0 14L0 15L1 15L1 16L0 16L0 17L8 17L8 19L9 19L9 20L10 20L10 21L11 21L11 20L12 20L12 19L10 19L10 18L11 18L11 17L13 17L13 19L14 19L14 20L13 20L13 22L12 22L12 23L13 23L13 25L15 25L15 24L14 24L14 22L16 22L16 25L17 25L17 22L18 22L18 21L19 21L19 22L20 22L20 23L19 23L19 24L18 24L18 25L19 25L19 24L20 24L20 25L21 25L21 24L22 24L22 23L21 23L21 22L20 22L20 21L22 21L22 20L23 20L23 21L24 21L24 20L23 20L23 19L25 19L25 18L24 18L24 17L25 17L25 16L24 16L24 15L25 15L25 13L23 13L23 14L24 14L24 15L23 15L23 16L22 16L22 17L23 17L23 18L21 18L21 16L20 16L20 15L22 15L22 13L21 13L21 14L20 14L20 13L19 13L19 12L16 12L16 11L19 11L19 9L21 9L21 11L23 11L23 12L24 12L24 11L25 11L25 9L24 9L24 8L22 8L22 9L21 9L21 8L18 8L18 9L17 9L17 4L16 4L16 5L15 5L15 6L14 6L14 4L15 4L15 3L17 3L17 2L16 2L16 1L15 1L15 0L14 0L14 3L13 3L13 0L12 0L12 1L11 1L11 2L9 2L9 1L10 1L10 0ZM12 3L12 4L9 4L9 5L10 5L10 6L9 6L9 7L10 7L10 6L11 6L11 5L12 5L12 6L13 6L13 3ZM3 8L3 9L4 9L4 8ZM8 8L8 9L9 9L9 10L10 10L10 8ZM22 9L22 10L23 10L23 9ZM6 11L6 12L7 12L7 11ZM13 13L13 14L14 14L14 16L13 16L13 17L14 17L14 18L15 18L15 20L14 20L14 21L16 21L16 16L15 16L15 15L16 15L16 14L17 14L17 16L19 16L19 15L18 15L18 14L17 14L17 13L16 13L16 14L14 14L14 13ZM14 16L14 17L15 17L15 16ZM17 17L17 20L20 20L20 17ZM18 18L18 19L19 19L19 18ZM21 19L21 20L22 20L22 19ZM8 21L8 22L9 22L9 23L8 23L8 25L11 25L11 24L10 24L10 22L9 22L9 21ZM24 22L24 23L25 23L25 22ZM23 24L23 25L25 25L25 24ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM18 0L18 7L25 7L25 0ZM19 1L19 6L24 6L24 1ZM20 2L20 5L23 5L23 2ZM0 18L0 25L7 25L7 18ZM1 19L1 24L6 24L6 19ZM2 20L2 23L5 23L5 20Z" fill="#000000"></path></g></g></svg>
                            </div>
                            <div class="padded">
                                
                                    <span class="result ball">23</span>
                                
                                    <span class="result ball">8</span>
                                
                                    <span class="result ball">45</span>
                                
                                    <span class="result ball">42</span>
                                
                                    <span class="result ball">50</span>
                                
                                    <span class="result ball">47</span>
                                
                                    <span class="result ball joker">5</span>
                                
                            </div>
                            <div class="d-flex h-100 align-items-center">
                                <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: red;margin-right: 15px;color: #fff;padding: 10px;">
                                    <span>Loss</span>
                                </div>
                                <div class="card-body text-center" style="width: 60px;height: 44.5px;background-color: #0a8901;color: #fff;padding: 10px;">
                                    <span>Won</span>
                                </div>
                            </div>
                    </div>
                </div>
            </div> --}}
        </div>
        {{-- <div class="card mt-3">
          <div class="d-flex justify-content-center pt-2">
            <h3 class="pr-3">Ticket No:</h3>
            <h3>57576575654654</h3>
          </div>
          <div class="d-flex justify-content-center pt-2">
            <h6 class="pr-3"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                class="bi bi-calendar-check" viewBox="0 0 16 16">
                <path
                  d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z" />
                <path
                  d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z" />
              </svg></h6>
            <h6>25<sup>th</sup> December 2022</h6>
          </div>
          <div class="d-flex justify-content-center pt-2 pb-3">
            <h6 class="pr-3"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                class="bi bi-eye" viewBox="0 0 16 16">
                <path
                  d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z" />
                <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z" />
              </svg></h6>
            <h6>Active</h6>
          </div>
        </div> --}}
        {{-- <div class="card mt-3">
          <div class="d-flex  justify-content-center pt-2">
            <h3 class="pr-3">Ticket No:</h3>
            <h3>57576575654654</h3>
          </div>
          <div class="d-flex justify-content-center pt-2">
            <h6 class="pr-3"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                class="bi bi-calendar-check" viewBox="0 0 16 16">
                <path
                  d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z" />
                <path
                  d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z" />
              </svg></h6>
            <h6>25<sup>th</sup> December 2022</h6>
          </div>
          <div class="d-flex justify-content-center pt-2 pb-3">
            <h6 class="pr-3"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                class="bi bi-eye" viewBox="0 0 16 16">
                <path
                  d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z" />
                <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z" />
              </svg></h6>
            <h6>Active</h6>
          </div>
        </div> --}}
        {{-- <div class="card mt-3">
          <div class="d-flex justify-content-center pt-2">
            <h3 class="pr-3">Ticket No:</h3>
            <h3>57576575654654</h3>
          </div>
          <div class="d-flex justify-content-center pt-2">
            <h6 class="pr-3"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                class="bi bi-calendar-check" viewBox="0 0 16 16">
                <path
                  d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z" />
                <path
                  d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z" />
              </svg></h6>
            <h6>25<sup>th</sup> December 2022</h6>
          </div>
          <div class="d-flex justify-content-center pt-2 pb-3">
            <h6 class="pr-3"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                class="bi bi-eye" viewBox="0 0 16 16">
                <path
                  d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z" />
                <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z" />
              </svg></h6>
            <h6>Active</h6>
          </div>
        </div> --}}
      </div>
    </div>
  </div>
  </div>
</section>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function() {
    // Edit button click event
    $('#edit_btn_profile').click(function() {
      $('.content-view-mode').hide();
      $('.content-edit-mode').show();
    });

  $('.save-btn').click(function() {
  var name = $('#name-input').val();
  var email = $('#email-input').val();
  var phone = $('#phone-input').val();

  // Get the selected image file
  var imageFile = $('#image-input')[0].files[0];

  // Create a random file name using the current date and a random number
  var currentDate = new Date().toISOString().slice(0, 10);
  var randomNumber = Math.floor(Math.random() * 10000);
  var fileName = 'profile_' + currentDate + '_' + randomNumber;

  // Create a FormData object to send the image file and other form data
  var formData = new FormData();
  // formData.append('image', imageFile, fileName);
  formData.append('name', name);
  formData.append('email', email);
  formData.append('phone', phone);

  // Perform AJAX request to update the user data and upload the image
  $.ajax({
    url: '{{ route("user.my-account.update") }}', // Replace with your update profile endpoint
    method: 'POST',
    data: formData,
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    processData: false,
    contentType: false,
    success: function(response) {
      // Show success popup using SweetAlert
      Swal.fire({
        icon: 'success',
        title: 'Profile Updated',
        text: 'Your profile has been updated successfully.',
        onClose: function() {
          // Reload the page
          location.reload();
        },
        customClass: {
          container: 'small-popup'
        }
      });
    },
    error: function(xhr, status, error) {
      // Show error message
      console.log(error);
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: 'An error occurred. Please try again.'
      });
    }
  });
});
  });

  
        var dropzone = new Dropzone('#file-upload', {
            previewTemplate: document.querySelector('#preview-template').innerHTML,
            parallelUploads: 1,
            thumbnailHeight: 150,
            thumbnailWidth: 150,
            maxFilesize: 1,
            filesizeBase: 1500,
            thumbnail: function (file, dataUrl) {
                if (file.previewElement) {
                    file.previewElement.classList.remove("dz-file-preview");
                    var images = file.previewElement.querySelectorAll("[data-dz-thumbnail]");
                    for (var i = 0; i < images.length; i++) {
                        var thumbnailElement = images[i];
                        thumbnailElement.alt = file.name;
                        thumbnailElement.src = dataUrl;
                    }
                    setTimeout(function () {
                        file.previewElement.classList.add("dz-image-preview");
                    }, 1);
                }
            }
        });
        
        var minSteps = 6,
            maxSteps = 60,
            timeBetweenSteps = 100,
            bytesPerStep = 100000;
        dropzone.uploadFiles = function (files) {
            var self = this;
            for (var i = 0; i < files.length; i++) {
                var file = files[i];
                totalSteps = Math.round(Math.min(maxSteps, Math.max(minSteps, file.size / bytesPerStep)));
                for (var step = 0; step < totalSteps; step++) {
                    var duration = timeBetweenSteps * (step + 1);
                    setTimeout(function (file, totalSteps, step) {
                        return function () {
                            file.upload = {
                                progress: 100 * (step + 1) / totalSteps,
                                total: file.size,
                                bytesSent: (step + 1) * file.size / totalSteps
                            };
                            self.emit('uploadprogress', file, file.upload.progress, file.upload
                                .bytesSent);
                            if (file.upload.progress == 100) {
                                file.status = Dropzone.SUCCESS;
                                self.emit("success", file, 'success', null);
                                self.emit("complete", file);
                                self.processQueue();
                            }
                        };
                    }(file, totalSteps, step), duration);
                }
            }
        }
   
</script>
@endsection