@extends('layouts.app')
@section('content')
<style>
  a {
    text-decoration: none;
  }

  span {
    color: white;
  }

  table,
  thead,
  tr,
  td {
    color: white;
  }

  section.ticket {
    display: flex;
    justify-content: center;
  }

  .multisteps_form {
    margin: 0rem 0rem;
    padding: 2rem 15px !important;
  }

  .card {
    background-image: linear-gradient(to right, #0f0c29, #302b63, #24243e);
    box-shadow: rgb(254 254 254 / 22%) 0px 5px 15px !important;
    border-radius: 10px;
    border: 1px solid #ffffff38;
  }

  .span-tittel {
    width: 105px;
    display: inline-block;
  }

  #checker-content {
    padding: 15px 20px 0px;
    text-align: center;
  }

  .line {
    position: relative;
    display: inline-block;
    padding: 20px 0 30px;
    border-bottom: 1px solid #ffffff38;
  }

  .numbers {
    align-items: center;
    display: flex;
  }

  .numbers ul {
    margin-bottom: 0px;
  }

  .numbers ul,
  .numbers li {
    position: relative;
    list-style-type: none;
    display: inline-block;
  }

  .numbers ul:first-child {
    margin-right: 30px;
  }

  .numbers input {
    border: none;
    border-radius: 8px;
    padding: 5px;
    font-size: 30px;
    font-weight: bold;
    text-align: center;
    width: 70px;
    height: 70px;
    margin: 0 2px;
  }

  .clean {
    position: relative;
    font-size: 30px;
    padding-left: 20px;
    cursor: pointer;
  }

  #checker-reset,
  .clean {
    display: inline-block;
  }

  #checker button {
    display: inline-block;
    -webkit-appearance: none;
    background: none;
    border: none;
    color: #0A8901;
    padding: 10px;
    font-size: 20px;
    margin-bottom: 20px;
    cursor: pointer;
    margin-left: auto;
    margin-right: auto;
  }

  .btn.clean.btn-danger {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 60px;
    height: 60px;
    padding: 0px;
    border-radius: 8px;
  }

  .main-label {
    margin-bottom: 5px;
  }

  .form-control {
    background: transparent;
    color: #fff;
    border: 1px solid #ffffff38;
  }

  .form-control:focus {
    background: transparent;
    color: #fff;
    border: 1px solid #ffffff;
    box-shadow: none;
  }

  .form-control::placeholder {
    color: #fff;
  }
</style>
<section class="ticket">
  <div class="multisteps_form  position-relative overflow-hidden">
    {{-- <div class="header-sec">
      <div class="row">
        <div class="col-md-5 d-flex">
          <div class="d-flex align-items-center ">
            <script src="https://unpkg.com/@lottiefiles/lottie-player@latest/dist/lottie-player.js"></script>
            <lottie-player src="https://assets8.lottiefiles.com/packages/lf20_sdsq6yiq.json" background="transparent"
              speed="1" style="width:100px; height: 70px;" loop autoplay></lottie-player>
            <h2 class="text-uppercase">christmas promotion lottery</h2>
          </div>
        </div>
        <div class="col-md-4 d-flex align-items-center">
          <div class="d-flex align-items-center pl-20">
            <div><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                class="bi bi-calendar-check" viewBox="0 0 16 16">
                <path
                  d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z" />
                <path
                  d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z" />
              </svg></div>

            <h4 class="pl-20">25<sup>th</sup> December 2022</h4>
          </div>
        </div>
        <div class="col-md-3  d-flex align-items-center">
          <div class="d-flex align-items-center pl-20">
            <div><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye"
                viewBox="0 0 16 16">
                <path
                  d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z" />
                <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z" />
              </svg></div>

            <h4 class="pl-20">Active</h4>
          </div>
        </div>
        <div class="d-flex justify-content-end expiry">
          <button>Expiry Date:<span style="padding-left:20px;">30<sup>th</sup> December 2022</span></button>
        </div>


      </div>
    </div> --}}

    <div class="card bg-gray mt-5 p-5">
      <div class="row justify-content-between align-items-center">
        <div class="col-md-8">
          <div class="row">
            <div class="col-md-6 mb-3">
              <div class="form-group">
                <span class="span-tittel">Title:</span> <span>{{ $gameDetail->game_title }}</span>
              </div>
            </div>
            <div class="col-md-6 mb-3">
              <div class="form-group">
                <span class="span-tittel">Time:</span> <span>{{ $gameDetail->game_start_date }} {{ date('g:i A',
                  strtotime($gameDetail->game_start_time)) }}</span>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <span class="span-tittel">Draw Date:</span> <span>{{ $gameDetail->game_draw_date }}</span>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <span class="span-tittel">Ticket Price:</span> <span>$ {{ $gameDetail->game_ticket_prize }}</span>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-2">
          @if($gameDetail->featured_image)
          <img src="{{asset('game_images/'.$gameDetail->featured_image)}}" class="rounded d-block img-fluid" alt=""
            style="height: auto;width: 100px;float: right;width:100% !important;">
          @else
          <img src="{{asset('logo.png')}}" class="rounded d-block img-fluid" alt=""
            style="height: auto;width: 100px;float: right;width:100% !important;">
          @endif
        </div>
        {{-- <div class="col">
          <div class="form-group">
            <span>Game Title:</span> <span>{{ $gameDetail->game_title }}</span>
          </div>
          <div class="form-group">
            <span>Game Description:</span> <span>{{ $gameDetail->game_description }}</span>
          </div>
          <div class="form-group">
            <span>Time Zone:</span> <span>{{ $gameDetail->game_time_zone }}</span>
          </div>
        </div>
        <div class="col">
          <div class="form-group">
            <span>Start Date and Time:</span> <span>{{ $gameDetail->game_start_date }} {{ date('g:i A',
              strtotime($gameDetail->game_start_time)) }}</span>
          </div>
          <div class="form-group">
            <span>End Date and Time:</span> <span>{{ $gameDetail->game_end_date }} {{ date('g:i A',
              strtotime($gameDetail->game_end_time)) }}</span>
          </div>
          <div class="form-group">
            <span>Draw Date and Time:</span> <span>{{ $gameDetail->game_draw_date }} {{ date('g:i A',
              strtotime($gameDetail->game_draw_time)) }}</span>
          </div>
          <div class="form-group">
            <span>Total Numbers allowed to Select:</span> <span>{{ $gameDetail->game_total_allowed_ticket }}</span>
          </div>
        </div>
        <div class="col">
          @if($gameDetail->featured_image)
          <img src="{{asset('game_images/'.$gameDetail->featured_image)}}" class="rounded d-block" alt=""
            style="height: auto;width: 100px;">
          @else
          <img src="{{asset('logo.png')}}" class="rounded d-block" alt="" style="height: auto;width: 100px;">
          @endif
        </div> --}}
      </div>
    </div>


    {{-- <div class="card bg-gray mt-5 p-5">
      @if ($errors->any())
      <div class="alert alert-danger">
        <ul>
          @foreach ($errors->all() as $error)
          <li>{{ $error }}</li>
          @endforeach
        </ul>
      </div>
      @endif
      @if($ticket == null)
      <form action="{{ route('user.store.ticket') }}" method="POST">
        <input type="hidden" name="game_id" value="{{$gameDetail->id}}">
        @csrf
        <div class="row">
          <table class="table table-bordered table-scroll mt-3" id="productTable">
            <thead>
              <tr>
                <th scope="col" class="text-center">SL NO</th>
                <th scope="col" class="text-center">Name</th>
                <th scope="col" class="text-center">Range</th>
                <th scope="col">
                  <button class="btn btn-info" id="addBtn" type="button"><i class="fa fa-plus"></i></button>
                </th>
              </tr>
            </thead>
            <tbody id="tbody">

            </tbody>
          </table>
        </div>
        <div class="form-group">
          <label for="" class="text-white">Enter the Amount($) <span class="text-danger">*</span></label>
          <input type="number" class="form-control" name="price"
            value="{{$gameDetail->game_min_range != '' ? $gameDetail->game_min_range : '0' }}"
            max="{{$gameDetail->game_max_range}}" min="{{$gameDetail->game_min_range}}" id="priceInput">
        </div>
        <div class="d-flex pt-5 justify-content-center">
          <button class="button-72 p-4" type="submit">Create Ticket</button>
        </div>
      </form>
      @else
      <h2 class="text-white">You have already created the ticket</h2>
      @endif
    </div>


    {{-- <div class="d-flex pt-5 justify-content-center">
      <a href="#"><button class="button-72 p-4" role="button">Create Ticket</button></a>
    </div>

  </div> --}}
  <div class="card bg-gray mt-5 p-5">
    <form action="{{ route('user.store.ticket') }}" method="POST" id="checker">
      @csrf
      <input type="hidden" name="game_id" value="{{$gameDetail->id}}">
      <p style="padding: 20px 30px; margin: 0 0 -30px; text-align: center;">Choose numbers</strong></p>

      <div id="checker-content">
        <div id="checker-lines">
          <div class="line" data-index="0">
            <div class="numbers">
              <div class="btn remove-row btn-danger" style="margin-right: 20px">
                <i class="fa fa-trash" aria-hidden="true"></i>
              </div>
              <ul class="p-0">
                <li>
                  <input type="tel" min="1" name="ticket_number[0][]" maxlength="2">
                </li>

                <li>
                  <input type="tel" min="1" name="ticket_number[0][]" maxlength="2">
                </li>

                <li>
                  <input type="tel" min="1" name="ticket_number[0][]" maxlength="2">
                </li>

                <li>
                  <input type="tel" min="1" name="ticket_number[0][]" maxlength="2">
                </li>

                <li>
                  <input type="tel" min="1" name="ticket_number[0][]" maxlength="2">
                </li>

                <li>
                  <input type="tel" min="1" name="ticket_number[0][]" maxlength="2">
                </li>

              </ul>

              <div class="btn clean btn-danger" style="margin-left: 20px" data-type="result">×</div>
            </div>

          </div>
        </div>
      </div>
      <div class="d-flex justify-content-center w-100">
        <div class="text-center">
          <button id="checker-add" value="+ Add Line" type="button" style="visibility: visible;">+ Add Line</button>
          <div class="form-group mb-3">
            <label for="" class="text-white main-label">Enter the Amount($) <span class="text-danger">*</span></label>
            <input type="number" class="form-control" name="price"
              value="{{$gameDetail->game_min_range != '' ? $gameDetail->game_min_range : '0' }}"
              max="{{$gameDetail->game_max_range}}" min="{{$gameDetail->game_min_range}}" id="priceInput">
          </div>
          <div id="checker-footer">
            {{-- <div>
              <label>
                <div>Check the last:</div>
                <select name="checkingPeriod" id="checker-period">
                  <option value="7" selected="">7 days</option>
                  <option value="30">30 days</option>
                  <option value="90">90 days</option>
                </select>
              </label>
              <label>
                <div>Draw Days:</div>
                <select name="checkingDays" id="checker-days">
                  <option value="0" selected="">All</option>
                  <option value="2">Tuesday</option>
                  <option value="5">Friday</option>
                </select>
              </label>
            </div> --}}
            <div>
              {{-- <div id="checker-reset" title="Clear all numbers" style="display: inline-block;"
                class="button grey reset">Reset Checker</div> --}}
              <input type="submit" id="checker-submit" type="button" value="Reset Checker" class="btn btn-danger"
                style="display: inline-block;">
              <input type="hidden" value="" id="checker-submit-value">
              <input type="hidden" name="js" value="enable" id="checker-js-availability">
              <input type="submit" id="checker-submit" value="Check Results" class="btn btn-success">
            </div>
          </div>
        </div>
      </div>


    </form>
  </div>
</section>


<!--- JS WORK -->
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>
<script>

$(document).ready(function() {
  
  var lineIndex = $('.line').length; // Set lineIndex based on existing rows

  // Hide the trash icon for the first row initially
  $('.numbers .btn.clean.btn-danger').first().hide();

  // Add Line button click event
  $('#checker-add').click(function() {
    var lineTemplate = $('.line').first().clone(); // Clone the first line template
    lineTemplate.attr('data-index', lineIndex); // Set the data-index attribute
    lineTemplate.find('input').attr('name', `ticket_number[${lineIndex}][]`); // Update input field names

    // Append the new line template to the checker-lines container
    $('#checker-lines').append(lineTemplate);

    // Show the trash icon for newly added lines
    lineTemplate.find('.btn.clean.btn-danger').show();

    // Remove Line button click event
    lineTemplate.find('.btn.clean.btn-danger').click(function() {
      var line = $(this).closest('.line');
      var currentIndex = line.data('index');
      line.remove();

      // Update lineIndex for the remaining lines
      $('.line').each(function(index) {
        var newIndex = index;
        if (index >= currentIndex) {
          newIndex++;
        }
        $(this).attr('data-index', newIndex);
        $(this).find('input').attr('name', `ticket_number[${newIndex}][]`);
      });

      // Hide the trash icon for the first row
      $('.numbers .btn.clean.btn-danger').first().hide();

      // Update lineIndex based on remaining rows
      lineIndex = $('.line').length;
    });

    // Increment lineIndex for the next line
    lineIndex++;
  });
});



  
  $("#checker-submit").click(function() {
  $("input[name='ticket_sequence[]']").val(""); // Reset or empty the fields with the name "ticket_sequence"
  });

// Add line functionality
$(document).ready(function() {
//   $("#checker-add").click(function() {
//     var line = $(".line").last().clone();
//     line.find("input").val(""); // Clear input values in the cloned line
//     line.appendTo("#checker-lines");
//   });

  // Delete line functionality
  $(document).on("click", ".fa-trash", function() {
    $(this).closest(".line").remove();
  });

  // Move to next input when the current input reaches its maxlength
  $(document).on("input", "input[type='tel']", function() {
    if (this.value.length === this.maxLength) {
      $(this).closest("li").next("li").find("input").focus();
    }
  });

  // Allow only numeric input
  $(document).on("keypress", "input[type='tel']", function(e) {
    var keyCode = e.which ? e.which : e.keyCode;
    if (keyCode < 48 || keyCode > 57) {
      e.preventDefault();
    }
  });

  // Clear input values and result div on "clean" button click
  $(document).on("click", ".clean", function() {
    $(this).siblings("ul").find("input").val(""); // Clear input values
    $(this).siblings(".clean[data-type='result']").empty(); // Clear result div
  });
});


// Duplicate number check
$(document).ready(function() {
  $(document).on("blur", "input[type='tel']", function() {
    var $row = $(this).closest(".line");
    var $inputs = $row.find("input[type='tel']").not(this);
    var value = $(this).val();
    var duplicate = false;

    // Check if the input value is not empty
    if (value.trim() !== '') {
      $inputs.each(function() {
        if ($(this).val() === value) {
          duplicate = true;
          return false; // Exit the loop early if duplicate is found
        }
      });

      if (duplicate) {
        $(this).val(""); // Clear the input value if it is a duplicate
        Swal.fire({
          icon: 'error',
          title: 'Duplicate Number',
          text: 'Please enter a unique number within the row.',
          confirmButtonColor: '#3085d6',
          confirmButtonText: 'OK'
        });
      }
    }
  });
});



// Reset input values on clean button click
$(document).ready(function() {
  $(document).on("click", ".clean", function() {
    $(this).siblings("ul").find("input").val(""); // Clear input values
    $(this).siblings(".clean[data-type='result']").empty(); // Clear result div
  });
});


// Input validation for price field
$(document).ready(function() {
  $('#priceInput').on('change', function() {
    var price = $(this).val();
    var min = parseInt($(this).attr('min'));
    var max = parseInt($(this).attr('max'));

    if (price < min || price > max) {
      Swal.fire({
        icon: 'error',
        title: 'Invalid Amount',
        text: 'Please enter an amount between ' + min + ' and ' + max + '.',
      });
      $(this).val(min); // Reset the input to the minimum value
    }
  });
});


  // jQuery button click event to add a row
  // var rowIdx = '';
  // var maxRows = {{$gameDetail->game_total_allowed_ticket}};
  // $('#addBtn').on('click', function () {
  //   var selectOptions = '';
  //   for (var i = 0; i <= 99; i++) {
  //     selectOptions += `<option value="${i}">${i}</option>`;
  //   }

  //   // Adding a row inside the tbody
  //   $('#tbody').append(`
  //     <tr>
  //       <td class="row-index text-center">${rowIdx + 1}</td>
  //       <td>
  //         <input class="form-control winning_number" name="name[]" id="" value="No ${rowIdx + 1}" readonly>
  //       </td>
  //       <td>
  //         <select class="form-control" name="range[]">
  //           <option value="">Select Range</option>
  //           ${selectOptions}
  //         </select>
  //       </td>
  //       <td class="text-center">
  //         <button class="btn btn-danger remove" type="button">Remove</button>
  //       </td>
  //     </tr>
  //   `);

  //   rowIdx++;
  //   if ($('#tbody tr').length >= maxRows) {
  //     $('#addBtn').hide();
  //   }
  // });

  // Check for duplicate numbers on select change event
  // $('#tbody').on('change', 'select[name="range[]"]', function () {
  //   var selectedNumbers = [];
  //   $('select[name="range[]"]').each(function () {
  //     var number = $(this).val();
  //     if (number !== '' && selectedNumbers.includes(number)) {
  //       // Show SweetAlert message for duplicate number
  //       Swal.fire({
  //         icon: 'error',
  //         title: 'Duplicate Number',
  //         text: 'Please select a unique range.',
  //       });
  //       $(this).val(''); // Clear the duplicate selection
  //     } else {
  //       selectedNumbers.push(number);
  //     }
  //   });
  // });

  // Remove row on button click
  // $('#tbody').on('click', '.remove', function () {
  //   $(this).closest('tr').remove();
  //   $('#addBtn').show();
  //   updateRowIndexes();
  // });

  // Update row indexes
//   function updateRowIndexes() {
//     $('#tbody .row-index').each(function (index) {
//       $(this).text(index + 1);
//     });
//   }
// });
</script>


@endsection