@extends('layouts.app')
@section('content')
<style>
  a{
    text-decoration: none;
  }
  span{
    color: white;
  }
  table,thead,tr,td{
    color: white;
  }
</style>
<section class="ticket">
  <div class="multisteps_form  position-relative overflow-hidden">
      {{-- <div class="header-sec">
          <div class="row">
              <div class="col-md-5 d-flex">
                  <div class="d-flex align-items-center ">
                      <script
                          src="https://unpkg.com/@lottiefiles/lottie-player@latest/dist/lottie-player.js"></script>
                      <lottie-player src="https://assets8.lottiefiles.com/packages/lf20_sdsq6yiq.json"
                          background="transparent" speed="1" style="width:100px; height: 70px;" loop
                          autoplay></lottie-player>
                      <h2 class="text-uppercase">christmas promotion lottery</h2>
                  </div>
              </div>
              <div class="col-md-4 d-flex align-items-center">
                  <div class="d-flex align-items-center pl-20">
                      <div><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                              class="bi bi-calendar-check" viewBox="0 0 16 16">
                              <path
                                  d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z" />
                              <path
                                  d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z" />
                          </svg></div>

                      <h4 class="pl-20">25<sup>th</sup> December 2022</h4>
                  </div>
              </div>
              <div class="col-md-3  d-flex align-items-center">
                  <div class="d-flex align-items-center pl-20">
                      <div><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                              class="bi bi-eye" viewBox="0 0 16 16">
                              <path
                                  d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z" />
                              <path
                                  d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z" />
                          </svg></div>

                      <h4 class="pl-20">Active</h4>
                  </div>
              </div>
              <div class="d-flex justify-content-end expiry">
                  <button>Expiry Date:<span style="padding-left:20px;">30<sup>th</sup> December 2022</span></button>
              </div>


          </div>
      </div> --}}

      <div class="card bg-gray mt-5 p-5">
        <div class="row">
          <div class="col">
            <div class="form-group">
              <span>Game Title:</span> <span>{{ $gameDetail->game_title }}</span>
            </div>
            <div class="form-group">
              <span>Game Description:</span> <span>{{ $gameDetail->game_description }}</span>
            </div>
            <div class="form-group">
              <span>Time Zone:</span> <span>{{ $gameDetail->game_time_zone }}</span>
            </div>
          </div>
          <div class="col">
            <div class="form-group">
              <span>Start Date and Time:</span> <span>{{ $gameDetail->game_start_date }} {{ date('g:i A', strtotime($gameDetail->game_start_time)) }}</span>
            </div>
            <div class="form-group">
              <span>End Date and Time:</span> <span>{{ $gameDetail->game_end_date }} {{ date('g:i A', strtotime($gameDetail->game_end_time)) }}</span>
            </div>
            <div class="form-group">
              <span>Draw Date and Time:</span> <span>{{ $gameDetail->game_draw_date }} {{ date('g:i A', strtotime($gameDetail->game_draw_time)) }}</span>
            </div>
            <div class="form-group">
              <span>Total Numbers allowed to Select:</span> <span>{{ $gameDetail->game_total_allowed_ticket }}</span>
            </div>
          </div>
          <div class="col">
            @if($gameDetail->featured_image)
            <img src="{{asset('game_images/'.$gameDetail->featured_image)}}" class="rounded d-block" alt="" style="height: auto;width: 100px;">
            @else
            <img src="{{asset('logo.png')}}" class="rounded d-block" alt="" style="height: auto;width: 100px;">
            @endif
          </div>
        </div>
      </div>
      

    <div class="card bg-gray mt-5 p-5">
      @if ($errors->any())
      <div class="alert alert-danger">
          <ul>
              @foreach ($errors->all() as $error)
                  <li>{{ $error }}</li>
              @endforeach
          </ul>
      </div>
      @endif
      @if($ticket == null)
      <form action="{{ route('user.store.ticket') }}" method="POST">
        <input type="hidden" name="game_id" value="{{$gameDetail->id}}">
        @csrf
        <div class="row">
          <table class="table table-bordered table-scroll mt-3" id="productTable">
            <thead>
              <tr>
                <th scope="col" class="text-center">SL NO</th>
                <th scope="col" class="text-center">Name</th>
                <th scope="col" class="text-center">Range</th>
                <th scope="col">
                  <button class="btn btn-info" id="addBtn" type="button"><i class="fa fa-plus"></i></button>
                </th>
              </tr>
            </thead>
            <tbody id="tbody">

            </tbody>
          </table>
        </div>
    <div class="form-group">
      <label for="" class="text-white">Enter the Amount($) <span class="text-danger">*</span></label>
      <input type="number" class="form-control" name="price" value="{{$gameDetail->game_min_range != '' ? $gameDetail->game_min_range : '0' }}" max="{{$gameDetail->game_max_range}}" min="{{$gameDetail->game_min_range}}" id="priceInput">
    </div>
        <div class="d-flex pt-5 justify-content-center">
          <button class="button-72 p-4" type="submit">Create Ticket</button>
        </div>
      </form>
      @else
        <h2 class="text-white">You have already created the ticket</h2>
      @endif
    </div>
    

      {{-- <div class="d-flex pt-5 justify-content-center">
          <a href="#"><button class="button-72 p-4" role="button">Create Ticket</button></a>
      </div> --}}

  </div>
</section>


<!--- JS WORK -->
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>

<script>

$(document).ready(function () {

  // jQuery code to validate the input field
$('#priceInput').on('change', function () {
  var price = $(this).val();
  var min = parseInt($(this).attr('min'));
  var max = parseInt($(this).attr('max'));

  if (price < min || price > max) {
    Swal.fire({
      icon: 'error',
      title: 'Invalid Amount',
      text: 'Please enter an amount between ' + min + ' and ' + max + '.',
    });
    $(this).val(min); // Reset the input to the minimum value
  }
});

  // jQuery button click event to add a row
  var rowIdx = '';
  var maxRows = {{$gameDetail->game_total_allowed_ticket}};
  $('#addBtn').on('click', function () {
    var selectOptions = '';
    for (var i = 0; i <= 99; i++) {
      selectOptions += `<option value="${i}">${i}</option>`;
    }

    // Adding a row inside the tbody
    $('#tbody').append(`
      <tr>
        <td class="row-index text-center">${rowIdx + 1}</td>
        <td>
          <input class="form-control winning_number" name="name[]" id="" value="No ${rowIdx + 1}" readonly>
        </td>
        <td>
          <select class="form-control" name="range[]">
            <option value="">Select Range</option>
            ${selectOptions}
          </select>
        </td>
        <td class="text-center">
          <button class="btn btn-danger remove" type="button">Remove</button>
        </td>
      </tr>
    `);

    rowIdx++;
    if ($('#tbody tr').length >= maxRows) {
      $('#addBtn').hide();
    }
  });

  // Check for duplicate numbers on select change event
  $('#tbody').on('change', 'select[name="range[]"]', function () {
    var selectedNumbers = [];
    $('select[name="range[]"]').each(function () {
      var number = $(this).val();
      if (number !== '' && selectedNumbers.includes(number)) {
        // Show SweetAlert message for duplicate number
        Swal.fire({
          icon: 'error',
          title: 'Duplicate Number',
          text: 'Please select a unique range.',
        });
        $(this).val(''); // Clear the duplicate selection
      } else {
        selectedNumbers.push(number);
      }
    });
  });

  // Remove row on button click
  $('#tbody').on('click', '.remove', function () {
    $(this).closest('tr').remove();
    $('#addBtn').show();
    updateRowIndexes();
  });

  // Update row indexes
  function updateRowIndexes() {
    $('#tbody .row-index').each(function (index) {
      $(this).text(index + 1);
    });
  }
});
</script>


@endsection