@extends('layouts.app')
@section('content')
<style>
  a {
    text-decoration: none;
  }

  span {
    color: white;
  }

  table,
  thead,
  tr,
  td {
    color: white;
  }

  section.ticket {
    display: flex;
    justify-content: center;
  }

  .multisteps_form {
    margin: 0rem 0rem;
    padding: 2rem 15px !important;
  }

  .card {
    background-image: linear-gradient(to right, #0f0c29, #302b63, #24243e);
    box-shadow: rgb(254 254 254 / 22%) 0px 5px 15px !important;
    border-radius: 10px;
    border: 1px solid #ffffff38;
  }

  .span-tittel {
    width: 105px;
    display: inline-block;
  }

  #checker-content {
    padding: 15px 20px 0px;
    text-align: center;
  }

  .line {
    position: relative;
    display: inline-block;
    padding: 20px 0 30px;
    border-bottom: 1px solid #ffffff38;
  }

  .numbers {
    align-items: center;
    display: flex;
  }

  .numbers ul {
    margin-bottom: 0px;
  }

  .numbers ul,
  .numbers li {
    position: relative;
    list-style-type: none;
    display: inline-block;
  }

  .numbers ul:first-child {
    margin-right: 30px;
  }

  .numbers input {
    border: none;
    border-radius: 8px;
    padding: 5px;
    font-size: 30px;
    font-weight: bold;
    text-align: center;
    width: 70px;
    height: 70px;
    margin: 0 2px;
  }

  .clean {
    position: relative;
    font-size: 30px;
    padding-left: 20px;
    cursor: pointer;
  }

  #checker-reset,
  .clean {
    display: inline-block;
  }

  #checker button {
    display: inline-block;
    -webkit-appearance: none;
    background: none;
    border: none;
    color: #0A8901;
    padding: 10px;
    font-size: 20px;
    margin-bottom: 20px;
    cursor: pointer;
    margin-left: auto;
    margin-right: auto;
  }

  .btn.clean.btn-danger {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 60px;
    height: 60px;
    padding: 0px;
    border-radius: 8px;
  }

  .main-label {
    margin-bottom: 5px;
  }

  .form-control {
    background: transparent;
    color: #fff;
    border: 1px solid #ffffff38;
  }

  .form-control:focus {
    background: transparent;
    color: #fff;
    border: 1px solid #ffffff;
    box-shadow: none;
  }

  .form-control::placeholder {
    color: #fff;
  }
  .checker-results {
    background: #0A8901;
    display: flex;
    width: 100%;
    align-items: center;
    box-shadow: rgba(0,0,0,0.1) 0 3px 5px;
    text-align: center;
    margin-bottom: 0px
}
.checker-results .title {
    position: relative;
    color: #FFF;
    padding: 10px 30px;
    font-weight: 700;
    font-size: 18px;
    line-height: 20px;
    text-align: center;
    letter-spacing: 0;
}
.checker-results .title:after {
    content: "";
    background: #0A8901;
    position: absolute;
    width: 24px;
    height: 24px;
    top: calc(36%);
    right: -12px;
    transform: rotate(-45deg);
}
.checker-results .chosen-numbers {
    background: #F4F4F4;
    padding: 20px 25px;
    flex: 1;
    text-align: center;
}
.checker-results .chosen-numbers .padded {
    padding: 5px;
}
.ball {
    background: #0a8901;
    border: 6px solid #0a8901;
    color: #fff;
    width: 60px;
    height: 60px;
    display: inline-block;
    border-radius: 50%;
    text-align: center;
    font: 24px/48px Montserrat,sans-serif;
    font-weight: 700;
}
.ball.joker {
    border: 6px solid #0a8901;
    background: none;
    color: #0a8901;
}
</style>
<section class="ticket">
  <div class="multisteps_form  position-relative overflow-hidden">
    <div class="card bg-gray mt-5 p-5">
      <div class="row justify-content-between align-items-center">
        <div class="col-md-8">
            <div class="row">
              <div class="col-md-6 mb-3">
                <div class="form-group">
                  {{-- <span class="span-tittel">Title:</span>  --}}
                  <span>{{ @$gameDetail->game_title  }}</span>
                </div>
              </div>
              <div class="col-md-6 mb-3">
                <div class="form-group">
                  {{-- <span class="span-tittel">Time:</span>  --}}
                  <span>{{ @$gameDetail->game_description }}</span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  {{-- <span class="span-tittel">Draw Date:</span>  --}}
                  <span class="text-success">{{ @$gameDetail->game_end_date }} {{ date('h:i A', strtotime($gameDetail->game_end_time)) }}</span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <span class="text-danger">{{ @$gameDetail->game_draw_date }} {{ date('h:i A', strtotime($gameDetail->game_draw_date)) }}</span>
                  {{-- <span class="span-tittel">Ticket Price:</span> <span>$ {{ $gameDetail->game_ticket_prize }}</span> --}}
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <span class="text-white">$ 0</span>
                  {{-- <span class="span-tittel">Ticket Price:</span> <span>$ {{ $gameDetail->game_ticket_prize }}</span> --}}
                </div>
              </div>
            </div>
          </div>
        <div class="col-md-2">
          @if(@ $gameDetail->featured_image)
          <img src="{{asset('game_images/'.@$gameDetail->featured_image)}}" class="rounded d-block img-fluid" alt=""
            style="height: auto;width: 100px;float: right;width:100% !important;">
          @else
          <img src="{{asset('logo.png')}}" class="rounded d-block img-fluid" alt=""
            style="height: auto;width: 100px;float: right;width:100% !important;">
          @endif
        </div>
      </div>
    </div>
  <div class="card bg-gray mt-5 p-5">
    <div class="row">
   
      @for ($i = 0; $i < count($ticket_sequences_new); $i += 6)
      <div class="col-md-12 mb-4">
          <div class="checker-results">
              <div>
                  <div class="title">Checking <br>Numbers</div>
              </div>
              <div class="chosen-numbers d-flex align-items-center justify-content-between">
                  <div class="qr-code">
                      <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100" height="100" viewBox="0 0 150 150">
                          <!-- QR code SVG content -->
                          {!! QrCode::size(150)->generate('Ticket Code: ' . $ticket_sequences_new[$i]->ticket_id) !!}
                      </svg>
                  </div>
                  <div class="padded">
                      @for ($j = $i; $j < min($i + 6, count($ticket_sequences_new)); $j++)
                          <span class="result ball">{{ $ticket_sequences_new[$j]->winning_sequence }}</span>
                      @endfor
                  </div>
                  <div class="d-flex h-100 align-items-center">
                      {{-- <div class="card-body text-center" style="width: 60px; height: 44.5px; background-color: red; margin-right: 15px; color: #fff; padding: 10px;">
                          <span>Loss</span>
                      </div>
                      <div class="card-body text-center" style="width: 60px; height: 44.5px; background-color: #0a8901; color: #fff; padding: 10px;">
                          <span>Won</span>
                      </div> --}}
                  </div>
              </div>
          </div>
      </div>
      @endfor
  
    </div>
  </div>
</section>

@endsection
