<?php
use Carbon\Carbon;

// First of all, find the games with the draw date today
$today = Carbon::now()->format('Y-m-d'); // Get today's date in the 'Y-m-d' format

$games = App\Models\GameDetail::where('game_status', 1)
    ->whereDate('game_draw_date', $today)
    ->select('game_code', 'game_ticket_prize', 'game_title', 'id')
    ->get()
    ->toArray();

foreach ($games as $game) {
    $total_tickets = App\Models\Ticket::where('game_id', $game['id'])->where('status', 1)
        ->select('ticket_code', 'price', 'id')
        ->get()
        ->toArray();

    foreach ($total_tickets as $ticket) {
        $ticket_sequences = App\Models\TicketSequence::where('ticket_id', $ticket['id'])
            ->select('winning_name', 'winning_sequence', 'id')
            ->get()
            ->toArray();

        $totalPrize = 0; // Variable to store the total prize for the ticket

        foreach ($ticket_sequences as $sequence) {
            $matchingNumbers = []; // Array to store matching numbers
            $digits = explode(',', $sequence['winning_sequence']);

            foreach ($digits as $digit) {
                $matchingNumber = App\Models\WinningNumber::where('number', $digit)->first();

                if ($matchingNumber) {
                    // Matching number found
                    $matchingNumbers[] = $digit;
                }
            }

            if (!empty($matchingNumbers)) {
                // Matching numbers found
                foreach ($matchingNumbers as $matchingNumber) {
                    // Fetch the number from the winning numbers table and multiply it by the ticket price
                    $number = App\Models\WinningNumber::where('number', $matchingNumber)->value('sequence');
                    $prize = $number * $ticket['price'];
                    $totalPrize += $prize;
                }

                echo "Number ".$number;
                // Update the status field of the ticket sequence to 2
                App\Models\TicketSequence::where('id', $sequence['id'])->update(['status' => 2]);
            } else {
                // No matching numbers found
                // Update the status field of the ticket sequence to 3
                echo "no matching";

                App\Models\TicketSequence::where('id', $sequence['id'])->update(['status' => 3]);
            }
        }

        // Add the total prize to the ticket record
        App\Models\Ticket::where('id', $ticket['id'])->update(['win_amount' => $totalPrize]);
    }
}

echo "Ticket Result Done";



// dd($games);
// Assuming you have the winning numbers stored in an array
// $winningNumbers = [1, 5, 9, 15, 20, 25, 30, 35, 40, 45];

// Retrieve the tickets that belong to a specific game
// $gameId = 19; // Replace with the actual game ID
// $tickets = App\Models\Ticket::where('game_id', $gameId)->get();

// @dd($tickets);
// Initialize an array to store the number of matching tickets for each ticket
// $matchingTickets = [];

// Loop through each ticket
// foreach ($tickets as $ticket) {
    // $matchingCount = 0; // Initialize the matching count for each ticket

    // Retrieve the ticket sequences associated with the ticket
    // $ticketSequences = App\Models\TicketSequence::where('ticket_id', $ticket->id)->get();

    // Loop through each ticket sequence
    // foreach ($ticketSequences as $ticketSequence) {
        // Check if the winning number matches any of the ticket's sequences
        // if (in_array($ticketSequence->winning_sequence, $winningNumbers)) {
            // $matchingCount++; // Increment the matching count
        // }
    // }

    // Store the matching count for the ticket
    // $matchingTickets[$ticket->id] = $matchingCount;

    // echo "Ticket ID: $ticket->id\n";
    // echo "Matching Numbers: $matchingCount\n";
    // echo "Ticket Code: $ticket->ticket_code\n";
    // echo "User ID: $ticket->user_id\n";
    // echo "------------------------\n";
// }


// Now you have an array ($matchingTickets) that contains the number of matching sequences for each ticket
// You can use this information to display the matching details as needed
?>