<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


// Auth::routes();
Route::get('/message', function () {
    return view('success_message');
});

// Route::get('/result', function () {
//     return view('result');
// });


// Admin Routes
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::post('/filter-games', [App\Http\Controllers\HomeController::class, 'filterGames'])->name('filter-games');
Route::get('/verify/{token}', [App\Http\Controllers\VerifyController::class,'VerifyEmail'])->name('verify');
Route::get('/', [App\Http\Controllers\HomeController::class, 'front'])->name('/');
// Route::get('/admin/profile', [App\Http\Controllers\Admin\DashboardController::class, 'profile'])->name('admin.profile');
// Route::post('/admin/update', [App\Http\Controllers\Admin\DashboardController::class, 'updateProfile'])->name('admin.profile.update');
// End Admin Routes

// Admin Routes
Route::prefix('admin')->name('admin.')->group(function () {
    // Authentication Routes
    Route::get('dashboard', [App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');
    Route::get('/', [App\Http\Controllers\Auth\LoginController::class, 'showAdminLoginForm'])->name('login-view');
    Route::post('/', [App\Http\Controllers\Auth\LoginController::class, 'adminLogin'])->name('login');
    // Route::get('/register', [App\Http\Controllers\Auth\RegisterController::class, 'showAdminRegisterForm'])->name('register-view');
    // Route::post('/register', [App\Http\Controllers\Auth\RegisterController::class, 'createAdmin'])->name('register');

    // Admin Dashboard
    Route::get('profile', [App\Http\Controllers\Admin\DashboardController::class, 'profile'])->name('profile');
    Route::post('update', [App\Http\Controllers\Admin\DashboardController::class, 'updateProfile'])->name('profile.update');


    // Advertisement Routes
    Route::resource('advertisements', App\Http\Controllers\Admin\AdvertisementController::class);
    Route::get('advertisements/data/fetch', [App\Http\Controllers\Admin\AdvertisementController::class, 'getAdData'])->name('advertisements.fetchdata');
    Route::post('advertisements/image/upload', [App\Http\Controllers\Admin\AdvertisementController::class, 'AdImageUpload'])->name('advertisement-image-upload');
    Route::delete('advertisements/image/delete', [App\Http\Controllers\Admin\AdvertisementController::class, 'AdImageDelete'])->name('advertisement-image-delete');
    Route::post('ad-position-check', [App\Http\Controllers\Admin\AdvertisementController::class, 'AdPositionCheck'])->name('ad-position-check')->withoutMiddleware('auth:admin');
    
    // CMS Pages
    Route::get('cms/pages', [App\Http\Controllers\Admin\CMSController::class, 'index'])->name('pages.create');
    Route::post('cms/page/store', [App\Http\Controllers\Admin\CMSController::class, 'store'])->name('pages.store');
    Route::put('cms/page/update', [App\Http\Controllers\Admin\CMSController::class, 'store'])->name('pages.update');

    // Contact Routes
    Route::get('enquiry-list', [App\Http\Controllers\Admin\ContactController::class, 'index'])->name('enquiry-list');
    Route::get('enquiry/data', [App\Http\Controllers\Admin\ContactController::class, 'getData'])->name('enquiry.data');
    Route::get('contact-info', [App\Http\Controllers\Admin\ContactController::class, 'contact_widget'])->name('contact.widget');
    Route::post('contact-info', [App\Http\Controllers\Admin\ContactController::class, 'storeWidget'])->name('contact-widget.store');
    Route::put('contact-info/{id}', [App\Http\Controllers\Admin\ContactController::class, 'updateWidget'])->name('contact-widget.update');
    Route::get('/contacts/{id}', [App\Http\Controllers\Admin\ContactController::class, 'show'])->name('contacts.show');
    Route::delete('/contacts/{id}', [App\Http\Controllers\Admin\ContactController::class, 'destroy'])->name('contacts.destroy');
    
    // User listing
    Route::get('users-list', [App\Http\Controllers\Admin\UserController::class, 'index'])->name('users-list');
    Route::get('users-list/getUsersList', [App\Http\Controllers\Admin\UserController::class, 'getUsersList'])->name('get-users-list');

    // Game management
    Route::resource('game-details', App\Http\Controllers\Admin\GameDetailController::class);
    Route::post('agame-details/{id}', [App\Http\Controllers\Admin\GameDetailController::class, 'deleteMethod'])->name('game-details.destroy');
    Route::get('game-fetch-data', [App\Http\Controllers\Admin\GameDetailController::class,'fetchdata'])->name('games.fetchdata');


    // Winning Management
    Route::get('winning-list/{id}', [App\Http\Controllers\Admin\WinningController::class,'list'])->name('winning.list');
    Route::post('winning-numbers', [App\Http\Controllers\Admin\WinningController::class,'store'])->name('winning-numbers.store');
    Route::get('winning-numbers/edit/{id}', [App\Http\Controllers\Admin\WinningController::class,'edit'])->name('winning-numbers.edit');
    Route::post('winning-numbers/delete-record', [App\Http\Controllers\Admin\WinningController::class,'deleteRecord'])->name('winning-numbers.delete');

    // Route for displaying the category listing
    Route::get('/categories', [App\Http\Controllers\Admin\CategoryController::class, 'index'])->name('categories.index');
    // Route for storing a new category
    Route::post('/categories', [App\Http\Controllers\Admin\CategoryController::class, 'store'])->name('categories.store');
    Route::delete('categories/{category}', [App\Http\Controllers\Admin\CategoryController::class, 'destroy'])->name('categories.destroy');


    // Route::get('ticket-list/', [App\Http\Controllers\Admin\TicketManagementController::class, 'index'])->name('manage.ticket-list');Route::get('ticket-list/{gameId}', [App\Http\Controllers\Admin\TicketManagementController::class, 'index'])->name('manage.ticket-list');
    Route::get('ticket-list/{gameId}', [App\Http\Controllers\Admin\TicketManagementController::class, 'index'])->name('manage.ticket-list');
    Route::get('ticket-list/show-ticket/{id}', [App\Http\Controllers\Admin\TicketManagementController::class, 'show_ticket'])->name('show.ticket');
    Route::get('ticket-list/fetchdata', [App\Http\Controllers\Admin\TicketManagementController::class, 'fetchData'])->name('fetch.ticket-list');

    // Result Publishing
    Route::get('result-list/{id}', [App\Http\Controllers\Admin\ResultPublishController::class, 'index'])->name('result.list');
    Route::get('result-list/create/{id}', [App\Http\Controllers\Admin\ResultPublishController::class, 'create'])->name('result.create');
    Route::post('result-list/store', [App\Http\Controllers\Admin\ResultPublishController::class, 'store'])->name('result.store');


    // Wallet
    Route::get('wallet-add-page/{id}', [App\Http\Controllers\Admin\WalletController::class, 'create'])->name('wallet.create');
    Route::post('wallet-add-amount', [App\Http\Controllers\Admin\WalletController::class, 'store'])->name('wallet.store');

});


Auth::routes(['verify' => true]);

// Front End Routes
Route::prefix('user')->name('user.')->middleware('auth')->group(function ()  {
    Route::post('file-upload', [App\Http\Controllers\Front\UserController::class, 'dropzoneFileUpload' ])->name('dropzoneFileUpload') ->withoutMiddleware('auth');;
    // Other user routes
    Route::get('/login', [App\Http\Controllers\Auth\LoginController::class, 'showLoginForm'])->name('login');
    Route::get('/my-account', [App\Http\Controllers\Front\UserController::class, 'index'])->name('my-account');
    Route::post('/my-account/update', [App\Http\Controllers\Front\UserController::class, 'update'])->name('my-account.update');
    
    Route::get('contact-us/create', [App\Http\Controllers\User\ContactController::class, 'create'])
    ->name('contact-us.create')
    ->withoutMiddleware('auth');

    Route::post('contact-us', [App\Http\Controllers\User\ContactController::class, 'store'])
        ->name('contact-us.store')
        ->withoutMiddleware('auth');
    Route::get('cms-pages', [App\Http\Controllers\User\ContactController::class,'CMSPages'])->name('cms.pages')->withoutMiddleware('auth');

    // Ticket Management
    Route::get('create-ticket/{id}', [App\Http\Controllers\Front\TicketController::class,'create'])->name('create.ticket');
    Route::get('show-ticket/{id}', [App\Http\Controllers\Front\TicketController::class, 'show_ticket'])->name('show.ticket');
    Route::get('view-ticket', [App\Http\Controllers\Front\TicketController::class, 'view_ticket'])->name('view.ticket');
    Route::post('store-ticket', [App\Http\Controllers\Front\TicketController::class,'store'])->name('store.ticket');
    Route::get('print-ticket-invoice/{id}', [App\Http\Controllers\Front\TicketController::class,'generateInvoicePDF'])->name('print.ticket');
    Route::get('result', [App\Http\Controllers\Front\TicketController::class,'result'])->name('ticket.result')->withoutMiddleware('auth');


    // Route::get('/dashboard', [App\Http\Controllers\User\DashboardController::class, 'index'])->name('dashboard');
    // Route::get('/profile', [App\Http\Controllers\User\ProfileController::class, 'index'])->name('profile');
    // ...
    

});



// // Front End Routes
// Route::resource('contact-us', App\Http\Controllers\ContactController::class);
// Route::get('cms-pages', [App\Http\Controllers\ContactController::class,'CMSPages'])->name('cms.pages');

// // End Front Routes


// Route::get('/admin',[App\Http\Controllers\Auth\LoginController::class,'showAdminLoginForm'])->name('admin.login-view');
// Route::post('/admin',[App\Http\Controllers\Auth\LoginController::class,'adminLogin'])->name('admin.login');

// Route::get('/admin/register',[App\Http\Controllers\Auth\RegisterController::class,'showAdminRegisterForm'])->name('admin.register-view');
// Route::post('/admin/register',[App\Http\Controllers\Auth\RegisterController::class,'createAdmin'])->name('admin.register');

// Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
// Route::get('/admin/dashboard',function(){
//     return view('admin.dashboard');
// })->middleware('auth:admin');

