<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        /* Custom Styles */
        .invoice-container {
            box-shadow: 0 0 1in -0.25in rgba(0, 0, 0, 0.5);
            padding: 2mm;
            margin: 0 auto;
            width: 44mm;
            background: #FFF;
        }

        .invoice-container h1 {
            font-size: 1.5em;
            color: #222;
        }

        .invoice-container h2 {
            font-size: .9em;
        }

        .invoice-container h3 {
            font-size: 1.2em;
            font-weight: 300;
            line-height: 2em;
        }

        .invoice-container p {
            font-size: .7em;
            color: #666;
            line-height: 1.2em;
        }

        .invoice-container #top,
        .invoice-container #mid,
        .invoice-container #bot {
            border-bottom: 1px solid #EEE;
        }

        .invoice-container #top {
            min-height: 100px;
        }

        .invoice-container #mid {
            min-height: 80px;
        }

        .invoice-container #bot {
            min-height: 50px;
        }

        .invoice-container #top .logo,
        .invoice-container .client-logo {
            height: 60px;
            width: 60px;
            background-size: cover;
            border-radius: 50%;
        }

        .invoice-container .info {
            display: block;
            margin-left: 0;
        }

        .invoice-container .title {
            text-align: right;
        }

        .invoice-container table {
            width: 100%;
            border-collapse: collapse;
        }

        .invoice-container td {
            padding: 5px 0 5px 15px;
            border: 1px solid #EEE;
        }

        .invoice-container .table-title {
            padding: 5px;
            font-size: .5em;
            background: #EEE;
        }

        .invoice-container .service {
            border-bottom: 1px solid #EEE;
        }

        .invoice-container .item {
            width: 24mm;
        }

        .invoice-container .item-text {
            font-size: .5em;
        }

        .invoice-container #legalcopy {
            margin-top: 5mm;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-sm-6">
                <div class="card bg-light mt-5 p-5">
                    <div id="invoice-POS" class="invoice-container">
                        <div id="top">
                            <div class="text-center">
                                <img src="<?php echo e(asset('logo.png')); ?>" class="logo" alt="Logo">
                                <h2>Lotto</h2>
                            </div>
                        </div>

                        <div id="mid">
                            <div class="info">
                                <p>
                                    Company Name: Lotto<br>
                                    Email: lotto@gmail.com<br>
                                    Phone: 555-555-5555
                                </p>
                            </div>
                        </div>

                        <div id="bot">
                            <div id="table" class="mt-3">
                                <table class="table">
                                    <tr class="table-title">
                                        <td>Ticket Number</td>
                                        <td class="Rate"><h2></h2></td>
                                        <?php $__currentLoopData = $ticketSequences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sequence): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <td class="payment"><h2><?php echo e($sequence->winning_sequence); ?></h2></td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                </table>
                            </div>

                            <div id="table">
                                <table class="table">
                                    <tr class="table-title">
                                        <td></td>
                                        <td class="Rate"><h2>Price</h2></td>
                                        <td class="payment"><h2>$ <?php echo e($ticketData->price); ?></h2></td>
                                    </tr>
                                </table>
                            </div>

                            <div id="legalcopy">
                                <p class="legal"><strong>Thank you for your business!</strong></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>

</html>
<?php /**PATH D:\laragon\www\Lotto\resources\views/front/ticket/invoice_ticket.blade.php ENDPATH**/ ?>