

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="card">
        <div class="card-body">
        <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>
        <div class="d-flex justify-content-between align-items-center">
            <h1>Game Listing</h1>
            <a href="<?php echo e(route('admin.game-details.create')); ?>" class="btn btn-primary">Add New Game</a>
        </div>
       
        <div style="margin: 20px 0px;">
            <div style="display: flex; align-items: center;">
              <strong style="margin-right: 10px;">Filter By Draw Date:</strong>
              <input type="date" name="daterange" value="" class="form-control" style="flex: 0 0 150px; max-width: 150px;" />
              <strong style="margin-left: 10px; margin-right: 10px;">Filter By Status:</strong>
              <select name="status-filter" id="status-filter" class="form-control" style="flex: 0 0 120px; max-width: 120px;">
                <option value="">All</option>
                <option value="0">Inactive</option>
                <option value="1">Active</option>
                <option value="2">Closed</option>
              </select>
            </div>
          </div>
          
          
        <table class="table table-striped data-table" id="games-table">
            <thead>
                <tr>
                    <th>SL NO</th>
                    <th>Title</th>                    
                    <th>Draw Date</th>                    
                    <th>End Date</th>                    
                    <th>Status</th>                    
                    <th width="305px">Actions</th>
                </tr>
            </thead>
            <tbody>

            </tbody>
        </table>
    </div>
</div>
</div>
<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {  
    var table = $('#games-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo route('admin.games.fetchdata'); ?>",
          columns: [
              {data: 'DT_RowIndex', name: 'DT_RowIndex'},
              {data: 'game_title', name: 'game_title'},
              {data: 'game_draw_date', name: 'game_draw_date'},
              {data: 'game_end_date', name: 'game_end_date'},
              {
                data: 'game_status',
                name: 'game_status',
                render: function(data) {
                    if (data == 0) {
                        return '<button type="button" class="btn btn-danger btn-sm">Inactive</button>';
                    } else if (data == 1) {
                        return '<button type="button" class="btn btn-success btn-sm">Active</button>';
                    } else if (data == 2) {
                        return '<button type="button" class="btn btn-warning btn-sm">Closed</button>';
                    } else {
                        return '<button type="button" class="btn btn-default btn-sm">Default</button>';
                    }
                }
            },
            {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
          initComplete: function () {
            var column = this.api().column(2); // 2 represents the index of the draw date column
            
            $('input[name="daterange"]').on('change', function () {
                var selectedDate = $(this).val();
                if (selectedDate !== '') {
                    column.search(selectedDate).draw();
                } else {
                    column.search('').draw();
                }
            });

            $('#status-filter').on('change', function() {
                var selectedStatus = $(this).val();
                table.column(4).search(selectedStatus).draw();
                });
            }
      });
});

</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\bioessenza\resources\views/admin/game_details/index.blade.php ENDPATH**/ ?>