

<?php $__env->startSection('content'); ?>
<div class="container">
  <div class="card">
    <div class="card-header text-center">
      <a class="btn btn-primary float-start" href="<?php echo e(route('admin.game-details.index')); ?>"><i class="fas fa-arrow-left"></i> Back To Listing</a>
      ADD NEW GAME
    </div>
    <div class="card-body">
      
      <form action="<?php echo e(route('admin.game-details.store')); ?>" method="POST">
        <div class="form-group">
          <button type="submit" class="btn btn-primary float-end">Save Game</button> 
        </div>
        <?php echo csrf_field(); ?>
        <div class="form-group">
          <label for="gameCode">Game Code</label>
          <input type="text" class="form-control" id="gameCode" name="game_code" value="<?php echo e($gameCode); ?>" readonly>
          <?php if($errors->has('game_code')): ?><span class="text-danger"><?php echo e($errors->first('game_code')); ?></span><?php endif; ?>
      </div>
        <div class="form-group">
          <label for="gameTitle">Game Title</label>
          <input type="text" class="form-control" id="gameTitle" name="game_title" placeholder="Enter game title">
          <?php if($errors->has('game_title')): ?><span class="text-danger"><?php echo e($errors->first('game_title')); ?></span><?php endif; ?>
        </div>
        <div class="form-group">
          <label for="gameDescription">Description</label>
          <textarea class="form-control" id="gameDescription" name="game_description" placeholder="Enter game description"></textarea>
          <?php if($errors->has('game_description')): ?><span class="text-danger"><?php echo e($errors->first('game_description')); ?></span><?php endif; ?>
        </div>
        <div class="form-row">
          <div class="form-group col-md-6">
            <label for="gameStartDate">Start Date</label>
            <input type="date" class="form-control" id="gameStartDate" name="game_start_date" min="<?php echo e(date('Y-m-d')); ?>">
            <?php if($errors->has('game_start_date')): ?><span class="text-danger"><?php echo e($errors->first('game_start_date')); ?></span><?php endif; ?>
          </div>
          <div class="form-group col-md-6">
            <label for="gameEndDate">End Date</label>
            <input type="date" class="form-control" id="gameEndDate" name="game_end_date" min="<?php echo e(date('Y-m-d')); ?>" onchange="setMinEndDate()">
            <?php if($errors->has('game_end_date')): ?><span class="text-danger"><?php echo e($errors->first('game_end_date')); ?></span><?php endif; ?>
          </div>
        </div>
        <div class="form-row">
          <div class="form-group col-md-6">
            <label for="gameStartTime">Start Time</label>
            <input type="time" class="form-control" id="gameStartTime" name="game_start_time" min="<?php echo e(date('H:i')); ?>">
            <?php if($errors->has('game_start_time')): ?><span class="text-danger"><?php echo e($errors->first('game_start_time')); ?></span><?php endif; ?>
          </div>
          <div class="form-group col-md-6">
            <label for="gameEndTime">End Time</label>
            <input type="time" class="form-control" id="gameEndTime" name="game_end_time" min="<?php echo e(date('H:i')); ?>" onchange="setMinEndTime()">
            <?php if($errors->has('game_end_time')): ?><span class="text-danger"><?php echo e($errors->first('game_end_time')); ?></span><?php endif; ?>
          </div>
        </div>
        
        <div class="form-row">
          <div class="form-group col-md-6">
            <label for="gameDrawDate">Draw Date</label>
            <input type="date" class="form-control" id="gameDrawDate" name="game_draw_date" min="<?php echo e(date('Y-m-d')); ?>">
            <?php if($errors->has('game_draw_date')): ?><span class="text-danger"><?php echo e($errors->first('game_draw_date')); ?></span><?php endif; ?>
          </div>
          <div class="form-group col-md-6">
            <label for="gameDrawTime">Draw Time</label>
            <input type="time" class="form-control" id="gameDrawTime" name="game_draw_time">
            <?php if($errors->has('game_draw_time')): ?><span class="text-danger"><?php echo e($errors->first('game_draw_time')); ?></span><?php endif; ?>
          </div>
        </div>
        <div class="form-group">
          <label for="gameTimeZone">Time Zone</label>
          <select class="form-control" id="gameTimeZone" name="game_time_zone">
            <option value="">Select Time Zone</option>
            <option value="ist">IST</option>
            <option value="gmt">GMT</option>
            <option value="uae">UAE</option>
          </select>
          <?php if($errors->has('game_time_zone')): ?><span class="text-danger"><?php echo e($errors->first('game_time_zone')); ?></span><?php endif; ?>
        </div>
        <div class="form-group">
          <label for="gameTotalAllowedTicket">Total No's Allowed in a Ticket</label>
          <input type="number" class="form-control" id="gameTotalAllowedTicket" name="game_total_allowed_ticket" placeholder="Enter total allowed tickets">
          <?php if($errors->has('game_total_allowed_ticket')): ?><span class="text-danger"><?php echo e($errors->first('game_total_allowed_ticket')); ?></span><?php endif; ?>
        </div>
        <div class="form-group">
          <label for="gameTicketPrize">Prize of the Ticket(in $)</label>
          <input type="number" class="form-control" id="gameTicketPrize" name="game_ticket_prize" placeholder="Enter ticket prize">
          <?php if($errors->has('game_ticket_prize')): ?><span class="text-danger"><?php echo e($errors->first('game_ticket_prize')); ?></span><?php endif; ?>
        </div>
        <div class="form-row">
          <div class="form-group col-md-6">
            <label for="gameMinRange">Min Range</label>
            <input type="number" class="form-control" id="gameMinRange" name="game_min_range" placeholder="Enter min range start from 1" min="1">
            <?php if($errors->has('game_min_range')): ?><span class="text-danger"><?php echo e($errors->first('game_min_range')); ?></span><?php endif; ?>
          </div>
          <div class="form-group col-md-6">
            <label for="gameMaxRange">Max Range</label>
            <input type="number" class="form-control" id="gameMaxRange" name="game_max_range" placeholder="Enter max range till 99" max="99">
            <?php if($errors->has('game_max_range')): ?><span class="text-danger"><?php echo e($errors->first('game_max_range')); ?></span><?php endif; ?>
          </div>
        </div>
        <div class="form-group">
          <label for="gameStatus">Game Status</label>
          <select class="form-control" id="gameStatus" name="game_status">
            <option value="">Select Status</option>
            <option value="1">Active</option>
            <option value="0">Inactive</option>
            <option value="2">Closed</option>
          </select>
          <?php if($errors->has('game_status')): ?><span class="text-danger"><?php echo e($errors->first('game_status')); ?></span><?php endif; ?>
        </div>
      </form>
    </div>
  </div>
</div>
<script>
  function setMinEndDate() {
  const startDateInput = document.getElementById('gameStartDate');
  const endDateInput = document.getElementById('gameEndDate');
  const drawDateInput = document.getElementById('gameDrawDate');

  drawDateInput.min = startDateInput.value;
  drawDateInput.max = endDateInput.value;

  if (drawDateInput.value < startDateInput.value) {
    drawDateInput.value = startDateInput.value;
  } else if (drawDateInput.value > endDateInput.value) {
    drawDateInput.value = endDateInput.value;
  }
}

// Attach the setMinEndDate function to the change event of the start and end date inputs
const startDateInput = document.getElementById('gameStartDate');
const endDateInput = document.getElementById('gameEndDate');

startDateInput.addEventListener('change', setMinEndDate);
endDateInput.addEventListener('change', setMinEndDate);

  function setMinEndTime() {
    const startTimeInput = document.getElementById('gameStartTime');
    const endTimeInput = document.getElementById('gameEndTime');

    endTimeInput.min = startTimeInput.value;
    if (endTimeInput.value < startTimeInput.value) {
      endTimeInput.value = startTimeInput.value;
    }
  }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\bioessenza\resources\views/admin/game_details/create.blade.php ENDPATH**/ ?>