

<?php $__env->startSection('content'); ?>
<style>
    #image-preview-circle {
    position: relative;
    width: 200px;
    height: 200px;
    border-radius: 50%;
    overflow: hidden;
}

#image-preview-circle img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

#remove-image {
    position: absolute;
    top: 5px;
    right: 5px;
    font-size: 18px;
    cursor: pointer;
}

</style>
<div class="col-lg-12">
    <?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
    <div class="card">
        <div class="card-header">Profile</div>
        <div class="card-body">
            <h5 class="card-title"></h5>
            <form class="" method="POST" action="<?php echo e(route('admin.profile.update')); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

                <div class="form-group">
                    <label for="image">Profile Picture:<span class="text-danger">*</span></label>
                    <div id="image-preview-container">
                        <?php if($admin_detail->image): ?>
                            <div id="image-preview-circle">
                                <img id="image-preview" src="<?php echo e(asset($admin_detail->image)); ?>" alt="Image Preview">
                                <span id="remove-image">❌</span>
                            </div>
                        <?php else: ?>
                            <div id="image-preview-circle">
                                <img id="image-preview" src="#" alt="Image Preview" style="display: none;">
                                <span id="remove-image" style="display: none;">❌</span>
                            </div>
                        <?php endif; ?>
                    </div>
                    <input type="file" class="form-control" id="image" name="image">
                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            
                <div class="mb-3 row">
                    <label class="col-sm-2">Name</label>
                    <div class="col-sm-10">
                        <input type="text" name="name" value="<?php echo e(@$admin_detail->name); ?>" class="form-control">
                    </div>
                </div>
                <div class="line"></div><br>
                <div class="mb-3 row">
                    <label class="col-sm-2">Email</label>
                    <div class="col-sm-10">
                        <input type="email" name="email" value="<?php echo e(@$admin_detail->email); ?>" class="form-control">
                    </div>
                </div>
                <div class="line"></div><br>
                <div class="mb-3 row">
                    <label class="col-sm-2">Password</label>
                    <div class="col-sm-10">
                        <input type="password" name="password" value="" class="form-control">
                        <input type="hidden" name="old_password" value="<?php echo e(@$admin_detail->password); ?>">
                    </div>
                </div>
                <div class="line"></div><br>
                <div class="mb-3 row">
                    <label class="col-sm-2">Confirm Password</label>
                    <div class="col-sm-10">
                        <input type="password" name="confirm_password" value="" class="form-control">
                    </div>
                </div>

                <div class="line"></div><br>
                <div class="mb-3 row">
                    <div class="col-sm-4 offset-sm-2">
                        <button type="submit" class="btn btn-secondary mb-2"><i class="fas fa-times"></i>
                            Cancel</button>
                        <button type="submit" class="btn btn-primary mb-2"><i class="fas fa-save"></i> Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    $('#image').on('change', function(event) {
        var input = event.target;
        var reader = new FileReader();
        var previewContainer = $('#image-preview-container');
        var preview = $('#image-preview');
        var removeImageBtn = $('#remove-image');

        reader.onload = function() {
            preview.attr('src', reader.result);
            preview.show();
            removeImageBtn.show();
        };

        if (input.files && input.files[0]) {
            reader.readAsDataURL(input.files[0]);
        }
    });

    $('#remove-image').on('click', function() {
        var input = $('#image');
        var previewContainer = $('#image-preview-container');
        var preview = $('#image-preview');
        var removeImageBtn = $('#remove-image');

        input.val('');
        preview.attr('src', '#');
        preview.hide();
        removeImageBtn.hide();
    });
});

</script>

<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\bioessenza\resources\views/admin/profile.blade.php ENDPATH**/ ?>