

<?php $__env->startSection('content'); ?>
<div class="container">
    <style>
        .tb-col{
            padding: 10px
        }
        .tb-col span{
            font-weight: 600;
            padding: 0px 10px;
        }
        .form-control , textarea.form-control{
            min-height: 42px;
            line-height: 42px;
            padding: 0px 12px;
            height: 42px;
            border-radius: 5px;
            background: #fff;
            border-color: #e4e6fc;
            font-size: 16px;
            color: #666;
        }
        .form-control:focus , textarea.form-control:focus{
            border-color: #302B63;
            box-shadow: unset;
        }
        textarea.form-control{
            height: unset;
        }
        label {
            color: #666;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 5px
        }
        .btn-main{
            border-color: #302B63;
            background: #302B63 !important;
            color: #fff;
            padding: 0.55rem 1.5rem;
            font-size: 14px;
            font-weight: 500;
            line-height: 24px;
            letter-spacing: .5px;
            border-radius: 5px;
        }
        .btn-main:hover{
            background: #fff !important;
            color: #302B63;
        }
        span.btn.btn-info.game_code_span.float-end{
            color: #666;
            padding: 0.55rem 1.5rem;
            font-size: 14px;
            font-weight: 500;
            letter-spacing: .5px;
            border-radius: 5px;
        }
        .range-btn{
            display: flex;
        }
        .range-btn button{
            margin-left: 10px
        }
        .card{
            border: none;
            box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);
        }
    </style>
  <div class="card mt-4">
    <div class="card-header d-flex w-100 justify-content-between align-items-center">
        <h4 class="mb-0">ADD NEW GAME</h4>
      <a class="btn btn-primary btn-main float-end" href="<?php echo e(route('admin.game-details.index')); ?>"><i class="fas fa-arrow-left"></i> Back To Listing</a>
      
    </div>
    <div class="card-body">
      <form action="<?php echo e(route('admin.game-details.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        
        <div class="row">
            <div class="col-md-12 mb-3">
                <span class="btn btn-info game_code_span float-end"><?php echo e($gameCode); ?></span>
                <div class="form-group">
                
                <input type="hidden" class="form-control" id="gameCode" name="game_code" value="<?php echo e($gameCode); ?>" readonly>
                <?php if($errors->has('game_code')): ?><span class="text-danger"><?php echo e($errors->first('game_code')); ?></span><?php endif; ?>
                </div>
            </div>
            <div class="col-md-12 mb-3">
                <div class="form-group">
                <label for="gameTitle">Game Title<span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="gameTitle" name="game_title" placeholder="Enter game title" value="<?php echo e(old('game_title')); ?>">
                <?php if($errors->has('game_title')): ?><span class="text-danger"><?php echo e($errors->first('game_title')); ?></span><?php endif; ?>
                </div>
            </div>
            <div class="col-md-12 mb-3">
                <div class="form-group">
                <label for="gameDescription">Description<span class="text-danger">*</span></label>
                <textarea rows="3" class="form-control" id="gameDescription" name="game_description" placeholder="Enter game description"><?php echo e(old('game_description')); ?></textarea>
                <?php if($errors->has('game_description')): ?><span class="text-danger"><?php echo e($errors->first('game_description')); ?></span><?php endif; ?>
                </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
              <label for="gameCategory">Category<span class="text-danger">*</span></label>
              <select class="form-control w-100" id="gameCategory" name="game_category" <?php echo e(old('game_category')); ?>>
                  <?php if($categoryList->isEmpty()): ?>
                      <option value="" style="color: red;">
                          No categories found
                      </option>
                  <?php else: ?>
                  <option value="">Select game category</option>
                  <?php endif; ?>
                      <?php $__currentLoopData = $categoryList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($category->id); ?>"><?php echo e($category->category_name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
              <?php if($errors->has('game_category')): ?>
                  <span class="text-danger"><?php echo e($errors->first('game_category')); ?></span>
              <?php endif; ?>
          </div>  
            </div>
            <div class="col-md-6 mb-3">
          <div class="form-group">
            <label for="gameStartDate">Start Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameStartDate" name="game_start_date" min="<?php echo e(date('Y-m-d')); ?>" <?php echo e(old('game_start_date')); ?>>
            <?php if($errors->has('game_start_date')): ?><span class="text-danger"><?php echo e($errors->first('game_start_date')); ?></span><?php endif; ?>
          </div>
          
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group ">
            <label for="gameEndDate">Close Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameEndDate" name="game_end_date" min="<?php echo e(date('Y-m-d')); ?>" value="<?php echo e(old('game_end_date')); ?>">
            <?php if($errors->has('game_end_date')): ?><span class="text-danger"><?php echo e($errors->first('game_end_date')); ?></span><?php endif; ?>
          </div>
            </div>
            <div class="col-md-6 mb-3">
          <div class="form-group">
            <label for="gameStartTime">Start Time<span class="text-danger">*</span></label>
            <input type="time" class="form-control" id="gameStartTime" name="game_start_time" value="<?php echo e(old('game_start_time')); ?>">
            <?php if($errors->has('game_start_time')): ?><span class="text-danger"><?php echo e($errors->first('game_start_time')); ?></span><?php endif; ?>
          </div>
          
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
            <label for="gameEndTime">Close Time<span class="text-danger">*</span></label>
            <input type="time" class="form-control" id="gameEndTime" name="game_end_time" value="<?php echo e(old('game_end_time')); ?>">
            <?php if($errors->has('game_end_time')): ?><span class="text-danger"><?php echo e($errors->first('game_end_time')); ?></span><?php endif; ?>
          </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
            <label for="gameDrawDate">Draw Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameDrawDate" name="game_draw_date" min="<?php echo e(date('Y-m-d')); ?>" value="<?php echo e(old('game_draw_date')); ?>">
            <?php if($errors->has('game_draw_date')): ?><span class="text-danger"><?php echo e($errors->first('game_draw_date')); ?></span><?php endif; ?>
          </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
            <label for="gameDrawTime">Draw Time<span class="text-danger">*</span></label>
            <input type="time" class="form-control" id="gameDrawTime" name="game_draw_time" value="<?php echo e(old('game_draw_time')); ?>">
            <?php if($errors->has('game_draw_time')): ?><span class="text-danger"><?php echo e($errors->first('game_draw_time')); ?></span><?php endif; ?>
          </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
          <label for="gameTimeZone">Time Zone<span class="text-danger">*</span></label>
          <select class="form-control" id="gameTimeZone" name="game_time_zone" value="<?php echo e(old('game_time_zone')); ?>">
            <option value="">Select Time Zone</option>
            <option value="ist">IST</option>
            <option value="gmt">GMT</option>
            <option value="uae">UAE</option>
          </select>
          <?php if($errors->has('game_time_zone')): ?><span class="text-danger"><?php echo e($errors->first('game_time_zone')); ?></span><?php endif; ?>
        </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
          <label for="gameTotalAllowedTicket">Total No's Allowed in a Ticket<span class="text-danger">*</span></label>
          
          <input type="number" class="form-control" id="gameTotalAllowedTicket" name="game_total_allowed_ticket" placeholder="Enter total allowed tickets">
          <?php if($errors->has('game_total_allowed_ticket')): ?><span class="text-danger"><?php echo e($errors->first('game_total_allowed_ticket')); ?></span><?php endif; ?>
          <div id="minMaxRangeContainer"></div>
        </div>
        </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
          <label for="gameTicketPrize">Price of the Ticket(in $)<span class="text-danger">*</span></label>
          <input type="number" class="form-control" id="gameTicketPrize" name="game_ticket_prize" placeholder="Enter ticket prize" value="<?php echo e(old('game_ticket_prize')); ?>">
          <?php if($errors->has('game_ticket_prize')): ?><span class="text-danger"><?php echo e($errors->first('game_ticket_prize')); ?></span><?php endif; ?>
        </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
          <label for="gameStatus">Game Status<span class="text-danger">*</span></label>
          <select class="form-control" id="gameStatus" name="game_status">
            <option value="1">Active</option>
            <option value="0">Inactive</option>
            <option value="2">Closed</option>
          </select>
          <?php if($errors->has('game_status')): ?><span class="text-danger"><?php echo e($errors->first('game_status')); ?></span><?php endif; ?>
        </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="form-group">
          <label for="featured_image">Featured Image<span class="text-danger">*Notice:Image size must not be above 5mb</span></label>
          <input type="file" class="form-control" name="featured_image" id="featured_image">
          <?php if($errors->has('featured_image')): ?><span class="text-danger"><?php echo e($errors->first('featured_image')); ?></span><?php endif; ?>
          <!-- Image preview container -->
        <div id="image_preview_container" class="mt-3"></div>
        </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
          <button type="submit" class="btn btn-primary btn-main float-end">Save Game</button> 
        </div>
            </div>
        </div>
      </form>
    </div>
  </div>
</div>
<?php $__env->startPush('scripts'); ?>
<script>

$('#gameStartDate').change(function(){
  $('#gameEndDate').prop('min', $(this).val());
  $('#gameEndDate').val('');
  $('#gameDrawDate').prop('min', $(this).val());
  $('#gameDrawDate').val('');
});

$('#gameEndDate').change(function(){
  $('#gameDrawDate').prop('min', $(this).val());
  $('#gameDrawDate').val('');
});

  $(document).ready(function() {
    // When a file is selected, show the preview
    $("#featured_image").change(function(){
      // Clear the previous preview
      $("#image_preview_container").html("");

      // Get the selected file
      var file = this.files[0];

      // Check if the file is an image
      if (file && file.type.match(/^image\//)) {
        var reader = new FileReader();

        reader.onload = function(e) {
          // Create an image element and set the source to the selected file
          var img = $("<img>").attr("src", e.target.result).addClass("img-thumbnail").height(200).width(200);
          
          // Append the image to the preview container
          $("#image_preview_container").append(img);
        }

        // Read the file as a URL
        reader.readAsDataURL(file);
      }
    });
  });

  $(document).ready(function() {
    $('#gameTotalAllowedTicket').on('blur', function() {
        var value = parseInt($(this).val());
        var container = $('#minMaxRangeContainer');
        container.empty(); // Clear previous content

        for (var i = 0; i < value; i++) {
            var count = i + 1; // Calculate the count starting from 1

            var div = $('<div>').addClass('form-row min-max-range')
                .append($('<div>').addClass('tb-row d-flex align-items-center')
                    .append($('<div>').addClass('tb-col')
                        .append($('<span>').text(count))) // Set the count in the span element
                    .append($('<div>').addClass('tb-col')
                        .append($('<input>').attr({
                            type: 'number',
                            class: 'form-control',
                            id: 'gameMinRange',
                            name: 'game_min_range[' + i + '][]',
                            placeholder: 'Enter Min Range',
                            min: '1'
                        })))
                    .append($('<div>').addClass('tb-col')
                        .append($('<input>').attr({
                            type: 'number',
                            class: 'form-control',
                            id: 'gameMaxRange',
                            name: 'game_max_range[' + i + '][]',
                            placeholder: 'Enter Max Range',
                            min: '1',
                        })))
                );

            container.append(div);
        }
    });
});


</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\Lotto\resources\views/admin/game_details/create.blade.php ENDPATH**/ ?>