

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="container">
            <div class="card">
                <div class="card-body">
        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>
        <h1>Edit Advertisement</h1>
        <a href="<?php echo e(route('admin.advertisements.index')); ?>" class="btn btn-primary">
            <i class="fas fa-arrow-left"></i> Back
        </a>
        <form action="<?php echo e(route('admin.advertisements.update', $advertisement)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="form-group">
                <label for="page">Page<span class="text-danger">*</span></label>
                <select name="page" id="page" class="form-control" required>
                    <option value="">Select Page</option>
                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($page->id); ?>" <?php echo e($advertisement->page == $page->id ? 'selected' : ''); ?>>
                            <?php echo e($page->page_name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('page')): ?>
                    <span class="text-danger"><?php echo e($errors->first('page')); ?></span>
                <?php endif; ?>
          </div>
            

          <div class="form-group">
            <label for="position">Position<span class="text-danger">*</span></label>
            <select name="position" id="position" class="form-control" required>
                <option value="">Select Position</option>
                <?php $__currentLoopData = $positions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $position): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($position->id); ?>" <?php echo e($advertisement->position == $position->id ? 'selected' : ''); ?>>
                        <?php echo e($position->position); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php if($errors->has('position')): ?>
                <span class="text-danger"><?php echo e($errors->first('position')); ?></span>
            <?php endif; ?>
        </div>
        
        <div class="form-group">
            <label for="image">Image<span class="text-danger">*</span></label>
            <div id="image-preview-container">
                <?php if($imageUrl): ?>
                    <img id="image-preview" src="<?php echo e(asset($advertisement->image)); ?>" alt="Image Preview" style="max-width: 200px; max-height: 200px;">
                    <span id="remove-image">❌</span>
                <?php else: ?>
                    <img id="image-preview" src="#" alt="Image Preview" style="max-width: 200px; max-height: 200px; display: none;">
                    <span id="remove-image" style="display: none;">❌</span>
                <?php endif; ?>
            </div>
            <input type="file" class="form-control" id="image" name="image">
        </div>

            <div class="form-group">
                <label for="redirection_url">Redirection URL</label>
                <input type="text" name="redirection_url" id="redirection_url" class="form-control" value="<?php echo e($advertisement->redirection_url); ?>">
            </div>

            <button type="submit" class="btn btn-primary">Update</button>
        </form>
    </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#position').on('change', function() {
            var selectedOption = $(this).val();
            var previewImage = $('#previewImage');

            if (selectedOption) {
                previewImage.css('display', 'block');
            } else {
                previewImage.css('display', 'none');
            }
        });

        $('#image').on('change', function(event) {
            var input = event.target;
            var reader = new FileReader();
            var previewContainer = $('#image-preview-container');
            var preview = $('#image-preview');
            var removeImageBtn = $('#remove-image');

            reader.onload = function() {
                preview.attr('src', reader.result);
                previewContainer.css('display', 'block');
                removeImageBtn.css('display', 'block');
            };

            if (input.files && input.files[0]) {
                reader.readAsDataURL(input.files[0]);
            }
        });

        $('#remove-image').on('click', function() {
            var input = $('#image');
            var previewContainer = $('#image-preview-container');
            var preview = $('#image-preview');
            var removeImageBtn = $('#remove-image');

            input.val('');
            preview.attr('src', '#');
            previewContainer.css('display', 'none');
            removeImageBtn.css('display', 'none');
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\bioessenza\resources\views/admin/advertisements/edit.blade.php ENDPATH**/ ?>