

<?php $__env->startSection('content'); ?>
    <div class="container">
        <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <div class="card mt-3">
            <div class="card-body">
                <div class="row">
                <div class="col-md-6">
                    <div id='table-filter-wrap'>
                        
                    </div>

                </div>
                <div class="col-md-6">
                    <a href="<?php echo e(route('admin.advertisements.create')); ?>" class="btn btn-primary" style="float: right;">Create New Advertisement</a>
                </div>
            </div>
            <table class="table table-striped data-table" id="advertisement-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Page</th>                    
                        <th>Position</th>                    
                        <th>Redirection URL</th>                    
                        <th>Ad Image</th>                    
                        <th width="105px">Actions</th>
                    </tr>
                </thead>
                <tbody>
    
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    var table = $('#advertisement-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo route('admin.advertisements.fetchdata'); ?>",
          columns: [
              {data: 'id', name: 'id'},
              {data: 'page', name: 'page'},
              {data: 'position', name: 'position'},
              {data: 'redirection_url', name: 'redirection_url'},
              {
                data: 'image',
                name: 'image',
                render: function(data, type, full, meta) {
                    if (type === 'display' && data) {
                        return '<img src="' + data + '" class="img-fluid" alt="Advertisement Image" width="200px" height="200px">';
                    } else {
                        return data;
                    }
                }
            },
              {data: 'action', name: 'action', orderable: false, searchable: false},
          ]
      });
});

</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\Lotto\resources\views/admin/advertisements/index.blade.php ENDPATH**/ ?>