

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-body">
            <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
            <?php endif; ?>
            <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
            <?php endif; ?>

            <!-- Form to add a new category -->
            <form action="<?php echo e(route('admin.categories.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="mb-3">
                    <label for="category_code" class="form-label">Category Code</label>
                    <input type="text" class="form-control" id="category_code" value="<?php echo e($randomNumber); ?>" name="category_code" readonly>
                </div>
                <div class="mb-3">
                    <label for="category_name" class="form-label">Category Name</label>
                    <input type="text" class="form-control" id="category_name" name="category_name" required>
                </div>
                <div class="mb-3">
                    <label for="image" class="form-label">Image</label>
                    <input type="file" class="form-control" id="image" name="image" required>
                </div>
                <button type="submit" class="btn btn-primary">Save</button>
            </form>

            <hr>


            <table class="table">
                <thead>
                    <tr>
                        <th>SL NO</th>
                        <th>Category Code</th>
                        <th>Category Name</th>
                        <th>Image</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $count = '1';
                    ?>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($count); ?></td>
                        <td><?php echo e($category->category_code); ?></td>
                        <td><?php echo e($category->category_name); ?></td>
                        <td>
                            <img src="<?php echo e(asset($category->image)); ?>" alt="Category Image" height="100px" width="140px">
                        </td>
                        
                        <td>
                            <form action="<?php echo e(route('admin.categories.destroy', $category->id)); ?>" method="POST"
                                class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-sm delete-btn"
                                    data-id="<?php echo e($category->id); ?>">
                                    Delete
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php
                    $count++;
                    ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <?php echo e($categories->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
                    $('.delete-btn').click(function(event) {
                        event.preventDefault();
                        var categoryId = $(this).data('id');
                        
                        Swal.fire({
                            title: 'Are you sure?',
                            text: 'You are about to delete this category!',
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#d33',
                            cancelButtonColor: '#3085d6',
                            confirmButtonText: 'Yes, delete it!'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                // Submit the form after confirmation
                                $(this).closest('form').submit();
                            }
                        });
                    });
                });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\Lotto\resources\views/admin/categories/index.blade.php ENDPATH**/ ?>