

<?php $__env->startSection('content'); ?>
<div class="container">
  <div class="card">
    <div class="card-header text-center">
      <a class="btn btn-primary float-end" href="<?php echo e(route('admin.game-details.index')); ?>"><i class="fas fa-arrow-left"></i> Back To Listing</a>
      UPDATE GAME
    </div>
    <div class="card-body">
      <form action="<?php echo e(route('admin.game-details.update', $gameDetail->id)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <span class="btn btn-info game_code_span float-end"><?php echo e($gameDetail->game_code); ?></span>
        <div class="form-group">
          <input type="hidden" class="form-control" id="gameCode" name="game_code" value="<?php echo e($gameDetail->game_code); ?>" readonly>
          <?php if($errors->has('game_code')): ?><span class="text-danger"><?php echo e($errors->first('game_code')); ?></span><?php endif; ?>
        </div>
        <div class="form-group">
          <label for="gameTitle">Game Title<span class="text-danger">*</span></label>
          <input type="text" class="form-control" id="gameTitle" name="game_title" value="<?php echo e($gameDetail->game_title); ?>" placeholder="Enter game title">
          <?php if($errors->has('game_title')): ?><span class="text-danger"><?php echo e($errors->first('game_title')); ?></span><?php endif; ?>
        </div>
        <div class="form-group">
          <label for="gameDescription">Description<span class="text-danger">*</span></label>
          <textarea class="form-control" id="gameDescription" name="game_description" placeholder="Enter game description"><?php echo e($gameDetail->game_description); ?></textarea>
          <?php if($errors->has('game_description')): ?><span class="text-danger"><?php echo e($errors->first('game_description')); ?></span><?php endif; ?>
        </div>
          <div class="form-group">
              <label for="gameCategory">Category<span class="text-danger">*</span></label>
              <select class="form-control w-100" id="gameCategory" name="game_category">
                  <option value="">Select game category</option>
                      <?php $__currentLoopData = $categoryList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($category->id); ?>" <?php echo e($category->id == $gameDetail->game_category ? 'selected' : ''); ?>>
                              <?php echo e($category->category_name); ?>

                          </option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
              <?php if($errors->has('game_category')): ?>
                  <span class="text-danger"><?php echo e($errors->first('game_category')); ?></span>
              <?php endif; ?>
          </div>
        <div class="form-row">
          <div class="form-group col-md-6">
            <label for="gameStartDate">Start Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameStartDate" name="game_start_date" value="<?php echo e($gameDetail->game_start_date); ?>" min="<?php echo e(date('Y-m-d')); ?>" value="<?php echo e(old('game_start_date')); ?>">
            <?php if($errors->has('game_start_date')): ?><span class="text-danger"><?php echo e($errors->first('game_start_date')); ?></span><?php endif; ?>
          </div>
          <div class="form-group col-md-6">
            <label for="gameEndDate">End Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameEndDate" name="game_end_date" value="<?php echo e($gameDetail->game_end_date); ?>" min="<?php echo e(date('Y-m-d')); ?>" value="<?php echo e(old('game_end_date')); ?>">
            <?php if($errors->has('game_end_date')): ?><span class="text-danger"><?php echo e($errors->first('game_end_date')); ?></span><?php endif; ?>
          </div>
        </div>
        <div class="form-row">
          <div class="form-group col-md-6">
            <label for="gameStartTime">Start Time<span class="text-danger">*</span></label>
            <input type="time" class="form-control" id="gameStartTime" name="game_start_time" value="<?php echo e($gameDetail->game_start_time); ?>" value="<?php echo e(old('game_start_time')); ?>">
            <?php if($errors->has('game_start_time')): ?><span class="text-danger"><?php echo e($errors->first('game_start_time')); ?></span><?php endif; ?>
          </div>
          <div class="form-group col-md-6">
            <label for="gameEndTime">End Time<span class="text-danger">*</span></label>
            <input type="time" class="form-control" id="gameEndTime" name="game_end_time" value="<?php echo e($gameDetail->game_end_time); ?>" value="<?php echo e(old('game_end_time')); ?>">
            <?php if($errors->has('game_end_time')): ?><span class="text-danger"><?php echo e($errors->first('game_end_time')); ?></span><?php endif; ?>
          </div>
        </div>
        
        <div class="form-row">
          <div class="form-group col-md-6">
            <label for="gameDrawDate">Draw Date<span class="text-danger">*</span></label>
            <input type="date" class="form-control" id="gameDrawDate" name="game_draw_date" value="<?php echo e($gameDetail->game_draw_date); ?>" min="<?php echo e(date('Y-m-d')); ?>" value="<?php echo e(old('game_draw_date')); ?>">
            <?php if($errors->has('game_draw_date')): ?><span class="text-danger"><?php echo e($errors->first('game_draw_date')); ?></span><?php endif; ?>
          </div>
          <div class="form-group col-md-6">
            <label for="gameDrawTime">Draw Time<span class="text-danger">*</span></label>
            <input type="time" class="form-control" id="gameDrawTime" name="game_draw_time" value="<?php echo e($gameDetail->game_draw_time); ?>" value="<?php echo e(old('game_draw_time')); ?>">
            <?php if($errors->has('game_draw_time')): ?><span class="text-danger"><?php echo e($errors->first('game_draw_time')); ?></span><?php endif; ?>
          </div>
        </div>
        <div class="form-group">
          <label for="gameTimeZone">Time Zone<span class="text-danger">*</span></label>
          <select class="form-control" id="gameTimeZone" name="game_time_zone">
            <option value="">Status</option>
            <option value="ist" <?php echo e($gameDetail->game_time_zone === 'ist' ? 'selected' : ''); ?>>IST</option>
            <option value="gmt" <?php echo e($gameDetail->game_time_zone === 'gmt' ? 'selected' : ''); ?>>GMT</option>
            <option value="uae" <?php echo e($gameDetail->game_time_zone === 'uae' ? 'selected' : ''); ?>>UAE</option>
          </select>
          <?php if($errors->has('game_time_zone')): ?><span class="text-danger"><?php echo e($errors->first('game_time_zone')); ?></span><?php endif; ?>
        </div>
        <div class="form-group">
          <label for="gameTotalAllowedTicket">Total No's Allowed in a Ticket<span class="text-danger">*</span></label>
          <input type="number" class="form-control" id="gameTotalAllowedTicket" name="game_total_allowed_ticket" value="<?php echo e($gameDetail->game_total_allowed_ticket); ?>" placeholder="Enter total allowed tickets">
          <?php if($errors->has('game_total_allowed_ticket')): ?><span class="text-danger"><?php echo e($errors->first('game_total_allowed_ticket')); ?></span><?php endif; ?>
        </div>
        <div class="form-group">
          <label for="gameTicketPrize">Price of the Ticket (in $)<span class="text-danger">*</span></label>
          <input type="number" class="form-control" id="gameTicketPrize" name="game_ticket_prize" value="<?php echo e($gameDetail->game_ticket_prize); ?>" placeholder="Enter ticket prize">
          <?php if($errors->has('game_ticket_prize')): ?><span class="text-danger"><?php echo e($errors->first('game_ticket_prize')); ?></span><?php endif; ?>
        </div>
        
        <div class="form-group">
          <label for="gameStatus">Game Status<span class="text-danger">*</span></label>
          <select class="form-control" id="gameStatus" name="game_status">
            <option value="1" <?php echo e($gameDetail->game_status === '1' ? 'selected' : ''); ?>>Active</option>
            <option value="0" <?php echo e($gameDetail->game_status === '0' ? 'selected' : ''); ?>>Inactive</option>
            <option value="2" <?php echo e($gameDetail->game_status === '2' ? 'selected' : ''); ?>>Closed</option>
          </select>
          <?php if($errors->has('game_status')): ?><span class="text-danger"><?php echo e($errors->first('game_status')); ?></span><?php endif; ?>
        </div>
        <div class="form-group">
          <label for="featured_image">Featured Image<span class="text-danger">*</span></label>
          <img src="<?php echo e(asset('game_images/'.$gameDetail->featured_image)); ?>" alt="<?php echo e($gameDetail->featured_image); ?>" class="img-thumbnail" height="200px" width="200px">
          <input type="hidden" name="featured_image" id=""value="<?php echo e($gameDetail->featured_image); ?>" class="form-control">
          <input type="file" name="featured_image" id="featured_image" class="form-control">
          <?php $__errorArgs = ['featured_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
              <span class="invalid-feedback" role="alert">
                  <strong><?php echo e($message); ?></strong>
              </span>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        <!-- Image preview container -->
        <div id="image_preview_container"></div>
        <div class="form-group">
          <button type="submit" class="btn btn-primary float-end">Update Game</button>
        </div>
      </form>
    </div>
  </div>
</div>
<?php $__env->startPush('scripts'); ?>
<script>
 $('#gameStartDate').change(function(){
  $('#gameEndDate').prop('min', $(this).val());
  $('#gameEndDate').val('');
  $('#gameDrawDate').prop('min', $(this).val());
  $('#gameDrawDate').val('');
});

$('#gameEndDate').change(function(){
  $('#gameDrawDate').prop('min', $(this).val());
  $('#gameDrawDate').val('');
});
    

  $(document).ready(function() {
    // When a file is selected, show the preview
    $("#featured_image").change(function(){
      // Clear the previous preview
      $("#image_preview_container").html("");

      // Get the selected file
      var file = this.files[0];

      // Check if the file is an image
      if (file && file.type.match(/^image\//)) {
        var reader = new FileReader();

        reader.onload = function(e) {
          // Create an image element and set the source to the selected file
          var img = $("<img>").attr("src", e.target.result).addClass("img-thumbnail").height(200).width(200);
          
          // Append the image to the preview container
          $("#image_preview_container").append(img);
        }

        // Read the file as a URL
        reader.readAsDataURL(file);
      }
    });
  });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\Lotto\resources\views/admin/game_details/edit.blade.php ENDPATH**/ ?>