
<?php $__env->startSection('content'); ?>
<div class="container">
    <style>
        .table th, strong, .table td:first-child{
            color: #000;
            font-size: 16px;
            font-weight: 600;
        }
        .table td img{
            height: 60px;
            width: auto;
        }
        .table th{
            background: #ddd;
            padding-top: 15px;
            padding-bottom: 15px;
            border-top: 1px solid #cbcbcb !important;
        }
        .table td{
            background: #fff;
        }
        .table{
            --bs-table-border-color: #cbcbcb !important;
        }
        table#games-table{
            border-top: 1px solid #cbcbcb !important;
        }
        button.badge{
            border: unset;
        }
        .card{
            border: none;
            box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);
        }
    </style>
  <div class="card mt-4">
      <div class="card-body">
          <?php if(session('success')): ?>
          <div class="alert alert-success">
              <?php echo e(session('success')); ?>

          </div>
          <?php endif; ?>
          <?php if(session('error')): ?>
          <div class="alert alert-danger">
              <?php echo e(session('error')); ?>

          </div>
          <?php endif; ?>
          <div class="d-flex justify-content-between align-items-center">
            <h1>Manage Ticket</h1>
            
        </div>
       
        <div style="margin: 20px 0px;">
            <div style="display: flex; align-items: center;">
              <strong style="margin-right: 10px;">Filter By Draw Date:</strong>
              <input type="date" name="daterange" id="draw-date-filter" value="" class="form-control" style="flex: 0 0 150px; max-width: 150px;" />
              
              
            </div>
          </div>
          
          
        

        <table id="ticket-list" class="display" style="width:100%">
            <thead>
                <tr>
                    <th>SL NO</th>
                    <th>Ticket Code</th>                    
                    <th>Ticket No</th>                    
                    <th>Ticket Date</th>                    
                    
                    <th width="305px"></th>
                </tr>
            </thead>
            <tbody>
                <?php
                $row = 1;    
                ?>
                <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($row); ?></td>
                    <td><?php echo e($ticket->ticket_code); ?></td>
                    <td><?php echo e($ticket->id); ?></td>
                    <td><?php echo e($ticket->created_at); ?></td>
                    
                    <td>
                        <div class="btn-group" role="group" aria-label="Button Group">
                            <a href="<?php echo e(route('admin.show.ticket', ['id' => $ticket->id])); ?>" class="btn btn-primary btn-sm me-1">VIEW</a>
                        </div>
                    </td>
                </tr>
                <?php
                    $row++;
                ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
</div>
<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/select/1.3.3/js/dataTables.select.min.js"></script>
<script>
    new DataTable('#ticket-list');

    $(document).ready(function() {
    var table = $('#ticket-list').DataTable();

    $('#draw-date-filter').on('change', function() {
        var drawDate = $(this).val(); // Get the selected draw date

        table.column(3).search(drawDate).draw(); // Apply the draw date filter on the "Ticket Date" column (index 3)
    });
});
</script>

<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\Lotto\resources\views/admin/ticket_management/list.blade.php ENDPATH**/ ?>