

<?php $__env->startSection('content'); ?>      
<style>
    .center {
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .game_closing_date {
        font-size: 20px;
        width: 300px;
        position: relative;
        left: 500px;
        background-color: #20103a !important;
        color: white;
        text-align: center;
    }
    .category-label {
        position: absolute;
        color: white;
        left: 690px;
        top: 83px;
    }
    .game_closing_date {
        padding: 12px 15px;
        border-radius: 8px;
    }
    .game-list{
        background: transparent !important;
    }
    .game-list .col-md-4 {
    justify-content: end;
    align-items: center;
    display: flex;
    flex-wrap: nowrap;
    flex-direction: column;
    }
    .game-list .card {
        padding: 30px;
    }
    .game-gif{
        width: 95px;
    }
    .game-list .card {
        box-shadow: rgb(254 254 254 / 22%) 0px 5px 15px;
        border-radius: 10px;
        border: 1px solid #ffffff38;
    }
</style>
<div class="mt-4">
    <select class="category_filter" style="position: absolute;left: 28%;color: white;top: 143px;background: #20103A;border-radius: 13px;padding: 15px 25px;">
        <option value="">Category</option>
        <?php $__currentLoopData = $categoryList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($category->id); ?>"><?php echo e($category->category_name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    <div class="close-date" class="">
        <input type="date" name="closing_date" id="" class="game_closing_date" value="<?php echo e(date('Y-m-d')); ?>">
    </div>
    
    <div class="bg-white game-list position-relative overflow-hidden" style="margin-top: 30px;">
        <div class="row mb-3" id="gameList">
            <?php $__empty_1 = true; $__currentLoopData = $gameList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $game): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-md-12 mrt">
                <div class="card">
                    <div class="row align-items-center">
                        <div class="col-md-8 p-2">
                            <div class="d-flex align-items-center mb-3">
                                <div class="game-gif d-flex justify-content-center align-items-center">
                                    <img src="<?php echo e(asset('game-animation.gif')); ?>" alt="" style="width:64px; height: auto;" />
                                </div>
                                <h2 class="text-uppercase mb-0"><?php echo e($game->game_title); ?></h2>
                            </div>
                            <div class="d-flex pl-20 text-white">
                                <!-- Game description -->
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right-circle" viewBox="0 0 16 16">
                                        <path fill-rule="evenodd" d="M1 8a7 7 0 1 0 14 0A7 7 0 0 0 1 8zm15 0A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM4.5 7.5a.5.5 0 0 0 0 1h5.793l-2.147 2.146a.5.5 0 0 0 .708.708l3-3a.5.5 0 0 0 0-.708l-3-3a.5.5 0 1 0-.708.708L10.293 7.5H4.5z" />
                                    </svg>
                                </div>
                                <h4 class="pl-20 text-white"><?php echo e($game->game_description); ?></h4>
                            </div>
                            
                            <div class="d-flex pl-20 text-white">
                                <!-- Game status -->
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-calendar-check" viewBox="0 0 16 16">
                                        <path fill-rule="evenodd" d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z" />
                                        <path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z" />
                                    </svg>
                                </div>
                                <h4 class="pl-20 text-white"><?php echo e(\Carbon\Carbon::parse($game->game_end_date)->format('jS F Y')); ?> <?php echo e(date('g:i A',
                                    strtotime($game->game_end_time))); ?></h4>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="quiz-img">
                                <?php if($game->featured_image): ?>
                                    <img src="<?php echo e(asset('game_images/'.$game->featured_image)); ?>" class="rounded d-block" alt="" style="height: 100px;width: 100px;">
                                <?php else: ?>
                                    <img src="<?php echo e(asset('logo.png')); ?>" class="rounded d-block" alt="" style="height: auto;width: 100px;">
                                <?php endif; ?>
                            </div>
                            <div class="mt-2 mb-3">
                                <?php
                                    @$gameEndTime = \Carbon\Carbon::parse(@$game->game_end_date . ' ' . @$game->game_end_time);
                                    @$currentTime = \Carbon\Carbon::now();
                                    @$ticketCount = \App\Models\Ticket::where('game_id', $game->id)
                                                                     ->where('user_id', auth()->user()->id ?? null)
                                                                     ->count();
                                ?>
                            
                            <?php if(auth()->check()): ?>
                                <?php if(@$game->game_end_date < date('Y-m-d')): ?>
                                    <a href="<?php echo e(route('user.create.ticket', ['id'=>$game->id])); ?>" style="cursor: pointer;display: inline-block;text-decoration: none;">
                                        <button class="button-72" role="button">Play Now</button>
                                    </a>
                                <?php elseif(@$game->game_end_date == date('Y-m-d')): ?>
                                    <?php if(@$game->game_end_time < date('H:i:s')): ?>
                                        <?php if(@$game->game_draw_date < date('Y-m-d')): ?>
                                            <a href="<?php echo e(route('user.create.ticket', ['id'=>$game->id])); ?>" style="cursor: pointer;display: inline-block;text-decoration: none;">
                                                <button class="button-72" role="button">Play Now</button>
                                            </a>
                                        <?php else: ?>
                                            <?php if(@$ticketCount > 0): ?>
                                                <a href="<?php echo e(route('user.view.ticket')); ?>" style="cursor: pointer;display: inline-block;text-decoration: none;">
                                                    <button class="button-72" role="button">View Ticket</button>
                                                </a>
                                            <?php else: ?>
                                                <a href="<?php echo e(route('user.create.ticket', ['id'=>$game->id])); ?>" style="cursor: pointer;display: inline-block;text-decoration: none;">
                                                    <button class="button-72" role="button" disabled>Play Now</button>
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <a href="<?php echo e(route('user.create.ticket', ['id'=>$game->id])); ?>" style="cursor: pointer;display: inline-block;text-decoration: none;">
                                            <button class="button-72" role="button">Play Now</button>
                                        </a>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <a href="<?php echo e(route('user.create.ticket', ['id'=>$game->id])); ?>" style="cursor: pointer;display: inline-block;text-decoration: none;">
                                        <button class="button-72" role="button">Play Now</button>
                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>

                            </div>                          
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-md-12 mrt">
                <div class="card">
                No Games Found!
            </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>

<script>
   $(document).ready(function() {
    var gameDate = '';
    var categoryId = '';
    // Handle category change event
    // Handle category change event
    $('.game_closing_date').on('change', function() {
        gameDate = $(this).val(); // Update the gameDate variable with the selected date
        categoryId = ''; // Reset the categoryId
        if (gameDate == '') {
            location.reload();
        } else {
            filterGames(gameDate, categoryId); // Call the function to filter games
        }
    });

    $('.category_filter').on('change', function() {
        categoryId = $(this).val(); // Update the categoryId variable with the selected category ID
        gameDate = ''; // Reset the gameDate
        if (categoryId == '') {
            location.reload();
        } else {
            filterGames(gameDate, categoryId); // Call the function to filter games
        }
    });


       // Function to filter games by category
    function filterGames(gameDate) {
        // Send AJAX request to the server
        $.ajax({
            url: "<?php echo e(route('filter-games')); ?>", // Replace with the actual route URL
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {
                game_date: gameDate,
                category_id: categoryId
            },
            success: function(response) {
                // Update the game list based on the filtered games
                var gameListContainer = $('#gameList');
                gameListContainer.empty(); // Clear existing game list

                if (response.games.length > 0) {
                // Generate and append game HTML for each filtered game
                $.each(response.games, function(index, game) {
                    var gameEndDate = moment(game.game_end_date).format('D MMMM YYYY');
                    var gameEndTime = moment(game.game_end_time, 'HH:mm:ss').format('h:mm A');
                    var image = "<?php echo e(asset('game_images/')); ?>" + '/' + game.featured_image;

                    console.log(image);


                    var gameHtml = `
                        <div class="col-md-12 mrt">
                            <div class="card">
                                <div class="row">
                                    <div class="col-md-8 p-2">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="game-gif d-flex justify-content-center align-items-center">
                                                <img src="<?php echo e(asset('game-animation.gif')); ?>" alt="" style="width:64px; height: auto;" />
                                            </div>
                                            <h2 class="text-uppercase mb-0">${game.game_title}</h2>
                                        </div>
                                        <div class="d-flex pl-20 text-white">
                                            <!-- Game description -->
                                            <div>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right-circle" viewBox="0 0 16 16">
                                                    <path fill-rule="evenodd" d="M1 8a7 7 0 1 0 14 0A7 7 0 0 0 1 8zm15 0A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM4.5 7.5a.5.5 0 0 0 0 1h5.793l-2.147 2.146a.5.5 0 0 0 .708.708l3-3a.5.5 0 0 0 0-.708l-3-3a.5.5 0 1 0-.708.708L10.293 7.5H4.5z" />
                                                </svg>
                                            </div>
                                            <h4 class="pl-20 text-white">${game.game_description}</h4>
                                        </div>
                                        <div class="d-flex pl-20 text-white">
                                            <!-- Game start date -->
                                            <div>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-calendar-check" viewBox="0 0 16 16">
                                                    <path fill-rule="evenodd" d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z" />
                                                    <path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5z" />
                                                </svg>
                                            </div>
                                            <h4 class="pl-20 text-white">
                                                ${gameEndDate} ${gameEndTime}
                                            </h4>
                                        </div>
                                        </div>
                                        <div class="col-md-4">
                                        <div class="quiz-img">
                                            <img src="${image}" class="rounded d-block" alt="" style="height: 100px;width: 100px;">
                                        </div>
                                        <div class="mt-2 mb-3">
                                            <a href="/Lotto23/public/user/create-ticket/${game.id}" style="cursor: pointer; display: inline-block; text-decoration: none;">
                                                <button class="button-72" role="button">Play Now</button>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        `;

                        gameListContainer.append(gameHtml); // Append the game HTML to the game list container
                    });
                }
            },
                error: function(xhr, status, error) {
                    console.error(error); // Log any errors that occur during the AJAX request
                }
            });
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\Lotto\resources\views/welcome.blade.php ENDPATH**/ ?>