

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <div class="card">
                <div class="card-header text-center">
                    Winning Numbers
                </div>
                <form action="" method="">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="card-heading-titles">
                            <div class="heading">
                                <input type="hidden" name="game_id" value="<?php echo e($game->id); ?>">
                                <div><strong>Game Title : <?php echo e(isset($game) ? $game->game_title : 'N/A'); ?></strong> </div>
                                <div><strong>Draw Date : <?php echo e(isset($game) ? $game->game_draw_date : 'N/A'); ?></strong></div>
                            </div>
                        </div>
                        <table class="table table-bordered table-scroll mt-3" id="productTable">
                            <thead>
                                <tr>
                                    <th scope="col">SL NO</th>
                                    <th scope="col">Winning Number</th>
                                    <th scope="col">Winning Sequence</th>
                                    <th scope="col">
                                        <button class="btn btn-info" id="addBtn" type="button">
                                            <i class="fa fa-plus"></i>
                                        </button>
                                    </th>
                                </tr>
                            </thead>
                              <tbody id="tbody">
                                  <?php $__currentLoopData = $winningNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $winningNumber): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <?php if($winningNumber): ?>
                                          <tr>
                                              <td class="row-index text-center"></td>
                                              <td>
                                                  <select class="form-control" name="winning_number[]" id="">
                                                      <option value="">Select Winning Number</option>
                                                      <option value="1" <?php echo e($winningNumber->number == 1 ? 'selected' : ''); ?>>1</option>
                                                  </select>
                                              </td>
                                              <td>
                                                  <input class="form-control" type="number" name="winning_sequence[]" value="<?php echo e($winningNumber->sequence); ?>">
                                              </td>
                                              <td class="text-center">
                                                  <button class="btn btn-danger remove" type="button">Remove</button>
                                              </td>
                                          </tr>
                                      <?php endif; ?>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                              
                              </tbody>
                          </table>
                    </div>
                    <input type="submit" class="btn btn-primary" value="Submit">
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function () {
        // Denotes total number of rows
        var rowIdx = <?php echo e(count($winningNumbers)); ?>;

        // jQuery button click event to add a row
        $('#addBtn').on('click', function () {
            // Adding a row inside the tbody
            $('#tbody').append(`
                <tr>
                    <td class="row-index text-center">${++rowIdx}</td>
                    <td>
                        <select class="form-control" name="winning_number[]" id="">
                            <option value="">Select Winning Number</option>
                            <option value="1">1</option>
                        </select>
                    </td>
                    <td><input class="form-control" type="number" name="winning_sequence[]"></td>
                    <td class="text-center">
                        <button class="btn btn-danger remove" type="button">Remove</button>
                    </td>
                </tr>
            `);
        });

        // jQuery button click event to remove a row
        $('#tbody').on('click', '.remove', function () {
            // Removing the current row
            $(this).closest('tr').remove();

            // Updating the SL numbers
            updateSLNumbers();
        });

        // Function to update SL numbers
        function updateSLNumbers() {
            $('#tbody tr').each(function (index) {
                $(this).find('.row-index').text(index + 1);
            });
            rowIdx = $('#tbody tr').length; // Update the rowIdx variable
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\bioessenza\resources\views/admin/winnigs_management/edit_list.blade.php ENDPATH**/ ?>