

<?php $__env->startSection('content'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<div class="container">
  <div class="card">
    <div class="card-body">
    <?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
  <div class="card">
    <div class="card-header text-center">
      <a class="btn btn-primary float-start" href="<?php echo e(route('admin.game-details.index')); ?>"><i class="fas fa-arrow-left"></i> Back To Listing</a>
      Winning Numbers
    </div>
    <form action="<?php echo e(route('admin.winning-numbers.store')); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <div class="card-body">
        <div class="card-heading-titles" style="display: flex; align-items: center; justify-content: center;">
          <div class="heading" style="display: flex;">
            <input type="hidden" name="game_id" value="<?php echo e($game->id); ?>">
            <div style="margin-right: 20px;"><strong>Game Title:</strong></div>
            <div style="margin-right: 20px;"><?php echo e(isset($game) ? $game->game_title : 'N/A'); ?></div>
            <div style="margin-right: 20px;"><strong>Draw Date:</strong></div>
            <div><?php echo e(isset($game) ? $game->game_draw_date : 'N/A'); ?></div>
          </div>
        </div>
        <table class="table table-bordered table-scroll mt-3" id="productTable">
          <thead>
            <tr>
              <th scope="col">SL NO</th>
              <th scope="col">Winning Number</th>
              <th scope="col">Winning Sequence</th>
              <th scope="col">
                <button class="btn btn-info" id="addBtn" type="button"><i class="fa fa-plus"></i></button>
              </th>
            </tr>
          </thead>
          <tbody id="tbody">
            <?php if(isset($winningNumberList)): ?>
            <?php
            $count = 1;    
            ?>
            <?php $__currentLoopData = $winningNumberList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($count); ?></td>
              <td><?php echo e($list->number); ?></td>
              <td><?php echo e($list->sequence); ?></td>
              <td><button class="btn btn-danger delete-btn" type="button">Remove</button></td>
            </tr>
            <?php
            $count++;
            ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      
    <input type="submit" class="btn btn-primary" value="Submit">
    </form>
  </div>
</div>
<?php $__env->startPush('scripts'); ?>
<script>
  $(document).ready(function () {
            // Denotes total number of rows
            var rowIdx = 0;

            // jQuery button click event to add a row
            $('#addBtn').on('click', function () {
                var selectOptions = '';
                for (var i = 0; i <= 99; i++) {
                    selectOptions += `<option value="${i}">${i}</option>`;
                }
                // Adding a row inside the tbody
                $('#tbody').append(`
                    <tr>
                        <td class="row-index text-center">${++rowIdx}</td>
                        <td>
                          <select class="form-control" name="winning_number[]" id="">
                            <option value="">Select Winning Number</option>
                            ${selectOptions}
                        </select>
                        </td>
                        <td><input class="form-control" type="number" name="winning_sequence[]"></td>
                        <td class="text-center">
                            <button class="btn btn-danger remove" type="button">Remove</button>
                        </td>
                    </tr>
                `);
            });

            // jQuery button click event to remove a row
            $('#tbody').on('click', '.remove', function () {
                // Removing the current row
                $(this).closest('tr').remove();

                // Updating the SL numbers
                updateSLNumbers();
            });

            // Function to update SL numbers
            function updateSLNumbers() {
                $('#tbody tr').each(function (index) {
                    $(this).find('.row-index').text(index + 1);
                });
                rowIdx = $('#tbody tr').length; // Update the rowIdx variable
            }
        });
        $(document).ready(function() {
        $('.delete-btn').click(function() {
          var recordId = $(this).data('id');
          Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
          }).then(function(result) {
            if (result.isConfirmed) {
              $.ajax({
                url: "<?php echo e(route('admin.winning-numbers.delete')); ?>",
                type: 'DELETE',
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
                },
                data: {id: recordId},
                success: function(response) {
                  if (response.success) {
                    Swal.fire('Deleted!', 'The record has been deleted.', 'success');
                    // Perform any additional actions upon successful deletion
                  } else {
                    Swal.fire('Error!', 'Failed to delete the record.', 'error');
                  }
                },
                error: function() {
                  Swal.fire('Error!', 'An error occurred while deleting the record.', 'error');
                }
              });
            }
      });
    });
  });


</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\bioessenza\resources\views/admin/winnigs_management/list.blade.php ENDPATH**/ ?>