

<?php $__env->startSection('content'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<div class="container">
    <style>
        .form-control , textarea.form-control{
            min-height: 42px;
            line-height: 42px;
            padding: 0px 12px;
            height: 42px;
            border-radius: 5px;
            background: #fff;
            border-color: #e4e6fc;
            font-size: 16px;
            color: #666;
        }
        .form-control:focus , textarea.form-control:focus{
            border-color: #302B63;
            box-shadow: unset;
        }
        textarea.form-control{
            height: unset;
        }
        label {
            color: #666;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 5px
        }
        .btn-main{
            border-color: #302B63;
            background: #302B63 !important;
            color: #fff;
            padding: 0.55rem 1.5rem;
            font-size: 14px;
            font-weight: 500;
            line-height: 24px;
            letter-spacing: .5px;
            border-radius: 5px;
        }
        .btn-main:hover{
            background: #fff !important;
            color: #302B63;
        }
        .table th, strong, .table td:first-child{
            color: #000;
            font-size: 16px;
            font-weight: 600;
        }
        .table td img{
            height: 60px;
            width: auto;
        }
        .table th{
            background: #ddd;
            padding-top: 15px;
            padding-bottom: 15px;
            border-top: 1px solid #cbcbcb;
        }
        .table td{
            background: #fff;
        }
        .table{
            --bs-table-border-color: #cbcbcb;
        }
    </style>
  <div class="card mt-4" style="border: none;
  box-shadow: 0 1px 20px 0 rgba(69, 90, 100, 0.08);">
    <div class="card-body">
    <?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
  <div class="card">
    <div class="card-header text-center d-flex w-100 justify-content-between align-items-center">
        <h4 class="mb-0">Winning Numbers</h4>
      <a class="btn btn-primary float-end btn-main" href="<?php echo e(route('admin.game-details.index')); ?>"><i class="fas fa-arrow-left"></i> Back To Listing</a>
      
    </div>
    <form action="<?php echo e(route('admin.winning-numbers.store')); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <div class="card-body">
        <div class="card-heading-titles" style="display: flex; align-items: center; justify-content: center;">
          <div class="heading" style="display: flex;">
            <input type="hidden" name="game_id" value="<?php echo e($game->id); ?>">
            <div style="margin-right: 20px;"><strong>Game Title:</strong></div>
            <div style="margin-right: 20px;"><?php echo e(isset($game) ? $game->game_title : 'N/A'); ?></div>
            <div style="margin-right: 20px;"><strong>Draw Date:</strong></div>
            <div><?php echo e(isset($game) ? $game->game_draw_date : 'N/A'); ?></div>
          </div>
        </div>
        <table class="table table-bordered table-scroll mt-3" id="productTable">
          <thead>
            <tr>
              <th scope="col" class="text-center">SL NO</th>
              <th scope="col" class="text-center">Winning Number</th>
              
              <th scope="col" class="text-center">
                <button class="btn btn-success" id="addBtn" type="button" data-count="<?php echo e(count($winningNumberList)); ?>"><i class="fa fa-plus"></i></button>
              </th>
            </tr>
          </thead>
          <tbody id="tbody">
            <?php if(isset($winningNumberList)): ?>
            <?php
            $count = 1;    
            ?>
            <?php $__currentLoopData = $winningNumberList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td class="row-index text-center"><?php echo e($count); ?></td>
              <td><span class="form-control"><?php echo e($list->number); ?></span></td>
              
              <td  class="text-center"><button class="btn btn-danger delete-btn" type="button" data-id="<?php echo e($list->id); ?>">Remove</button></td>
            </tr>
            <?php
            $count++;
            ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
          </tbody>
        </table>
        <input type="button" value="Publish Result">
        <input type="submit" class="btn btn-primary btn-main mb-4" style="float: right;" value="Submit">
      </div>
      
    
    </form>
  </div>
</div>
<?php $__env->startPush('scripts'); ?>
<script>
  $(document).ready(function () {
    // var totalAllowedTickets = <?php echo e($game->game_total_allowed_ticket); ?>;
            // var winningNumbersCount = <?php echo e(count($winningNumberList)); ?>;

            // if (totalAllowedTickets === winningNumbersCount) {
                // $('#addBtn').hide();
            // }
            // Rest of your code...
            // Denotes total number of rows
            // var rowIdx = 0;
            // var maxRows = <?php echo e($game->game_total_allowed_ticket); ?>;

            // jQuery button click event to add a row
            var rowIdx =$('#addBtn').data('count');  
            $('#addBtn').on('click', function () {
                var selectOptions = '';
                for (var i = 0; i <= 99; i++) {
                    selectOptions += `<option value="${i}">${i}</option>`;
                }
                // Adding a row inside the tbody
                $('#tbody').append(`
                    <tr>
                        <td class="row-index text-center">${rowIdx+1}</td>
                        <td>
                          <select class="form-control" name="winning_number[]" id="">
                            <option value="">Select Winning Number</option>
                            ${selectOptions}
                        </select>
                        </td>
                        <td class="text-center">
                            <button class="btn btn-danger remove" type="button">Remove</button>
                        </td>
                    </tr>
                `);
                rowIdx++;
              // if ($('#tbody tr').length >= maxRows) {
              //    $('#addBtn').hide();
              // }
            });

           

            // jQuery button click event to remove a row
            $('#tbody').on('click', '.remove', function () {
                // Removing the current row
                $(this).closest('tr').remove();

                // Updating the SL numbers
                updateSLNumbers();

        //         if ($('#tbody tr').length < maxRows) {
        //     $('#addBtn').show();
        // }
            });

            // Function to update SL numbers
            function updateSLNumbers() {
                $('#tbody tr').each(function (index) {
                    $(this).find('.row-index').text(index + 1);
                });
                rowIdx = $('#tbody tr').length; // Update the rowIdx variable
            }
        });
        $(document).ready(function() {
        $('.delete-btn').click(function() {
          var recordId = $(this).data('id');
          // console.log(recordId);
          Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
          }).then(function(result) {
            if (result.isConfirmed) {
              $.ajax({
                url: "<?php echo e(route('admin.winning-numbers.delete')); ?>",
                type: 'POST',
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
                },
                data: {id: recordId},
                success: function(response) {
                  if (response.success) {
                    Swal.fire('Deleted!', 'The record has been deleted.', 'success');
                    location.reload();
                    // Perform any additional actions upon successful deletion
                  } else {
                    Swal.fire('Error!', 'Failed to delete the record.', 'error');
                    location.reload();
                  }
                },
                error: function() {
                  Swal.fire('Error!', 'An error occurred while deleting the record.', 'error');
                }
              });
            }
      });
    });
  });


</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\Lotto\resources\views/admin/winnigs_management/list.blade.php ENDPATH**/ ?>