

<?php $__env->startSection('content'); ?>
<div class="container">
    <style>
      .show-balance {
          background-color: #f7f7f7;
          border: 1px solid #ccc;
          padding: 20px;
          border-radius: 5px;
          text-align: center;
          margin-bottom: 20px;
          margin-top: 10px;
      }

      .balance-amount {
          color: #302B63;
          font-size: 32px;
          margin-top: 10px;
      }

      .pagination {
          justify-content: center;
          margin-top: 20px;
      }

      .pagination .page-item.active .page-link {
          background-color: #302B63;
          border-color: #302B63;
      }

      .pagination .page-link {
          color: #302B63;
          background-color: #fff;
          border: 1px solid #dee2e6;
      }
  </style>

    <div class="card mt-4">
        <div class="card-body">
          <a class="btn btn-primary btn-main float-end" href="<?php echo e(route('admin.users-list')); ?>"><i class="fas fa-arrow-left"></i> Back To Listing</a>

            <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
            <?php endif; ?>
            <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
            <?php endif; ?>

           
            <!-- Form to add a new category -->
            <form action="<?php echo e(route('admin.wallet.store')); ?>" method="POST">
              <?php echo csrf_field(); ?>
              <input type="hidden" name="user_id" value="<?php echo e($user->id); ?>">
              <div class="d-flex justify-content-center align-items-center">
                  <div class="col-md-4">
                      <div class="mb-3">
                          <label for="amount" class="form-label">Enter the amount</label>
                          <input type="text" class="form-control" id="amount" value="" name="amount">
                      </div>
                  </div>
              </div>
              <div class="text-center">
                  <button type="submit" class="btn btn-primary btn-main">Add Amount</button>
              </div>
          </form>

          <div class="show-balance">
            <p><strong>Total Wallet Balance:</strong></p>
            <h3 class="balance-amount">$ <?php echo e(@$wallet->amount ? @$wallet->amount : '0'); ?></h3>
          </div>
        
            <div class="table-responsive" style="padding-top: 20px;">
                <table class="table">
                    <thead>
                        <tr>
                            <th>SL NO</th>
                            <th class="text-center">Amount</th>
                            <th class="text-center">Type(Credit/Debit)</th>
                            <th class="text-center">Date</th>
                            <th class="text-center">Ticket No</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $count = 1;
                        ?>
                        <?php if(isset($wallet_transactions)): ?>
                        <?php if($wallet_transactions->count() > 0): ?>
                          <?php $__currentLoopData = $wallet_transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <tr>
                                <td class="text-center"><?php echo e($count++); ?></td>
                                <td class="text-center"><?php echo e(@$transaction->amount); ?></td>
                                <td class="text-center">
                                  <?php if(@$transaction->type == 1): ?>
                                      <span style="color: green;">Credit</span>
                                  <?php elseif(@$transaction->type == 2): ?>
                                      <span style="color: red;">Debit</span>
                                  <?php else: ?>
                                      N/A
                                  <?php endif; ?>
                                </td>
                                <td class="text-center"><?php echo e(@$transaction->created_at->format('Y-m-d')); ?></td>
                                <td class="text-center"><?php echo e(@$transaction->ticket_id); ?></td>
                              </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                    </tbody>
                </table>
                <div class="pagination justify-content-center">
                    <?php echo e(@$wallet_transactions->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('form').submit(function(e) {
            var amount = $('#amount').val();
            if (amount === '') {
                e.preventDefault();
                $('#amount').addClass('is-invalid');
                $('<div class="invalid-feedback" style="color: red;">Please enter the amount</div>').insertAfter('#amount');
            }
        });

        $('#amount').on('input', function() {
            // Remove non-digit characters
            $(this).val($(this).val().replace(/[^0-9]/g, ''));
          });

          $('#amount').on('keypress', function(e) {
            var keyCode = e.which;
            // Check if the entered key is a digit or the minus sign
            if (keyCode != 45 && (keyCode < 48 || keyCode > 57)) {
              e.preventDefault();
            }
          });
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\Lotto\resources\views/admin/wallet/create.blade.php ENDPATH**/ ?>